/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.SimpleSequence;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.RowBasedCursor;
import org.apache.druid.segment.RowWalker;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class RowBasedStorageAdapter<RowType>
implements StorageAdapter {
    private final Sequence<RowType> rowSequence;
    private final RowAdapter<RowType> rowAdapter;
    private final RowSignature rowSignature;

    public RowBasedStorageAdapter(Sequence<RowType> rowSequence, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
        this.rowSequence = (Sequence)Preconditions.checkNotNull(rowSequence, (Object)"rowSequence");
        this.rowAdapter = (RowAdapter)Preconditions.checkNotNull(rowAdapter, (Object)"rowAdapter");
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
    }

    public static boolean isQueryGranularityAllowed(Interval interval, Granularity granularity) {
        return Granularities.ALL.equals(granularity) || !Intervals.ETERNITY.equals((Object)interval);
    }

    @Override
    public Interval getInterval() {
        return Intervals.ETERNITY;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>((List<String>)new ArrayList<String>(this.rowSignature.getColumnNames()));
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return Collections.emptyList();
    }

    @Override
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    @Override
    public int getDimensionCardinality(String column) {
        return -1;
    }

    @Override
    public DateTime getMinTime() {
        return this.getInterval().getStart();
    }

    @Override
    public DateTime getMaxTime() {
        return this.getInterval().getEnd().minus(1L);
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        return null;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return RowBasedColumnSelectorFactory.getColumnCapabilities(this.rowSignature, column);
    }

    @Override
    public int getNumRows() {
        Iterable rowIterable;
        if (this.rowSequence instanceof SimpleSequence && (rowIterable = ((SimpleSequence)this.rowSequence).getIterable()) instanceof Collection) {
            return ((Collection)rowIterable).size();
        }
        throw new UnsupportedOperationException("Cannot retrieve number of rows");
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    public Metadata getMetadata() {
        throw new UnsupportedOperationException("Cannot retrieve metadata");
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval queryInterval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        Interval actualInterval = queryInterval.overlap((ReadableInterval)new Interval((ReadableInstant)this.getMinTime(), (ReadableInstant)gran.bucketEnd(this.getMaxTime())));
        if (actualInterval == null) {
            return Sequences.empty();
        }
        if (!RowBasedStorageAdapter.isQueryGranularityAllowed(actualInterval, gran)) {
            throw new IAE("Cannot support interval [%s] with granularity [%s]", Intervals.ETERNITY.equals((Object)actualInterval) ? "ETERNITY" : actualInterval, gran);
        }
        RowWalker<RowType> rowWalker = new RowWalker<RowType>(descending ? RowBasedStorageAdapter.reverse(this.rowSequence) : this.rowSequence, this.rowAdapter);
        Iterable<Interval> bucketIntervals = gran.getIterable(actualInterval);
        return Sequences.simple(Iterables.transform(descending ? RowBasedStorageAdapter.reverse(bucketIntervals) : bucketIntervals, bucketInterval -> new RowBasedCursor<RowType>(rowWalker, this.rowAdapter, filter, (Interval)bucketInterval, virtualColumns, gran, descending, this.rowSignature))).withBaggage(rowWalker::close);
    }

    private static <T> Sequence<T> reverse(Sequence<T> sequence) {
        if (sequence instanceof SimpleSequence) {
            return Sequences.simple(RowBasedStorageAdapter.reverse(((SimpleSequence)sequence).getIterable()));
        }
        return Sequences.simple(Lists.reverse(sequence.toList()));
    }

    private static <T> Iterable<T> reverse(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return Lists.reverse((List)((List)iterable));
        }
        return Lists.reverse((List)Lists.newArrayList(iterable));
    }
}

