/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class FixedIndexedWriter<T>
implements DictionaryWriter<T> {
    private static final int PAGE_SIZE = 4096;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final TypeStrategy<T> typeStrategy;
    private final Comparator<T> comparator;
    private final ByteBuffer scratch;
    private final ByteBuffer readBuffer;
    private int numWritten;
    @Nullable
    private WriteOutBytes valuesOut = null;
    private boolean hasNulls = false;
    private boolean isSorted;
    @Nullable
    private T prevObject = null;
    private final int width;

    public FixedIndexedWriter(SegmentWriteOutMedium segmentWriteOutMedium, TypeStrategy<T> typeStrategy, ByteOrder byteOrder, int width, boolean isSorted) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.typeStrategy = typeStrategy;
        this.width = width;
        this.comparator = Comparator.nullsFirst(typeStrategy);
        this.scratch = ByteBuffer.allocate(width).order(byteOrder);
        this.readBuffer = ByteBuffer.allocate(width).order(byteOrder);
        this.isSorted = isSorted;
    }

    @Override
    public boolean isSorted() {
        return this.isSorted;
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public int getCardinality() {
        return this.hasNulls ? this.numWritten + 1 : this.numWritten;
    }

    @Override
    public long getSerializedSize() {
        return 6L + this.valuesOut.size();
    }

    @Override
    public void write(@Nullable T objectToWrite) throws IOException {
        if (this.prevObject != null && this.isSorted && this.comparator.compare(this.prevObject, objectToWrite) >= 0) {
            throw new ISE("Values must be sorted and unique. Element [%s] with value [%s] is before or equivalent to [%s]", this.numWritten, objectToWrite, this.prevObject);
        }
        if (objectToWrite == null) {
            this.hasNulls = true;
            return;
        }
        this.scratch.clear();
        this.typeStrategy.write(this.scratch, objectToWrite, this.width);
        this.scratch.flip();
        Channels.writeFully(this.valuesOut, this.scratch);
        ++this.numWritten;
        this.prevObject = objectToWrite;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.scratch.clear();
        this.scratch.put((byte)0);
        byte flags = 0;
        if (this.hasNulls) {
            flags = (byte)(flags | 1);
        }
        if (this.isSorted) {
            flags = (byte)(flags | 2);
        }
        this.scratch.put(flags);
        this.scratch.flip();
        Channels.writeFully(channel, this.scratch);
        this.scratch.clear();
        this.scratch.putInt(this.numWritten);
        this.scratch.flip();
        Channels.writeFully(channel, this.scratch);
        this.valuesOut.writeTo(channel);
    }

    @Override
    @Nullable
    public T get(int index) throws IOException {
        if (index == 0 && this.hasNulls) {
            return null;
        }
        int startOffset = (this.hasNulls ? index - 1 : index) * this.width;
        this.readBuffer.clear();
        this.valuesOut.readFully(startOffset, this.readBuffer);
        this.readBuffer.clear();
        return this.typeStrategy.read(this.readBuffer);
    }

    public Iterator<T> getIterator() {
        final ByteBuffer iteratorBuffer = ByteBuffer.allocate(this.width * 4096).order(this.readBuffer.order());
        final int totalCount = this.hasNulls ? 1 + this.numWritten : this.numWritten;
        final int startPos = this.hasNulls ? 1 : 0;
        return new Iterator<T>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < totalCount;
            }

            @Override
            public T next() {
                if (this.pos == 0 && FixedIndexedWriter.this.hasNulls) {
                    ++this.pos;
                    return null;
                }
                if (this.pos == startPos || iteratorBuffer.position() >= iteratorBuffer.limit()) {
                    this.readPage();
                }
                Object value = FixedIndexedWriter.this.typeStrategy.read(iteratorBuffer);
                ++this.pos;
                return value;
            }

            private void readPage() {
                iteratorBuffer.clear();
                try {
                    if (FixedIndexedWriter.this.numWritten - (this.pos - startPos) < 4096) {
                        int size = (FixedIndexedWriter.this.numWritten - (this.pos - startPos)) * FixedIndexedWriter.this.width;
                        iteratorBuffer.limit(size);
                        FixedIndexedWriter.this.valuesOut.readFully((long)(this.pos - startPos) * (long)FixedIndexedWriter.this.width, iteratorBuffer);
                    } else {
                        FixedIndexedWriter.this.valuesOut.readFully((long)(this.pos - startPos) * (long)FixedIndexedWriter.this.width, iteratorBuffer);
                    }
                    iteratorBuffer.clear();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

