/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.index.BitmapColumnIndex;

public class AllFalseBitmapColumnIndex
implements BitmapColumnIndex {
    private final BitmapFactory bitmapFactory;
    @Nullable
    private final ImmutableBitmap unknownBitmap;

    public AllFalseBitmapColumnIndex(BitmapFactory bitmapFactory) {
        this(bitmapFactory, null);
    }

    public AllFalseBitmapColumnIndex(BitmapFactory bitmapFactory, @Nullable ImmutableBitmap unknownBitmap) {
        this.bitmapFactory = bitmapFactory;
        this.unknownBitmap = unknownBitmap;
    }

    @Override
    public ColumnIndexCapabilities getIndexCapabilities() {
        return SimpleColumnIndexCapabilities.getConstant();
    }

    @Override
    public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
        if (includeUnknown && this.unknownBitmap != null) {
            return bitmapResultFactory.wrapDimensionValue(this.unknownBitmap);
        }
        return bitmapResultFactory.wrapAllFalse(this.bitmapFactory.makeEmptyImmutableBitmap());
    }
}

