/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.DictionaryScanningBitmapIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;

public final class IndexedStringDruidPredicateIndexes<TDictionary extends Indexed<String>>
implements DruidPredicateIndexes {
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;

    public IndexedStringDruidPredicateIndexes(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps) {
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
    }

    @Override
    @Nullable
    public BitmapColumnIndex forPredicate(DruidPredicateFactory matcherFactory) {
        final DruidObjectPredicate<String> stringPredicate = matcherFactory.makeStringPredicate();
        return new DictionaryScanningBitmapIndex(this.dictionary.size()){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable(final boolean includeUnknown) {
                return () -> new Iterator<ImmutableBitmap>(){
                    @Nullable
                    String next;
                    boolean nextSet;
                    final Iterator iterator;
                    {
                        this.iterator = IndexedStringDruidPredicateIndexes.this.dictionary.iterator();
                        this.next = null;
                        this.nextSet = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.nextSet) {
                            this.findNext();
                        }
                        return this.nextSet;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (!this.nextSet) {
                            this.findNext();
                            if (!this.nextSet) {
                                throw new NoSuchElementException();
                            }
                        }
                        this.nextSet = false;
                        int idx = IndexedStringDruidPredicateIndexes.this.dictionary.indexOf(this.next);
                        if (idx < 0) {
                            return IndexedStringDruidPredicateIndexes.this.bitmapFactory.makeEmptyImmutableBitmap();
                        }
                        ImmutableBitmap bitmap = (ImmutableBitmap)IndexedStringDruidPredicateIndexes.this.bitmaps.get(idx);
                        return bitmap == null ? IndexedStringDruidPredicateIndexes.this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
                    }

                    private void findNext() {
                        while (!this.nextSet && this.iterator.hasNext()) {
                            String nextValue = (String)this.iterator.next();
                            this.nextSet = stringPredicate.apply(nextValue).matches(includeUnknown);
                            if (!this.nextSet) continue;
                            this.next = nextValue;
                        }
                    }
                };
            }
        };
    }
}

