/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class ScalarNestedCommonFormatColumnSerializer<T>
extends NestedCommonFormatColumnSerializer {
    protected static final Logger log = new Logger(ScalarNestedCommonFormatColumnSerializer.class);
    protected final String name;
    protected final SegmentWriteOutMedium segmentWriteOutMedium;
    protected final IndexSpec indexSpec;
    protected final Closer closer;
    protected DictionaryIdLookup dictionaryIdLookup;
    protected DictionaryWriter<T> dictionaryWriter;
    protected boolean closedForWrite = false;
    protected boolean dictionarySerialized = false;
    protected FixedIndexedIntWriter intermediateValueWriter;
    protected ByteBuffer columnNameBytes = null;
    protected boolean hasNulls;

    public ScalarNestedCommonFormatColumnSerializer(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
    }

    protected abstract int processValue(@Nullable Object var1) throws IOException;

    protected abstract void openValueColumnSerializer() throws IOException;

    protected abstract void writeValueColumn(FileSmoosher var1) throws IOException;

    protected abstract void writeDictionaryFile(FileSmoosher var1) throws IOException;

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getGlobalLookup() {
        return this.dictionaryIdLookup;
    }

    @Override
    public boolean hasNulls() {
        return this.hasNulls;
    }

    @Override
    public void open() throws IOException {
        if (!this.dictionarySerialized) {
            throw new IllegalStateException("Dictionary not serialized, cannot open value serializer");
        }
        this.intermediateValueWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, false);
        this.intermediateValueWriter.open();
        this.openValueColumnSerializer();
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        if (!this.dictionarySerialized) {
            throw new ISE("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        Object value = StructuredData.unwrap(selector.getObject());
        int dictId = this.processValue(value);
        this.intermediateValueWriter.write(dictId);
        this.hasNulls = this.hasNulls || dictId == 0;
    }

    private void closeForWrite() {
        if (!this.closedForWrite) {
            this.columnNameBytes = this.computeFilenameBytes();
            this.closedForWrite = true;
        }
    }

    @Override
    public long getSerializedSize() {
        this.closeForWrite();
        long size = 1 + this.columnNameBytes.capacity();
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        String filenameBase = StringUtils.format("%s.forward_dim", this.name);
        CompressionStrategy compression = this.indexSpec.getDimensionCompression();
        CompressionStrategy compressionToUse = compression != CompressionStrategy.UNCOMPRESSED && compression != CompressionStrategy.NONE ? compression : CompressionStrategy.LZ4;
        CompressedVSizeColumnarIntsSerializer encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.name, this.segmentWriteOutMedium, filenameBase, this.dictionaryWriter.getCardinality(), compressionToUse, this.segmentWriteOutMedium.getCloser());
        encodedValueSerializer.open();
        GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        bitmapIndexWriter.open();
        bitmapIndexWriter.setObjectsNotSorted();
        MutableBitmap[] bitmaps = new MutableBitmap[this.dictionaryWriter.getCardinality()];
        for (int i = 0; i < bitmaps.length; ++i) {
            bitmaps[i] = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
        }
        IntIterator rows = this.intermediateValueWriter.getIterator();
        int rowCount = 0;
        while (rows.hasNext()) {
            int dictId = rows.nextInt();
            ((SingleValueColumnarIntsSerializer)encodedValueSerializer).addValue(dictId);
            bitmaps[dictId].add(rowCount++);
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            MutableBitmap bitmap = bitmaps[i];
            bitmapIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
            bitmaps[i] = null;
        }
        this.writeV0Header(channel, this.columnNameBytes);
        this.writeDictionaryFile(smoosher);
        this.writeInternal(smoosher, encodedValueSerializer, "__encodedColumn");
        this.writeValueColumn(smoosher);
        this.writeInternal(smoosher, bitmapIndexWriter, "__valueIndexes");
        log.info("Column [%s] serialized successfully.", this.name);
    }
}

