/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.NestedDataColumnSupplier;
import org.apache.druid.segment.nested.ScalarDoubleColumnAndIndexSupplier;
import org.apache.druid.segment.nested.ScalarLongColumnAndIndexSupplier;
import org.apache.druid.segment.nested.ScalarStringColumnAndIndexSupplier;
import org.apache.druid.segment.nested.VariantColumnAndIndexSupplier;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;

public class NestedCommonFormatColumnPartSerde
implements ColumnPartSerde {
    private final ColumnType logicalType;
    private final boolean hasNulls;
    private final boolean isVariantType;
    private final boolean enforceLogicalType;
    private final ByteOrder byteOrder;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    @Nullable
    private final Serializer serializer;

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    public static ByteBuffer loadInternalFile(SmooshedFileMapper fileMapper, String fileNameBase, String internalFileName) throws IOException {
        return fileMapper.mapFile(NestedCommonFormatColumnSerializer.getInternalFileName(fileNameBase, internalFileName));
    }

    @JsonCreator
    public static NestedCommonFormatColumnPartSerde createDeserializer(@JsonProperty(value="logicalType") ColumnType logicalType, @JsonProperty(value="hasNulls") boolean hasNulls, @JsonProperty(value="isVariantType") boolean isVariantType, @JsonProperty(value="enforceLogicalType") boolean enforceLogicalType, @JsonProperty(value="byteOrder") ByteOrder byteOrder, @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory) {
        return new NestedCommonFormatColumnPartSerde(logicalType, hasNulls, isVariantType, enforceLogicalType, byteOrder, bitmapSerdeFactory, null);
    }

    private NestedCommonFormatColumnPartSerde(ColumnType logicalType, boolean hasNulls, boolean isVariant, boolean enforceLogicalType, ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, @Nullable Serializer serializer) {
        this.logicalType = logicalType;
        this.hasNulls = hasNulls;
        this.isVariantType = isVariant;
        this.enforceLogicalType = enforceLogicalType;
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        if (this.isVariantType || this.logicalType.isArray()) {
            return new VariantColumnDeserializer();
        }
        if (this.logicalType.is(ValueType.STRING)) {
            return new StringColumnDeserializer();
        }
        if (this.logicalType.is(ValueType.LONG)) {
            return new LongColumnDeserializer();
        }
        if (this.logicalType.is(ValueType.DOUBLE)) {
            return new DoubleColumnDeserializer();
        }
        return new NestedColumnDeserializer();
    }

    @JsonProperty
    public ColumnType getLogicalType() {
        return this.logicalType;
    }

    @JsonProperty
    public boolean isHasNulls() {
        return this.hasNulls;
    }

    @JsonProperty(value="isVariantType")
    public boolean isVariantType() {
        return this.isVariantType;
    }

    @JsonProperty(value="enforceLogicalType")
    public boolean enforceLogicalType() {
        return this.enforceLogicalType;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    public static class SerializerBuilder {
        private ColumnType logicalType = ColumnType.NESTED_DATA;
        private boolean hasNulls;
        private boolean isVariantType;
        private boolean enforceLogicalType;
        private ByteOrder byteOrder = ByteOrder.nativeOrder();
        BitmapSerdeFactory bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
        @Nullable
        private Serializer serializer = null;

        public SerializerBuilder withLogicalType(ColumnType logicalType) {
            this.logicalType = logicalType;
            return this;
        }

        public SerializerBuilder isVariantType(boolean isVariant) {
            this.isVariantType = isVariant;
            return this;
        }

        public SerializerBuilder withSerializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory serdeFactory) {
            this.bitmapSerdeFactory = serdeFactory;
            return this;
        }

        public SerializerBuilder withHasNulls(boolean hasNulls) {
            this.hasNulls = hasNulls;
            return this;
        }

        public SerializerBuilder withEnforceLogicalType(boolean enforceLogicalType) {
            this.enforceLogicalType = enforceLogicalType;
            return this;
        }

        public NestedCommonFormatColumnPartSerde build() {
            return new NestedCommonFormatColumnPartSerde(this.logicalType, this.hasNulls, this.isVariantType, this.enforceLogicalType, this.byteOrder, this.bitmapSerdeFactory, this.serializer);
        }
    }

    private class NestedColumnDeserializer
    implements ColumnPartSerde.Deserializer {
        private NestedColumnDeserializer() {
        }

        @Override
        public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
            NestedDataColumnSupplier supplier = NestedDataColumnSupplier.read(NestedCommonFormatColumnPartSerde.this.logicalType, NestedCommonFormatColumnPartSerde.this.hasNulls, buffer, builder, columnConfig, NestedCommonFormatColumnPartSerde.this.bitmapSerdeFactory, NestedCommonFormatColumnPartSerde.this.byteOrder);
            ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
            capabilitiesBuilder.setDictionaryEncoded(true);
            capabilitiesBuilder.setDictionaryValuesSorted(true);
            capabilitiesBuilder.setDictionaryValuesUnique(true);
            ColumnType simpleType = supplier.getLogicalType();
            ColumnType logicalType = simpleType == null ? ColumnType.NESTED_DATA : simpleType;
            builder.setType(logicalType);
            builder.setHasNulls(NestedCommonFormatColumnPartSerde.this.hasNulls);
            builder.setNestedCommonFormatColumnSupplier(supplier);
            if (NullHandling.sqlCompatible() && NestedCommonFormatColumnPartSerde.this.hasNulls) {
                builder.setIndexSupplier(supplier, false, false);
            }
            builder.setColumnFormat(new NestedCommonFormatColumn.Format(logicalType, NestedCommonFormatColumnPartSerde.this.hasNulls, NestedCommonFormatColumnPartSerde.this.enforceLogicalType));
        }
    }

    private class VariantColumnDeserializer
    implements ColumnPartSerde.Deserializer {
        private VariantColumnDeserializer() {
        }

        @Override
        public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
            VariantColumnAndIndexSupplier supplier = VariantColumnAndIndexSupplier.read(NestedCommonFormatColumnPartSerde.this.logicalType, NestedCommonFormatColumnPartSerde.this.byteOrder, NestedCommonFormatColumnPartSerde.this.bitmapSerdeFactory, buffer, builder);
            ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
            if (supplier.getVariantTypeSetByte() == null) {
                capabilitiesBuilder.setDictionaryEncoded(true);
                capabilitiesBuilder.setDictionaryValuesSorted(true);
                capabilitiesBuilder.setDictionaryValuesUnique(true);
            }
            builder.setType(NestedCommonFormatColumnPartSerde.this.logicalType);
            builder.setHasNulls(NestedCommonFormatColumnPartSerde.this.hasNulls);
            builder.setNestedCommonFormatColumnSupplier(supplier);
            builder.setIndexSupplier(supplier, true, false);
            builder.setColumnFormat(new NestedCommonFormatColumn.Format(NestedCommonFormatColumnPartSerde.this.logicalType, capabilitiesBuilder.hasNulls().isTrue(), NestedCommonFormatColumnPartSerde.this.enforceLogicalType));
        }
    }

    private class DoubleColumnDeserializer
    implements ColumnPartSerde.Deserializer {
        private DoubleColumnDeserializer() {
        }

        @Override
        public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
            ScalarDoubleColumnAndIndexSupplier supplier = ScalarDoubleColumnAndIndexSupplier.read(NestedCommonFormatColumnPartSerde.this.byteOrder, NestedCommonFormatColumnPartSerde.this.bitmapSerdeFactory, buffer, builder, columnConfig);
            ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
            builder.setType(NestedCommonFormatColumnPartSerde.this.logicalType);
            builder.setHasNulls(NestedCommonFormatColumnPartSerde.this.hasNulls);
            builder.setNestedCommonFormatColumnSupplier(supplier);
            builder.setIndexSupplier(supplier, true, false);
            builder.setColumnFormat(new NestedCommonFormatColumn.Format(NestedCommonFormatColumnPartSerde.this.logicalType, capabilitiesBuilder.hasNulls().isTrue(), NestedCommonFormatColumnPartSerde.this.enforceLogicalType));
        }
    }

    private class LongColumnDeserializer
    implements ColumnPartSerde.Deserializer {
        private LongColumnDeserializer() {
        }

        @Override
        public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
            ScalarLongColumnAndIndexSupplier supplier = ScalarLongColumnAndIndexSupplier.read(NestedCommonFormatColumnPartSerde.this.byteOrder, NestedCommonFormatColumnPartSerde.this.bitmapSerdeFactory, buffer, builder, columnConfig);
            ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
            builder.setType(NestedCommonFormatColumnPartSerde.this.logicalType);
            builder.setHasNulls(NestedCommonFormatColumnPartSerde.this.hasNulls);
            builder.setNestedCommonFormatColumnSupplier(supplier);
            builder.setIndexSupplier(supplier, true, false);
            builder.setColumnFormat(new NestedCommonFormatColumn.Format(NestedCommonFormatColumnPartSerde.this.logicalType, capabilitiesBuilder.hasNulls().isTrue(), NestedCommonFormatColumnPartSerde.this.enforceLogicalType));
        }
    }

    private class StringColumnDeserializer
    implements ColumnPartSerde.Deserializer {
        private StringColumnDeserializer() {
        }

        @Override
        public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
            ScalarStringColumnAndIndexSupplier supplier = ScalarStringColumnAndIndexSupplier.read(NestedCommonFormatColumnPartSerde.this.byteOrder, NestedCommonFormatColumnPartSerde.this.bitmapSerdeFactory, buffer, builder);
            ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
            capabilitiesBuilder.setDictionaryEncoded(true);
            capabilitiesBuilder.setDictionaryValuesSorted(true);
            capabilitiesBuilder.setDictionaryValuesUnique(true);
            builder.setType(NestedCommonFormatColumnPartSerde.this.logicalType);
            builder.setHasNulls(NestedCommonFormatColumnPartSerde.this.hasNulls);
            builder.setNestedCommonFormatColumnSupplier(supplier);
            builder.setIndexSupplier(supplier, true, false);
            builder.setColumnFormat(new NestedCommonFormatColumn.Format(NestedCommonFormatColumnPartSerde.this.logicalType, capabilitiesBuilder.hasNulls().isTrue(), NestedCommonFormatColumnPartSerde.this.enforceLogicalType));
        }
    }
}

