/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.base.Supplier;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.StupidPool;
import org.apache.druid.java.util.common.ISE;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StupidPoolTest {
    private Supplier<String> generator;
    private CloseableStupidPool<String> poolOfString;
    private ResourceHolder<String> resourceHolderObj;
    private String defaultString = new String("test");

    @Before
    public void setUp() {
        this.generator = (Supplier)EasyMock.createMock(Supplier.class);
        EasyMock.expect((Object)this.generator.get()).andReturn((Object)this.defaultString).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.generator});
        this.poolOfString = new CloseableStupidPool<String>("poolOfString", this.generator);
        this.resourceHolderObj = this.poolOfString.take();
    }

    @After
    public void tearDown() {
        if (this.resourceHolderObj != null) {
            this.resourceHolderObj.close();
        }
        this.poolOfString.close();
    }

    @Test
    public void testTake() {
        Assert.assertThat(this.resourceHolderObj, (Matcher)new IsInstanceOf(ResourceHolder.class));
        Object expectedObject = this.resourceHolderObj.get();
        Assert.assertEquals((Object)expectedObject, (Object)this.defaultString);
    }

    @Test(expected=ISE.class)
    public void testExceptionInResourceHolderGet() {
        this.resourceHolderObj.close();
        this.resourceHolderObj.get();
    }

    @Test(timeout=60000L)
    public void testResourceHandlerClearedByJVM() {
        StupidPool poolOfString = new StupidPool("poolOfString", () -> "billybob");
        StupidPool.ObjectResourceHolder take = (StupidPool.ObjectResourceHolder)poolOfString.take();
        take.forceClean();
        Assert.assertEquals((String)"Expected there to be one leak", (long)1L, (long)poolOfString.leakedObjectsCount());
        boolean exceptionThrown = false;
        try {
            poolOfString.take();
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expect the pool to throw an exception as it should be poisoned", (boolean)exceptionThrown);
    }
}

