/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial.search;

import java.util.Arrays;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.collections.spatial.search.PolygonBound;
import org.junit.Assert;
import org.junit.Test;

public class PolygonBoundTest {
    @Test
    public void testCacheKey() {
        Assert.assertArrayEquals((byte[])PolygonBound.from((float[])new float[]{1.0f, 2.0f, 3.0f}, (float[])new float[]{0.0f, 2.0f, 0.0f}, (int)1).getCacheKey(), (byte[])PolygonBound.from((float[])new float[]{1.0f, 2.0f, 3.0f}, (float[])new float[]{0.0f, 2.0f, 0.0f}, (int)1).getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(PolygonBound.from((float[])new float[]{1.0f, 2.0f, 3.0f}, (float[])new float[]{0.0f, 2.0f, 0.0f}, (int)1).getCacheKey(), PolygonBound.from((float[])new float[]{1.0f, 2.0f, 3.0f}, (float[])new float[]{0.0f, 2.0f, 1.0f}, (int)1).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(PolygonBound.from((float[])new float[]{1.0f, 2.0f, 3.0f}, (float[])new float[]{0.0f, 2.0f, 0.0f}, (int)1).getCacheKey(), PolygonBound.from((float[])new float[]{1.0f, 2.0f, 2.0f}, (float[])new float[]{0.0f, 2.0f, 0.0f}, (int)1).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(PolygonBound.from((float[])new float[]{1.0f, 2.0f, 3.0f}, (float[])new float[]{0.0f, 2.0f, 0.0f}, (int)1).getCacheKey(), PolygonBound.from((float[])new float[]{1.0f, 2.0f, 3.0f}, (float[])new float[]{0.0f, 2.0f, 0.0f}, (int)2).getCacheKey()));
    }

    @Test
    public void testContains() {
        PolygonBound triangle = PolygonBound.from((float[])new float[]{1.0f, 4.0f, 7.0f}, (float[])new float[]{1.0f, 4.0f, 1.0f});
        float delta = 1.0E-5f;
        Assert.assertTrue((boolean)triangle.contains(new float[]{1.0f, 1.0f}));
        Assert.assertFalse((boolean)triangle.contains(new float[]{1.0f, 0.99999f}));
        Assert.assertFalse((boolean)triangle.contains(new float[]{1.0f, 1.00001f}));
        Assert.assertTrue((boolean)triangle.contains(new float[]{1.00001f, 1.0f}));
        Assert.assertFalse((boolean)triangle.contains(new float[]{0.99999f, 1.0f}));
        Assert.assertTrue((boolean)triangle.contains(new float[]{1.00001f, 1.0f}));
        Assert.assertFalse((boolean)triangle.contains(new float[]{0.99999f, 1.0f}));
        Assert.assertTrue((boolean)triangle.contains(new float[]{5.0f, 1.0f}));
        Assert.assertFalse((boolean)triangle.contains(new float[]{1.0f, 5.0f}));
        Assert.assertTrue((boolean)triangle.contains(new float[]{3.0f, 2.0f}));
        PolygonBound rightTriangle = PolygonBound.from((float[])new float[]{1.0f, 1.0f, 5.0f}, (float[])new float[]{1.0f, 5.0f, 1.0f});
        Assert.assertTrue((boolean)rightTriangle.contains(new float[]{1.0f, 5.0f}));
        Assert.assertTrue((boolean)rightTriangle.contains(new float[]{2.0f, 4.0f}));
        Assert.assertTrue((boolean)rightTriangle.contains(new float[]{1.99999f, 4.0f}));
        Assert.assertFalse((boolean)rightTriangle.contains(new float[]{2.00001f, 4.0f}));
        Assert.assertTrue((boolean)rightTriangle.contains(new float[]{2.0f, 3.99999f}));
        Assert.assertFalse((boolean)rightTriangle.contains(new float[]{2.0f, 4.00001f}));
        Assert.assertTrue((boolean)rightTriangle.contains(new float[]{2.99999f, 3.0f}));
        Assert.assertFalse((boolean)rightTriangle.contains(new float[]{3.00001f, 3.0f}));
        Assert.assertTrue((boolean)rightTriangle.contains(new float[]{3.0f, 2.99999f}));
        Assert.assertFalse((boolean)rightTriangle.contains(new float[]{3.0f, 3.00001f}));
    }

    @Test
    public void testHighPrecisions() {
        PolygonBound triangle = PolygonBound.from((float[])new float[]{37.824604f, 37.793785f, 37.82872f}, (float[])new float[]{-122.508514f, -122.48345f, -122.48597f});
        Assert.assertTrue((boolean)triangle.contains(new float[]{37.826687f, -122.48783f}));
        Assert.assertTrue((boolean)triangle.contains(new float[]{37.813408f, -122.48606f}));
        Assert.assertFalse((boolean)triangle.contains(new float[]{37.808125f, -122.49677f}));
        Assert.assertFalse((boolean)triangle.contains(new float[]{37.81833f, -122.48436f}));
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(PolygonBound.class).usingGetClass().verify();
    }
}

