/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public final class NullHandlingTest
extends InitializedNullHandlingTest {
    @Test
    public void test_defaultValueForClass_float() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Float.valueOf(0.0f) : null), (Object)NullHandling.defaultValueForClass(Float.class));
    }

    @Test
    public void test_defaultValueForClass_double() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null), (Object)NullHandling.defaultValueForClass(Double.class));
    }

    @Test
    public void test_defaultValueForClass_integer() {
        Assert.assertNull((Object)NullHandling.defaultValueForClass(Integer.class));
    }

    @Test
    public void test_defaultValueForClass_long() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Long.valueOf(0L) : null), (Object)NullHandling.defaultValueForClass(Long.class));
    }

    @Test
    public void test_defaultValueForClass_number() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null), (Object)NullHandling.defaultValueForClass(Number.class));
    }

    @Test
    public void test_defaultValueForClass_string() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? "" : null), (Object)NullHandling.defaultValueForClass(String.class));
    }

    @Test
    public void test_defaultValueForClass_object() {
        Assert.assertNull((Object)NullHandling.defaultValueForClass(Object.class));
    }

    @Test
    public void test_defaultValueForType() {
        Assert.assertEquals((Object)NullHandling.defaultValueForClass(Float.class), (Object)NullHandling.defaultValueForType((ValueType)ValueType.FLOAT));
        Assert.assertEquals((Object)NullHandling.defaultValueForClass(Double.class), (Object)NullHandling.defaultValueForType((ValueType)ValueType.DOUBLE));
        Assert.assertEquals((Object)NullHandling.defaultValueForClass(Long.class), (Object)NullHandling.defaultValueForType((ValueType)ValueType.LONG));
        Assert.assertEquals((Object)NullHandling.defaultValueForClass(String.class), (Object)NullHandling.defaultValueForType((ValueType)ValueType.STRING));
        Assert.assertEquals((Object)NullHandling.defaultValueForClass(Object.class), (Object)NullHandling.defaultValueForType((ValueType)ValueType.COMPLEX));
        Assert.assertEquals((Object)NullHandling.defaultValueForClass(Object.class), (Object)NullHandling.defaultValueForType((ValueType)ValueType.ARRAY));
    }

    @Test
    public void test_ignoreNullsStrings() {
        try {
            NullHandling.initializeForTestsWithValues((Boolean)false, (Boolean)true);
            Assert.assertFalse((boolean)NullHandling.ignoreNullsForStringCardinality());
            NullHandling.initializeForTestsWithValues((Boolean)true, (Boolean)false);
            Assert.assertFalse((boolean)NullHandling.ignoreNullsForStringCardinality());
        }
        finally {
            NullHandling.initializeForTests();
        }
    }

    @Test
    public void test_mustCombineNullAndEmptyInDictionary() {
        Assert.assertFalse((boolean)NullHandling.mustCombineNullAndEmptyInDictionary((Indexed)new ListIndexed(Collections.singletonList(null))));
        Assert.assertFalse((boolean)NullHandling.mustCombineNullAndEmptyInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{StringUtils.toUtf8ByteBuffer((String)"foo")})));
        Assert.assertFalse((boolean)NullHandling.mustCombineNullAndEmptyInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{StringUtils.toUtf8ByteBuffer((String)"")})));
        Assert.assertFalse((boolean)NullHandling.mustCombineNullAndEmptyInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{StringUtils.toUtf8ByteBuffer((String)""), StringUtils.toUtf8ByteBuffer((String)"foo")})));
        Assert.assertEquals((Object)NullHandling.replaceWithDefault(), (Object)NullHandling.mustCombineNullAndEmptyInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{null, StringUtils.toUtf8ByteBuffer((String)"")})));
        Assert.assertEquals((Object)NullHandling.replaceWithDefault(), (Object)NullHandling.mustCombineNullAndEmptyInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{null, StringUtils.toUtf8ByteBuffer((String)""), StringUtils.toUtf8ByteBuffer((String)"foo")})));
    }

    @Test
    public void test_mustReplaceFirstValueWithNullInDictionary() {
        Assert.assertFalse((boolean)NullHandling.mustReplaceFirstValueWithNullInDictionary((Indexed)new ListIndexed(Collections.singletonList(null))));
        Assert.assertFalse((boolean)NullHandling.mustReplaceFirstValueWithNullInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{StringUtils.toUtf8ByteBuffer((String)"foo")})));
        Assert.assertEquals((Object)NullHandling.replaceWithDefault(), (Object)NullHandling.mustReplaceFirstValueWithNullInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{StringUtils.toUtf8ByteBuffer((String)"")})));
        Assert.assertEquals((Object)NullHandling.replaceWithDefault(), (Object)NullHandling.mustReplaceFirstValueWithNullInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{StringUtils.toUtf8ByteBuffer((String)""), StringUtils.toUtf8ByteBuffer((String)"foo")})));
        Assert.assertFalse((boolean)NullHandling.mustReplaceFirstValueWithNullInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{null, StringUtils.toUtf8ByteBuffer((String)"")})));
        Assert.assertFalse((boolean)NullHandling.mustReplaceFirstValueWithNullInDictionary((Indexed)new ListIndexed((Object[])new ByteBuffer[]{null, StringUtils.toUtf8ByteBuffer((String)""), StringUtils.toUtf8ByteBuffer((String)"foo")})));
    }
}

