/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CsvReaderTest {
    private static final InputRowSchema INPUT_ROW_SCHEMA = new InputRowSchema(new TimestampSpec("ts", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "name"))), ColumnsFilter.all());

    @BeforeClass
    public static void setup() {
        NullHandling.initializeForTests();
    }

    @Test
    public void testWithoutHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"2019-01-01T00:00:10Z,name_1,5", (Object)"2019-01-01T00:00:20Z,name_2,10", (Object)"2019-01-01T00:00:30Z,name_3,15"));
        CsvInputFormat format = new CsvInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"score"), null, null, Boolean.valueOf(false), 0);
        this.assertResult(source, format);
    }

    @Test
    public void testFindColumn() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts,name,score", (Object)"2019-01-01T00:00:10Z,name_1,5", (Object)"2019-01-01T00:00:20Z,name_2,10", (Object)"2019-01-01T00:00:30Z,name_3,15"));
        CsvInputFormat format = new CsvInputFormat((List)ImmutableList.of(), null, null, Boolean.valueOf(true), 0);
        this.assertResult(source, format);
    }

    @Test
    public void testSkipHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"this,is,a,row,to,skip", (Object)"2019-01-01T00:00:10Z,name_1,5", (Object)"2019-01-01T00:00:20Z,name_2,10", (Object)"2019-01-01T00:00:30Z,name_3,15"));
        CsvInputFormat format = new CsvInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"score"), null, null, Boolean.valueOf(false), 1);
        this.assertResult(source, format);
    }

    @Test
    public void testFindColumnAndSkipHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"this,is,a,row,to,skip", (Object)"ts,name,score", (Object)"2019-01-01T00:00:10Z,name_1,5", (Object)"2019-01-01T00:00:20Z,name_2,10", (Object)"2019-01-01T00:00:30Z,name_3,15"));
        CsvInputFormat format = new CsvInputFormat((List)ImmutableList.of(), null, null, Boolean.valueOf(true), 1);
        this.assertResult(source, format);
    }

    @Test
    public void testMultiValues() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts,name,score", (Object)"2019-01-01T00:00:10Z,name_1,5|1", (Object)"2019-01-01T00:00:20Z,name_2,10|2", (Object)"2019-01-01T00:00:30Z,name_3,15|3"));
        CsvInputFormat format = new CsvInputFormat((List)ImmutableList.of(), "|", null, Boolean.valueOf(true), 0);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)ImmutableList.of((Object)Integer.toString((numResults + 1) * 5), (Object)Integer.toString(numResults + 1)), (Object)row.getDimension("score"));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }

    @Test
    public void testQuotes() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"3,\"Lets do some \"\"normal\"\" quotes\",2018-05-05T10:00:00Z", (Object)"34,\"Lets do some \"\"normal\"\", quotes with comma\",2018-05-06T10:00:00Z", (Object)"343,\"Lets try \\\"\"it\\\"\" with slash quotes\",2018-05-07T10:00:00Z", (Object)"545,\"Lets try \\\"\"it\\\"\", with slash quotes and comma\",2018-05-08T10:00:00Z", (Object)"65,Here I write \\n slash n,2018-05-09T10:00:00Z"));
        RowSignature signature = RowSignature.builder().add("Value", null).add("Comment", null).add("Timestamp", null).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-05T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)"3", (Object)"Lets do some \"normal\" quotes", (Object)"2018-05-05T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-06T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)"34", (Object)"Lets do some \"normal\", quotes with comma", (Object)"2018-05-06T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-07T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)"343", (Object)"Lets try \\\"it\\\" with slash quotes", (Object)"2018-05-07T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-08T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)"545", (Object)"Lets try \\\"it\\\", with slash quotes and comma", (Object)"2018-05-08T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-09T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)"65", (Object)"Here I write \\n slash n", (Object)"2018-05-09T10:00:00Z")));
        CsvInputFormat format = new CsvInputFormat((List)ImmutableList.of((Object)"Value", (Object)"Comment", (Object)"Timestamp"), null, null, Boolean.valueOf(false), 0);
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("Timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"Timestamp"))), ColumnsFilter.all()), (InputEntity)source, null);
        try (CloseableIterator iterator = reader.read();){
            Iterator expectedRowIterator = expectedResults.iterator();
            while (iterator.hasNext()) {
                Assert.assertTrue((boolean)expectedRowIterator.hasNext());
                Assert.assertEquals(expectedRowIterator.next(), (Object)iterator.next());
            }
        }
    }

    @Test
    public void testRussianTextMess() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"2019-01-01T00:00:10Z,name_1,\"\u041a\u0430\u043a \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f: \\\"\"\u0432\u0441\u0451 \u0442\u0435\u0447\u0435\u0442, \u0432\u0441\u0451 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f\\\"\". \u0423\u043a\u0440\u0430\u0438\u043d\u0430 \u043a\u0430\u043a \u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0431\u0432\u0438\u043d\u044f\u0435\u0442 \u0420\u043e\u0441\u0441\u0438\u044e \u0432 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u0445. #\u041f\u0440\u043e\u0432\u043e\u043a\u0430\u0446\u0438\u044f\u041a\u0438\u0435\u0432\u0430\""));
        CsvInputFormat format = new CsvInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"Comment"), null, null, Boolean.valueOf(false), 0);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        try (CloseableIterator iterator = reader.read();){
            Assert.assertTrue((boolean)iterator.hasNext());
            InputRow row = (InputRow)iterator.next();
            Assert.assertEquals((Object)DateTimes.of((String)"2019-01-01T00:00:10Z"), (Object)row.getTimestamp());
            Assert.assertEquals((Object)"name_1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
            Assert.assertEquals((Object)"\u041a\u0430\u043a \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f: \\\"\u0432\u0441\u0451 \u0442\u0435\u0447\u0435\u0442, \u0432\u0441\u0451 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f\\\". \u0423\u043a\u0440\u0430\u0438\u043d\u0430 \u043a\u0430\u043a \u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0431\u0432\u0438\u043d\u044f\u0435\u0442 \u0420\u043e\u0441\u0441\u0438\u044e \u0432 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u0445. #\u041f\u0440\u043e\u0432\u043e\u043a\u0430\u0446\u0438\u044f\u041a\u0438\u0435\u0432\u0430", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("Comment")));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    private ByteEntity writeData(List<String> lines) throws IOException {
        List byteLines = lines.stream().map(line -> StringUtils.toUtf8((String)(line + "\n"))).collect(Collectors.toList());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(byteLines.stream().mapToInt(bytes -> ((byte[])bytes).length).sum());
        for (byte[] bytes2 : byteLines) {
            outputStream.write(bytes2);
        }
        return new ByteEntity(outputStream.toByteArray());
    }

    private void assertResult(ByteEntity source, CsvInputFormat format) throws IOException {
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString((numResults + 1) * 5), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }
}

