/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.impl.HttpEntity;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HttpEntityTest {
    private URI uri;
    private URL url;
    private URLConnection urlConnection;
    private InputStream inputStreamMock;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() throws IOException {
        this.uri = (URI)Mockito.mock(URI.class);
        this.url = (URL)Mockito.mock(URL.class);
        this.urlConnection = (URLConnection)Mockito.mock(URLConnection.class);
        this.inputStreamMock = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.uri.toURL()).thenReturn((Object)this.url);
        Mockito.when((Object)this.url.openConnection()).thenReturn((Object)this.urlConnection);
        Mockito.when((Object)this.urlConnection.getInputStream()).thenReturn((Object)this.inputStreamMock);
        Mockito.when((Object)this.inputStreamMock.skip(ArgumentMatchers.anyLong())).then(AdditionalAnswers.returnsFirstArg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenInputStream() throws IOException, URISyntaxException {
        HttpServer server = null;
        InputStream inputStream = null;
        InputStream inputStreamPartial = null;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
            server.createContext("/test", httpExchange -> {
                String payload = "12345678910";
                byte[] outputBytes = payload.getBytes(StandardCharsets.UTF_8);
                httpExchange.sendResponseHeaders(200, outputBytes.length);
                OutputStream os = httpExchange.getResponseBody();
                httpExchange.getResponseHeaders().set("Content-Type", "application/octet-stream");
                httpExchange.getResponseHeaders().set("Content-Length", String.valueOf(outputBytes.length));
                httpExchange.getResponseHeaders().set("Content-Range", "bytes 0");
                os.write(outputBytes);
                os.close();
            });
            server.start();
            URI url = new URI("http://" + server.getAddress().getHostName() + ":" + server.getAddress().getPort() + "/test");
            inputStream = HttpEntity.openInputStream((URI)url, (String)"", null, (long)0L);
            inputStreamPartial = HttpEntity.openInputStream((URI)url, (String)"", null, (long)5L);
            inputStream.skip(5L);
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)inputStream, (InputStream)inputStreamPartial));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(inputStreamPartial);
            if (server != null) {
                server.stop(0);
            }
            if (serverSocket != null) {
                serverSocket.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)inputStreamPartial);
        if (server != null) {
            server.stop(0);
        }
        if (serverSocket != null) {
            serverSocket.close();
        }
    }

    @Test
    public void testWithServerSupportingRanges() throws IOException {
        long offset = 15L;
        String contentRange = StringUtils.format((String)"bytes %d-%d/%d", (Object[])new Object[]{offset, 1000, 1000});
        Mockito.when((Object)this.urlConnection.getHeaderField("Content-Range")).thenReturn((Object)contentRange);
        HttpEntity.openInputStream((URI)this.uri, (String)"", null, (long)offset);
        ((InputStream)Mockito.verify((Object)this.inputStreamMock, (VerificationMode)Mockito.times((int)0))).skip(offset);
    }

    @Test
    public void testWithServerNotSupportingRanges() throws IOException {
        long offset = 15L;
        Mockito.when((Object)this.urlConnection.getHeaderField("Content-Range")).thenReturn(null);
        HttpEntity.openInputStream((URI)this.uri, (String)"", null, (long)offset);
        ((InputStream)Mockito.verify((Object)this.inputStreamMock, (VerificationMode)Mockito.times((int)1))).skip(offset);
    }

    @Test
    public void testWithServerNotSupportingBytesRanges() throws IOException {
        long offset = 15L;
        Mockito.when((Object)this.urlConnection.getHeaderField("Content-Range")).thenReturn((Object)"token 2-12/12");
        HttpEntity.openInputStream((URI)this.uri, (String)"", null, (long)offset);
        ((InputStream)Mockito.verify((Object)this.inputStreamMock, (VerificationMode)Mockito.times((int)1))).skip(offset);
    }
}

