/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.junit.Assert;
import org.junit.Test;

public class HttpInputSourceConfigTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(HttpInputSourceConfig.class).usingGetClass().verify();
    }

    @Test
    public void testNullAllowedProtocolsUseDefault() {
        HttpInputSourceConfig config = new HttpInputSourceConfig(null);
        Assert.assertEquals((Object)HttpInputSourceConfig.DEFAULT_ALLOWED_PROTOCOLS, (Object)config.getAllowedProtocols());
    }

    @Test
    public void testEmptyAllowedProtocolsUseDefault() {
        HttpInputSourceConfig config = new HttpInputSourceConfig((Set)ImmutableSet.of());
        Assert.assertEquals((Object)HttpInputSourceConfig.DEFAULT_ALLOWED_PROTOCOLS, (Object)config.getAllowedProtocols());
    }

    @Test
    public void testCustomAllowedProtocols() {
        HttpInputSourceConfig config = new HttpInputSourceConfig((Set)ImmutableSet.of((Object)"druid"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"druid"), (Object)config.getAllowedProtocols());
    }
}

