/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FileEntity;
import org.apache.druid.data.input.impl.HttpEntity;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.InputStatsImpl;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.data.input.impl.systemfield.SystemFieldInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class InputEntityIteratingReaderTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void test() throws IOException {
        Throwable throwable;
        int numFiles = 5;
        ArrayList<File> files = new ArrayList<File>();
        long totalFileSize = 0L;
        for (int i = 0; i < 5; ++i) {
            File file2 = this.temporaryFolder.newFile("test_" + i);
            files.add(file2);
            throwable = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file2.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(StringUtils.format((String)"%d,%s,%d\n", (Object[])new Object[]{20190101 + i, "name_" + i, i}));
                writer.write(StringUtils.format((String)"%d,%s,%d", (Object[])new Object[]{20190102 + i, "name_" + (i + 1), i + 1}));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            totalFileSize += file2.length();
        }
        InputEntityIteratingReader reader = new InputEntityIteratingReader(new InputRowSchema(new TimestampSpec("time", "yyyyMMdd", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score"))), ColumnsFilter.all()), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score"), null, null, Boolean.valueOf(false), 0), CloseableIterators.withEmptyBaggage(files.stream().flatMap(file -> ImmutableList.of((Object)new FileEntity(file)).stream()).iterator()), SystemFieldDecoratorFactory.NONE, this.temporaryFolder.newFolder());
        InputStatsImpl inputStats = new InputStatsImpl();
        throwable = null;
        try (CloseableIterator iterator = reader.read((InputStats)inputStats);){
            int i = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-%02d", (Object[])new Object[]{i + 1})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{i}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString(i), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                Assert.assertTrue((boolean)iterator.hasNext());
                row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-%02d", (Object[])new Object[]{i + 2})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{i + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString(i + 1), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                ++i;
            }
            Assert.assertEquals((long)5L, (long)i);
            Assert.assertEquals((long)totalFileSize, (long)inputStats.getProcessedBytes());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testSampleWithSystemFields() throws IOException {
        Throwable throwable;
        int numFiles = 5;
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < 5; ++i) {
            File file2 = this.temporaryFolder.newFile("test_" + i);
            files.add(file2);
            throwable = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file2.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(StringUtils.format((String)"%d,%s,%d\n", (Object[])new Object[]{20190101 + i, "name_" + i, i}));
                writer.write(StringUtils.format((String)"%d,%s,%d", (Object[])new Object[]{20190102 + i, "name_" + (i + 1), i + 1}));
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        LocalInputSource inputSource = new LocalInputSource(this.temporaryFolder.getRoot(), "test_*", null, new SystemFields(EnumSet.of(SystemField.URI, SystemField.PATH)));
        InputEntityIteratingReader reader = new InputEntityIteratingReader(new InputRowSchema(new TimestampSpec("time", "yyyyMMdd", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score", (Object)SystemField.URI.getFieldName(), (Object)SystemField.PATH.getFieldName()))), ColumnsFilter.all()), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score"), null, null, Boolean.valueOf(false), 0), CloseableIterators.withEmptyBaggage(files.stream().flatMap(file -> ImmutableList.of((Object)new FileEntity(file)).stream()).iterator()), SystemFieldDecoratorFactory.fromInputSource((SystemFieldInputSource)inputSource), this.temporaryFolder.newFolder());
        throwable = null;
        try (CloseableIterator iterator = reader.sample();){
            int i = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)((InputRowListPlusRawValues)iterator.next()).getInputRows().get(0);
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-%02d", (Object[])new Object[]{i + 1})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{i}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString(i), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                Assert.assertEquals((Object)((File)files.get(i)).toURI().toString(), row.getDimension(SystemField.URI.getFieldName()).get(0));
                Assert.assertEquals((Object)((File)files.get(i)).getAbsolutePath(), row.getDimension(SystemField.PATH.getFieldName()).get(0));
                Assert.assertTrue((boolean)iterator.hasNext());
                row = (InputRow)((InputRowListPlusRawValues)iterator.next()).getInputRows().get(0);
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-%02d", (Object[])new Object[]{i + 2})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{i + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString(i + 1), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                Assert.assertEquals((Object)((File)files.get(i)).toURI().toString(), row.getDimension(SystemField.URI.getFieldName()).get(0));
                Assert.assertEquals((Object)((File)files.get(i)).getAbsolutePath(), row.getDimension(SystemField.PATH.getFieldName()).get(0));
                ++i;
            }
            Assert.assertEquals((long)5L, (long)i);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testIncorrectURI() throws IOException, URISyntaxException {
        InputEntityIteratingReader inputReader = new InputEntityIteratingReader(new InputRowSchema(new TimestampSpec(null, null, null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score"))), ColumnsFilter.all()), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score"), null, null, Boolean.valueOf(false), 0), CloseableIterators.withEmptyBaggage((Iterator)ImmutableList.of((Object)new HttpEntity(new URI("testscheme://some/path"), null, null){

            protected int getMaxRetries() {
                return 2;
            }
        }).iterator()), SystemFieldDecoratorFactory.NONE, this.temporaryFolder.newFolder());
        try (CloseableIterator readIterator = inputReader.read();){
            String expectedMessage = "Error occurred while trying to read uri: testscheme://some/path";
            Exception exception = (Exception)Assert.assertThrows(RuntimeException.class, () -> readIterator.hasNext());
            Assert.assertTrue((boolean)exception.getMessage().contains(expectedMessage));
        }
    }
}

