/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.druid.data.input.impl.RetryingInputStream;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class RetryingInputStreamTest {
    private static final int MAX_RETRY = 5;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File testFile;
    private int readBytesBeforeExceptions = 0;
    private int throwCustomExceptions = 0;
    private int throwIOExceptions = 0;
    private final ObjectOpenFunction<File> objectOpenFunction = (ObjectOpenFunction)Mockito.spy((Object)new ObjectOpenFunction<File>(){

        public InputStream open(File object) throws IOException {
            return new TestInputStream(new FileInputStream(object));
        }

        public InputStream open(File object, long start) throws IOException {
            FileInputStream fis = new FileInputStream(object);
            Preconditions.checkState((fis.skip(start) == start ? 1 : 0) != 0);
            return new TestInputStream(fis);
        }
    });

    @Before
    public void setup() throws IOException {
        this.testFile = this.temporaryFolder.newFile();
        try (FileOutputStream fis = new FileOutputStream(this.testFile);
             GZIPOutputStream gis = new GZIPOutputStream(fis);
             DataOutputStream dis = new DataOutputStream(gis);){
            for (int i = 0; i < 10000; ++i) {
                dis.writeInt(i);
            }
        }
        this.readBytesBeforeExceptions = 0;
        this.throwCustomExceptions = 0;
        this.throwIOExceptions = 0;
    }

    @After
    public void teardown() throws IOException {
        FileUtils.forceDelete((File)this.testFile);
    }

    @Test
    public void testThrowsOnIOException() throws IOException {
        this.throwIOExceptions = 1;
        RetryingInputStream retryingInputStream = new RetryingInputStream((Object)this.testFile, this.objectOpenFunction, t -> false, Integer.valueOf(5), false);
        Assert.assertThrows(IOException.class, () -> this.retryHelper((RetryingInputStream<File>)retryingInputStream));
        Assert.assertEquals((long)0L, (long)this.throwIOExceptions);
    }

    @Test
    public void testRetryOnCustomException() throws IOException {
        this.throwCustomExceptions = 1;
        RetryingInputStream retryingInputStream = new RetryingInputStream((Object)this.testFile, this.objectOpenFunction, t -> t instanceof CustomException, Integer.valueOf(5), false);
        this.retryHelper((RetryingInputStream<File>)retryingInputStream);
        Assert.assertEquals((long)0L, (long)this.throwCustomExceptions);
    }

    @Test
    public void testThrowsOnCustomException() throws IOException {
        this.throwCustomExceptions = 1;
        RetryingInputStream retryingInputStream = new RetryingInputStream((Object)this.testFile, this.objectOpenFunction, t -> false, Integer.valueOf(5), false);
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.retryHelper((RetryingInputStream<File>)retryingInputStream));
        Assert.assertEquals((long)0L, (long)this.throwCustomExceptions);
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CustomException.class));
    }

    @Test
    public void testResumeAfterExceptions() throws IOException {
        this.readBytesBeforeExceptions = 1000;
        this.throwCustomExceptions = 100;
        RetryingInputStream retryingInputStream = new RetryingInputStream((Object)this.testFile, this.objectOpenFunction, t -> true, Integer.valueOf(5), false);
        this.retryHelper((RetryingInputStream<File>)retryingInputStream);
        Assert.assertEquals((long)81L, (long)this.throwCustomExceptions);
    }

    @Test
    public void testTooManyExceptions() throws IOException {
        this.throwIOExceptions = 11;
        RetryingInputStream retryingInputStream = new RetryingInputStream((Object)this.testFile, this.objectOpenFunction, t -> t instanceof IOException, Integer.valueOf(5), false);
        Assert.assertThrows(IOException.class, () -> this.retryHelper((RetryingInputStream<File>)retryingInputStream));
        Assert.assertEquals((long)6L, (long)this.throwIOExceptions);
    }

    @Test
    public void testIOExceptionNotRetriableRead() throws IOException {
        this.throwCustomExceptions = 1;
        this.throwIOExceptions = 1;
        RetryingInputStream retryingInputStream = new RetryingInputStream((Object)this.testFile, this.objectOpenFunction, t -> t instanceof IOException || t instanceof CustomException, Integer.valueOf(5), false);
        this.retryHelper((RetryingInputStream<File>)retryingInputStream);
        Assert.assertEquals((long)0L, (long)this.throwCustomExceptions);
        Assert.assertEquals((long)0L, (long)this.throwIOExceptions);
    }

    @Test
    public void testRetryOnExceptionWhenOpeningStream() throws Exception {
        this.throwCustomExceptions = 2;
        ((ObjectOpenFunction)Mockito.doAnswer((Answer)new Answer<InputStream>(){
            int retryCount = 0;

            public InputStream answer(InvocationOnMock invocation) throws Throwable {
                if (this.retryCount < 2) {
                    ++this.retryCount;
                    RetryingInputStreamTest.this.throwCustomExceptions = RetryingInputStreamTest.this.throwCustomExceptions - 1;
                    throw new CustomException("I am a custom retryable exception", new RuntimeException());
                }
                return (InputStream)invocation.callRealMethod();
            }
        }).when(this.objectOpenFunction)).open(ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        new RetryingInputStream((Object)this.testFile, this.objectOpenFunction, t -> t instanceof CustomException, Integer.valueOf(5), false);
        ((ObjectOpenFunction)Mockito.verify(this.objectOpenFunction, (VerificationMode)Mockito.times((int)3))).open(ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        Assert.assertEquals((long)0L, (long)this.throwCustomExceptions);
    }

    private void retryHelper(RetryingInputStream<File> retryingInputStream) throws IOException {
        try (DataInputStream inputStream = new DataInputStream(new GZIPInputStream((InputStream)retryingInputStream));){
            for (int i = 0; i < 10000; ++i) {
                Assert.assertEquals((long)i, (long)inputStream.readInt());
            }
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
    }

    private static class CustomException
    extends RuntimeException {
        public CustomException(String err, Throwable t) {
            super(err, t);
        }
    }

    private class TestInputStream
    extends FilterInputStream {
        private long bytesRead;

        TestInputStream(InputStream delegate) {
            super(delegate);
            this.bytesRead = 0L;
        }

        @Override
        public int read() throws IOException {
            this.possiblyThrowException();
            int r = super.read();
            ++this.bytesRead;
            return r;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            this.possiblyThrowException();
            int lenToUse = RetryingInputStreamTest.this.throwIOExceptions > 0 || RetryingInputStreamTest.this.throwCustomExceptions > 0 ? Ints.checkedCast((long)Math.min((long)len, (long)RetryingInputStreamTest.this.readBytesBeforeExceptions - this.bytesRead)) : len;
            int r = super.read(b, off, lenToUse);
            this.bytesRead += (long)r;
            return r;
        }

        private void possiblyThrowException() throws IOException {
            if (this.bytesRead >= (long)RetryingInputStreamTest.this.readBytesBeforeExceptions) {
                if (RetryingInputStreamTest.this.throwIOExceptions > 0) {
                    RetryingInputStreamTest.this.throwIOExceptions--;
                    throw new IOException("test retry");
                }
                if (RetryingInputStreamTest.this.throwCustomExceptions > 0) {
                    RetryingInputStreamTest.this.throwCustomExceptions--;
                    RuntimeException e = new RuntimeException();
                    throw new CustomException("I am a custom retryable exception", e);
                }
            }
        }
    }
}

