/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class RowsTest
extends InitializedNullHandlingTest {
    private static final String FIELD_NAME = "foo";
    private final Map<Object, Number> validCases = new LinkedHashMap<Object, Number>();
    private final List<Object> invalidCases = new ArrayList<Object>();

    @Before
    public void setUp() {
        this.validCases.put(null, NullHandling.sqlCompatible() ? null : Long.valueOf(0L));
        if (NullHandling.sqlCompatible()) {
            this.invalidCases.add("");
        } else {
            this.validCases.put("", 0L);
        }
        this.validCases.put("0", 0L);
        this.validCases.put("+0", 0L);
        this.validCases.put("1", 1L);
        this.validCases.put("1,234", 1234L);
        this.validCases.put("-1,234", -1234L);
        this.validCases.put("+1", 1L);
        this.validCases.put("-1", -1L);
        this.validCases.put(String.valueOf(Long.MAX_VALUE), Long.MAX_VALUE);
        this.validCases.put(String.valueOf(Long.MIN_VALUE), Long.MIN_VALUE);
        this.validCases.put("0.0", 0.0);
        this.validCases.put("-0.0", -0.0);
        this.validCases.put("+0.0", 0.0);
        this.validCases.put("1e1", 10.0);
        this.validCases.put("-1e1", -10.0);
        this.validCases.put("1.0", 1.0);
        this.validCases.put("2.1", 2.1);
        this.validCases.put(String.valueOf(Double.MAX_VALUE), Double.MAX_VALUE);
        this.validCases.put(String.valueOf(Double.MIN_VALUE), Double.MIN_VALUE);
        this.validCases.put(String.valueOf(Double.POSITIVE_INFINITY), Double.POSITIVE_INFINITY);
        this.validCases.put(String.valueOf(Double.NEGATIVE_INFINITY), Double.NEGATIVE_INFINITY);
        this.validCases.put(String.valueOf(Double.NaN), Double.NaN);
        this.validCases.put(0, 0);
        this.validCases.put(0L, 0L);
        this.validCases.put(0.0, 0.0);
        this.validCases.put(Float.valueOf(0.0f), Float.valueOf(0.0f));
        this.validCases.put(-1L, -1L);
        this.validCases.put(1.1, 1.1);
        this.invalidCases.add("notanumber");
        this.invalidCases.add(ImmutableList.of((Object)1L));
        this.invalidCases.add(ImmutableList.of((Object)"1"));
    }

    @Test
    public void test_objectToNumber_typeUnknown_noThrow() {
        for (Map.Entry<Object, Number> entry : this.validCases.entrySet()) {
            Assert.assertEquals((String)StringUtils.format((String)"%s (%s)", (Object[])new Object[]{entry.getKey(), entry.getKey() == null ? null : entry.getKey().getClass().getSimpleName()}), (Object)entry.getValue(), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)entry.getKey(), null, (boolean)false));
        }
        for (Object o : this.invalidCases) {
            Assert.assertEquals((String)(o + " (nothrow)"), (Object)NullHandling.defaultLongValue(), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)o, null, (boolean)false));
            ParseException e = (ParseException)Assert.assertThrows((String)(o + " (throw)"), ParseException.class, () -> Rows.objectToNumber((String)FIELD_NAME, (Object)o, null, (boolean)true));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"for field[foo]")));
        }
    }

    @Test
    public void test_objectToNumber_typeLong_noThrow() {
        for (Map.Entry<Object, Number> entry : this.validCases.entrySet()) {
            Assert.assertEquals((String)StringUtils.format((String)"%s (%s)", (Object[])new Object[]{entry.getKey(), entry.getKey() == null ? null : entry.getKey().getClass().getSimpleName()}), (Object)(entry.getValue() != null ? Long.valueOf(entry.getValue().longValue()) : null), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)entry.getKey(), (ValueType)ValueType.LONG, (boolean)false));
        }
        for (Object o : this.invalidCases) {
            Assert.assertEquals((String)(o + " (nothrow)"), (Object)NullHandling.defaultLongValue(), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)o, (ValueType)ValueType.LONG, (boolean)false));
            ParseException e = (ParseException)Assert.assertThrows((String)(o + " (throw)"), ParseException.class, () -> Rows.objectToNumber((String)FIELD_NAME, (Object)o, (ValueType)ValueType.LONG, (boolean)true));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"for field[foo]")));
        }
    }

    @Test
    public void test_objectToNumber_typeFloat_noThrow() {
        for (Map.Entry<Object, Number> entry : this.validCases.entrySet()) {
            Assert.assertEquals((String)StringUtils.format((String)"%s (%s)", (Object[])new Object[]{entry.getKey(), entry.getKey() == null ? null : entry.getKey().getClass().getSimpleName()}), (Object)(entry.getValue() != null ? Float.valueOf(entry.getValue().floatValue()) : null), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)entry.getKey(), (ValueType)ValueType.FLOAT, (boolean)false));
        }
        for (Object o : this.invalidCases) {
            Assert.assertEquals((String)(o + " (nothrow)"), (Object)NullHandling.defaultFloatValue(), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)o, (ValueType)ValueType.FLOAT, (boolean)false));
            ParseException e = (ParseException)Assert.assertThrows((String)(o + " (throw)"), ParseException.class, () -> Rows.objectToNumber((String)FIELD_NAME, (Object)o, (ValueType)ValueType.FLOAT, (boolean)true));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"for field[foo]")));
        }
    }

    @Test
    public void test_objectToNumber_typeDouble_noThrow() {
        for (Map.Entry<Object, Number> entry : this.validCases.entrySet()) {
            Assert.assertEquals((String)StringUtils.format((String)"%s (%s)", (Object[])new Object[]{entry.getKey(), entry.getKey() == null ? null : entry.getKey().getClass().getSimpleName()}), (Object)(entry.getValue() != null ? Double.valueOf(entry.getValue().doubleValue()) : null), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)entry.getKey(), (ValueType)ValueType.DOUBLE, (boolean)false));
        }
        for (Object o : this.invalidCases) {
            Assert.assertEquals((String)(o + " (nothrow)"), (Object)NullHandling.defaultDoubleValue(), (Object)Rows.objectToNumber((String)FIELD_NAME, (Object)o, (ValueType)ValueType.DOUBLE, (boolean)false));
            ParseException e = (ParseException)Assert.assertThrows((String)(o + " (throw)"), ParseException.class, () -> Rows.objectToNumber((String)FIELD_NAME, (Object)o, (ValueType)ValueType.DOUBLE, (boolean)true));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"for field[foo]")));
        }
    }
}

