/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.prefetch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.junit.Assert;
import org.junit.Test;

public class JsonIteratorTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());
        ImmutableList expectedList = ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)2));
        File testFile = File.createTempFile("testfile", "");
        TypeReference<Map<String, Object>> type = new TypeReference<Map<String, Object>>(){};
        try (FileOutputStream fos = new FileOutputStream(testFile);){
            JsonGenerator jg = mapper.getFactory().createGenerator((OutputStream)fos);
            SerializerProvider serializers = mapper.getSerializerProviderInstance();
            jg.writeStartArray();
            for (Map mapFromList : expectedList) {
                JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)mapFromList);
            }
            jg.writeEndArray();
            jg.close();
        }
        JsonIterator testJsonIterator = new JsonIterator((TypeReference)type, (InputStream)new FileInputStream(testFile), () -> {}, mapper);
        ArrayList<Object> actualList = new ArrayList<Object>();
        while (testJsonIterator.hasNext()) {
            actualList.add(testJsonIterator.next());
        }
        testJsonIterator.close();
        Assert.assertEquals((Object)expectedList, actualList);
    }
}

