/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.io.IOException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.concrete.RowBasedFrameRowsAndColumns;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class FieldReaderRACTest
extends InitializedNullHandlingTest {
    final DruidExceptionMatcher noArraysMatcher = DruidExceptionMatcher.defensive().expectMessageIs("Can only work with single-valued strings, should use a COMPLEX or ARRAY typed Column instead");

    @Test
    public void testDataSet() throws IOException {
        QueryableIndex index = TestIndex.getMMappedTestIndex();
        QueryableIndexCursorFactory cursorFactory = new QueryableIndexCursorFactory(index);
        Frame frame = FrameTestUtil.cursorFactoryToFrame((CursorFactory)cursorFactory, FrameType.ROW_BASED);
        RowSignature siggy = cursorFactory.getRowSignature();
        RowBasedFrameRowsAndColumns rowBasedRAC = new RowBasedFrameRowsAndColumns(frame, siggy);
        for (String columnName : siggy.getColumnNames()) {
            ColumnHolder colHolder = index.getColumnHolder(columnName);
            boolean multiValue = colHolder.getCapabilities().hasMultipleValues().isTrue();
            BaseColumn col = colHolder.getColumn();
            Throwable throwable = null;
            try {
                ColumnAccessor racCol = rowBasedRAC.findColumn(columnName).toAccessor();
                SimpleAscendingOffset offset = new SimpleAscendingOffset(racCol.numRows());
                ColumnValueSelector selector = col.makeColumnValueSelector((ReadableOffset)offset);
                while (offset.withinBounds()) {
                    if (multiValue) {
                        this.noArraysMatcher.assertThrowsAndMatches(() -> racCol.getObject(offset.getOffset()));
                    } else {
                        Object racObj = racCol.getObject(offset.getOffset());
                        Assert.assertEquals((Object)racCol.isNull(offset.getOffset()), (Object)(racCol.getObject(offset.getOffset()) == null ? 1 : 0));
                        Assert.assertEquals((Object)selector.getObject(), (Object)racObj);
                    }
                    offset.increment();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (col == null) continue;
                if (throwable != null) {
                    try {
                        col.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                col.close();
            }
        }
    }
}

