/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.frame.util.DurableStorageUtils;
import org.junit.Assert;
import org.junit.Test;

public class DurableStorageUtilsTest {
    private static final String CONTROLLER_ID = "controller_id_1";
    private static final String TASK_ID = "task_id_1";
    private static final int WORKER_NUMBER = 2;
    private static final int STAGE_NUMBER = 1;
    private static final int PARTITION_NUMBER = 3;

    @Test
    public void getNextDirNameWithPrefixFromPath() {
        Assert.assertEquals((Object)"", (Object)DurableStorageUtils.getNextDirNameWithPrefixFromPath((String)"/123/123"));
        Assert.assertEquals((Object)"123", (Object)DurableStorageUtils.getNextDirNameWithPrefixFromPath((String)"123"));
        Assert.assertEquals((Object)"controller_query_123", (Object)DurableStorageUtils.getNextDirNameWithPrefixFromPath((String)"controller_query_123/123"));
        Assert.assertEquals((Object)"", (Object)DurableStorageUtils.getNextDirNameWithPrefixFromPath((String)""));
        Assert.assertNull((Object)DurableStorageUtils.getNextDirNameWithPrefixFromPath(null));
    }

    @Test
    public void isQueryResultFileActive() {
        Assert.assertTrue((boolean)DurableStorageUtils.isQueryResultFileActive((String)"query-results/123/result", (Set)ImmutableSet.of((Object)"123")));
        Assert.assertFalse((boolean)DurableStorageUtils.isQueryResultFileActive((String)"query-results/123/result", (Set)ImmutableSet.of((Object)"")));
        Assert.assertFalse((boolean)DurableStorageUtils.isQueryResultFileActive((String)"query-results/", (Set)ImmutableSet.of((Object)"123")));
        Assert.assertFalse((boolean)DurableStorageUtils.isQueryResultFileActive(null, (Set)ImmutableSet.of((Object)"123")));
        Assert.assertFalse((boolean)DurableStorageUtils.isQueryResultFileActive((String)"query-results", (Set)ImmutableSet.of((Object)"123")));
    }

    @Test
    public void sanityTest() {
        String baseString = "controller_controller_id_1/stage_1/worker_2/";
        Assert.assertEquals((Object)(baseString + "__success"), (Object)DurableStorageUtils.getWorkerOutputSuccessFilePath((String)CONTROLLER_ID, (int)1, (int)2));
        Assert.assertEquals((Object)("query-results/" + baseString + "__success"), (Object)DurableStorageUtils.getQueryResultsSuccessFilePath((String)CONTROLLER_ID, (int)1, (int)2));
        Assert.assertEquals((Object)(baseString + "taskId_" + TASK_ID), (Object)DurableStorageUtils.getTaskIdOutputsFolderName((String)CONTROLLER_ID, (int)1, (int)2, (String)TASK_ID));
        Assert.assertEquals((Object)("query-results/" + baseString + "taskId_" + TASK_ID), (Object)DurableStorageUtils.getQueryResultsForTaskIdFolderName((String)CONTROLLER_ID, (int)1, (int)2, (String)TASK_ID));
        Assert.assertEquals((Object)(baseString + "taskId_" + TASK_ID + "/part_3"), (Object)DurableStorageUtils.getPartitionOutputsFileNameWithPathForPartition((String)CONTROLLER_ID, (int)1, (int)2, (String)TASK_ID, (int)3));
        Assert.assertEquals((Object)("query-results/" + baseString + "taskId_" + TASK_ID + "/part_3"), (Object)DurableStorageUtils.getQueryResultsFileNameWithPathForPartition((String)CONTROLLER_ID, (int)1, (int)2, (String)TASK_ID, (int)3));
    }
}

