/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKeyComparator;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.frame.write.FrameWriterTestData;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FrameWriterTest
extends InitializedNullHandlingTest {
    private static final int DEFAULT_ALLOCATOR_CAPACITY = 1000000;
    @Nullable
    private final FrameType inputFrameType;
    private final FrameType outputFrameType;
    private final KeyOrder sortedness;
    private MemoryAllocator allocator;
    @Nullable
    private Consumer<ColumnCapabilitiesImpl> capabilitiesAdjustFn;

    public FrameWriterTest(@Nullable FrameType inputFrameType, FrameType outputFrameType, KeyOrder sortedness) {
        this.inputFrameType = inputFrameType;
        this.outputFrameType = outputFrameType;
        this.sortedness = sortedness;
        this.allocator = ArenaMemoryAllocator.createOnHeap((int)1000000);
    }

    @Parameterized.Parameters(name="inputFrameType = {0}, outputFrameType = {1}, sorted = {2}")
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        Iterable inputFrameTypes = Iterables.concat(Collections.singletonList(null), Arrays.asList(FrameType.values()));
        for (FrameType inputFrameType : inputFrameTypes) {
            for (FrameType outputFrameType : FrameType.values()) {
                for (KeyOrder sortedness : KeyOrder.values()) {
                    if (sortedness != KeyOrder.NONE && outputFrameType != FrameType.ROW_BASED) continue;
                    constructors.add(new Object[]{inputFrameType, outputFrameType, sortedness});
                }
            }
        }
        return constructors;
    }

    @BeforeClass
    public static void setUpClass() {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
    }

    @Test
    public void test_string_multiValueTrue() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.TRUE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE);
    }

    @Test
    public void test_string_multiValueFalse() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.FALSE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE);
    }

    @Test
    public void test_string_multiValueUnknown() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.UNKNOWN);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE);
    }

    @Test
    public void test_singleValueWithEmpty_multiValueTrue() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.TRUE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
    }

    @Test
    public void test_singleValueWithEmpty_multiValueFalse() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.FALSE);
        FrameWriterTestData.Dataset<Object> expectedReadDataset = this.outputFrameType == FrameType.COLUMNAR ? FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE : FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE_WITH_EMPTY;
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE_WITH_EMPTY, expectedReadDataset);
    }

    @Test
    public void test_singleValueWithEmpty_multiValueUnknown() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.UNKNOWN);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE_WITH_EMPTY);
    }

    @Test
    public void test_multiValueString_multiValueTrue() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.TRUE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
    }

    @Test
    public void test_multiValueString_multiValueFalse() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.FALSE);
        if (this.outputFrameType == FrameType.COLUMNAR) {
            IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Encountered unexpected multi-value row")));
        } else {
            this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
        }
    }

    @Test
    public void test_multiValueString_multiValueUnknown() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.UNKNOWN);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
    }

    @Test
    public void test_arrayString() {
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_STRING);
    }

    @Test
    public void test_long() {
        this.testWithDataset(FrameWriterTestData.TEST_LONGS);
    }

    @Test
    public void test_arrayLong() {
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_LONG);
    }

    @Test
    public void test_arrayFloat() {
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_FLOAT);
    }

    @Test
    public void test_arrayDouble() {
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_DOUBLE);
    }

    @Test
    public void test_float() {
        this.testWithDataset(FrameWriterTestData.TEST_FLOATS);
    }

    @Test
    public void test_double() {
        this.testWithDataset(FrameWriterTestData.TEST_DOUBLES);
    }

    @Test
    public void test_complex_hll() {
        this.testWithDataset(FrameWriterTestData.TEST_COMPLEX_HLL);
    }

    @Test
    public void test_complex_nested() {
        this.testWithDataset(FrameWriterTestData.TEST_COMPLEX_NESTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_readNullsInDefaultValueMode() {
        Pair<Frame, Integer> writeResult;
        RowSignature signature = RowSignature.builder().add("l1", ColumnType.LONG).add("f1", ColumnType.FLOAT).add("d1", ColumnType.DOUBLE).add("s1", ColumnType.STRING).add("l2", ColumnType.LONG).add("f2", ColumnType.FLOAT).add("d2", ColumnType.DOUBLE).add("s2", ColumnType.STRING).build();
        try {
            NullHandling.initializeForTestsWithValues((Boolean)false, null);
            Sequence rowSequence = Sequences.simple((Iterable)ImmutableList.of(Arrays.asList(null, null, null, null, 0L, Float.valueOf(0.0f), 0.0, "")));
            writeResult = this.writeFrame((Sequence<List<Object>>)rowSequence, signature, signature.getColumnNames());
        }
        finally {
            NullHandling.initializeForTests();
        }
        Assert.assertEquals((long)1L, (long)((Integer)writeResult.rhs).intValue());
        try {
            NullHandling.initializeForTestsWithValues((Boolean)true, null);
            this.verifyFrame((Sequence<List<Object>>)Sequences.simple((Iterable)ImmutableList.of(Arrays.asList(null, null, null, null, 0L, Float.valueOf(0.0f), 0.0, null))), (Frame)writeResult.lhs, signature);
        }
        finally {
            NullHandling.initializeForTests();
        }
    }

    @Test
    public void test_typePairs() {
        for (FrameWriterTestData.Dataset<?> dataset1 : FrameWriterTestData.DATASETS) {
            for (FrameWriterTestData.Dataset<?> dataset2 : FrameWriterTestData.DATASETS) {
                RowSignature signature = FrameWriterTest.makeSignature(Arrays.asList(dataset1, dataset2));
                Sequence<List<Object>> rowSequence = FrameWriterTest.unsortAndMakeRows(Arrays.asList(dataset1, dataset2), 1);
                ArrayList<String> sortColumns = new ArrayList<String>();
                sortColumns.add(signature.getColumnName(0));
                sortColumns.add(signature.getColumnName(1));
                try {
                    Pair<Frame, Integer> writeResult = this.writeFrame(rowSequence, signature, sortColumns);
                    Assert.assertEquals((long)rowSequence.toList().size(), (long)((Integer)writeResult.rhs).intValue());
                    this.verifyFrame(this.sortIfNeeded(rowSequence, signature, sortColumns), (Frame)writeResult.lhs, signature);
                }
                catch (AssertionError e) {
                    throw new AssertionError(StringUtils.format((String)"Assert failed in test (%s, %s)", (Object[])new Object[]{dataset1.getType(), dataset2.getType()}), (Throwable)((Object)e));
                }
                catch (Throwable e) {
                    throw new RE(e, "Exception in test (%s, %s)", new Object[]{dataset1.getType(), dataset2.getType()});
                }
            }
        }
    }

    @Test
    public void test_insufficientWriteCapacity() {
        Pair<Frame, Integer> writeResult;
        Assume.assumeFalse((this.inputFrameType == FrameType.COLUMNAR || this.outputFrameType == FrameType.COLUMNAR ? 1 : 0) != 0);
        RowSignature signature = FrameWriterTest.makeSignature(FrameWriterTestData.DATASETS);
        Sequence<List<Object>> rowSequence = FrameWriterTest.unsortAndMakeRows(FrameWriterTestData.DATASETS, 3);
        int totalRows = rowSequence.toList().size();
        ArrayList<String> sortColumns = new ArrayList<String>();
        for (int i = 0; i < signature.size(); ++i) {
            sortColumns.add(signature.getColumnName(i));
        }
        ByteBuffer allocatorMemory = ByteBuffer.wrap(new byte[1000000]);
        boolean didWritePartial = false;
        int allocatorSize = 0;
        do {
            allocatorMemory.limit(allocatorSize);
            allocatorMemory.position(0);
            this.allocator = ArenaMemoryAllocator.create((ByteBuffer)allocatorMemory);
            try {
                writeResult = this.writeFrame(rowSequence, signature, sortColumns);
                int rowsWritten = (Integer)writeResult.rhs;
                if ((Integer)writeResult.rhs > 0 && (Integer)writeResult.rhs < totalRows) {
                    didWritePartial = true;
                    this.verifyFrame(this.sortIfNeeded((Sequence<List<Object>>)rowSequence.limit((long)rowsWritten), signature, sortColumns), (Frame)writeResult.lhs, signature);
                }
            }
            catch (Throwable e) {
                throw new RE(e, "Exception while writing with allocatorSize = %s", new Object[]{allocatorSize});
            }
            ++allocatorSize;
        } while ((Integer)writeResult.rhs != totalRows);
        this.verifyFrame(this.sortIfNeeded(rowSequence, signature, sortColumns), (Frame)writeResult.lhs, signature);
        Assert.assertTrue((String)"did write a partial frame", (boolean)didWritePartial);
    }

    private void verifyFrame(Sequence<List<Object>> expectedRows, Frame frame, RowSignature signature) {
        CursorFactory cursorFactory = FrameReader.create((RowSignature)signature).makeCursorFactory(frame);
        FrameTestUtil.assertRowsEqual(expectedRows, FrameTestUtil.readRowsFromCursorFactory(cursorFactory, signature, false));
    }

    private Sequence<List<Object>> sortIfNeeded(Sequence<List<Object>> rows, RowSignature signature, List<String> sortColumnNames) {
        List<KeyColumn> keyColumns = this.computeSortColumns(sortColumnNames);
        if (keyColumns.isEmpty()) {
            return rows;
        }
        RowSignature keySignature = KeyTestUtils.createKeySignature(keyColumns, (ColumnInspector)signature);
        RowKeyComparator keyComparator = RowKeyComparator.create(keyColumns, (RowSignature)signature);
        return Sequences.sort(rows, Comparator.comparing(row -> KeyTestUtils.createKey(keySignature, row.toArray()), keyComparator));
    }

    private Pair<Frame, Integer> writeFrame(Sequence<List<Object>> rows, RowSignature signature, List<String> sortColumns) {
        return FrameWriterTest.writeFrame(this.inputFrameType, this.outputFrameType, this.allocator, this.capabilitiesAdjustFn, rows, signature, this.computeSortColumns(sortColumns));
    }

    private List<KeyColumn> computeSortColumns(List<String> sortColumnNames) {
        if (this.sortedness == KeyOrder.NONE) {
            return Collections.emptyList();
        }
        return sortColumnNames.stream().map(columnName -> new KeyColumn(columnName, this.sortedness)).collect(Collectors.toList());
    }

    private <T> void testWithDataset(FrameWriterTestData.Dataset<T> dataset) {
        List<T> data = dataset.getData(KeyOrder.NONE);
        RowSignature signature = RowSignature.builder().add("x", dataset.getType()).build();
        Sequence<List<Object>> rowSequence = FrameWriterTest.rows(data);
        Pair<Frame, Integer> writeResult = this.writeFrame(rowSequence, signature, signature.getColumnNames());
        Assert.assertEquals((long)data.size(), (long)((Integer)writeResult.rhs).intValue());
        this.verifyFrame(FrameWriterTest.rows(dataset.getData(this.sortedness)), (Frame)writeResult.lhs, signature);
    }

    private <T1, T2> void testWithDataset(FrameWriterTestData.Dataset<T1> writeDataset, FrameWriterTestData.Dataset<T2> readDataset) {
        List<T1> data = writeDataset.getData(KeyOrder.NONE);
        RowSignature signature = RowSignature.builder().add("x", writeDataset.getType()).build();
        Sequence<List<Object>> rowSequence = FrameWriterTest.rows(data);
        Pair<Frame, Integer> writeResult = this.writeFrame(rowSequence, signature, signature.getColumnNames());
        Assert.assertEquals((long)data.size(), (long)((Integer)writeResult.rhs).intValue());
        this.verifyFrame(FrameWriterTest.rows(readDataset.getData(this.sortedness)), (Frame)writeResult.lhs, signature);
    }

    /*
     * Exception decompiling
     */
    private static Pair<Frame, Integer> writeFrame(@Nullable FrameType inputFrameType, FrameType outputFrameType, MemoryAllocator allocator, @Nullable Consumer<ColumnCapabilitiesImpl> capabilitiesAdjustFn, Sequence<List<Object>> rows, RowSignature signature, List<KeyColumn> keyColumns) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static Object fillerValueForType(ValueType type) {
        switch (type) {
            case LONG: {
                return NullHandling.defaultLongValue();
            }
            case FLOAT: {
                return NullHandling.defaultFloatValue();
            }
            case DOUBLE: {
                return NullHandling.defaultDoubleValue();
            }
        }
        return null;
    }

    private static RowSignature makeSignature(List<FrameWriterTestData.Dataset<?>> datasets) {
        RowSignature.Builder signatureBuilder = RowSignature.builder();
        for (int i = 0; i < datasets.size(); ++i) {
            FrameWriterTestData.Dataset<?> dataset = datasets.get(i);
            signatureBuilder.add(StringUtils.format((String)"col%03d", (Object[])new Object[]{i}), dataset.getType());
        }
        return signatureBuilder.build();
    }

    private static Sequence<List<Object>> unsortAndMakeRows(List<FrameWriterTestData.Dataset<?>> datasets, int multiplicationFactor) {
        int i;
        ArrayList retVal = new ArrayList();
        int rowSize = datasets.size();
        List iterators = datasets.stream().map(dataset -> dataset.getData(KeyOrder.NONE).iterator()).collect(Collectors.toList());
        while (iterators.stream().anyMatch(Iterator::hasNext)) {
            ArrayList<Object> row = new ArrayList<Object>(rowSize);
            for (i = 0; i < rowSize; ++i) {
                if (((Iterator)iterators.get(i)).hasNext()) {
                    row.add(((Iterator)iterators.get(i)).next());
                    continue;
                }
                row.add(FrameWriterTest.fillerValueForType((ValueType)datasets.get(i).getType().getType()));
            }
            retVal.add(row);
        }
        ArrayList multipliedRetVal = new ArrayList();
        for (i = 0; i < multiplicationFactor; ++i) {
            multipliedRetVal.addAll(retVal);
        }
        return Sequences.simple(multipliedRetVal);
    }

    private static Sequence<List<Object>> rows(List<?> vals) {
        ArrayList retVal = new ArrayList();
        for (Object val : vals) {
            retVal.add(Collections.singletonList(val));
        }
        return Sequences.simple(retVal);
    }

    private static /* synthetic */ Function lambda$writeFrame$13(RowSignature signature, String columnName) {
        int columnNumber = signature.indexOf(columnName);
        return row -> columnNumber >= 0 ? row.get(columnNumber) : null;
    }

    static {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        BuiltInTypesModule.registerHandlersAndSerde();
    }

    private static class OverrideCapabilitiesColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final ColumnSelectorFactory delegate;
        private final Consumer<ColumnCapabilitiesImpl> fn;

        public OverrideCapabilitiesColumnSelectorFactory(ColumnSelectorFactory delegate, Consumer<ColumnCapabilitiesImpl> fn) {
            this.delegate = delegate;
            this.fn = fn;
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        public ColumnValueSelector makeColumnValueSelector(String columnName) {
            return this.delegate.makeColumnValueSelector(columnName);
        }

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            ColumnCapabilities capabilities = this.delegate.getColumnCapabilities(column);
            if (capabilities == null) {
                return null;
            }
            ColumnCapabilitiesImpl retVal = ColumnCapabilitiesImpl.copyOf((ColumnCapabilities)capabilities);
            this.fn.accept(retVal);
            return retVal;
        }

        @Nullable
        public RowIdSupplier getRowIdSupplier() {
            return this.delegate.getRowIdSupplier();
        }
    }
}

