/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.MappableObject;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;

public class JsonConfiguratorTest {
    private static final String PROP_PREFIX = "test.property.prefix.";
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private final Properties properties = new Properties();
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();
    @Rule
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();
    final Validator validator = new Validator(){

        public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
            return ImmutableSet.of();
        }

        public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
            return ImmutableSet.of();
        }

        public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
            return ImmutableSet.of();
        }

        public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
            return null;
        }

        public <T> T unwrap(Class<T> type) {
            return null;
        }

        public ExecutableValidator forExecutables() {
            return null;
        }
    };

    @Before
    public void setUp() {
        this.jsonMapper.registerSubtypes(new Class[]{MappableObject.class});
    }

    @Test
    public void testTest() {
        Assert.assertEquals((Object)new MappableObject("p1", (List<String>)ImmutableList.of((Object)"p2"), "p2"), (Object)new MappableObject("p1", (List<String>)ImmutableList.of((Object)"p2"), "p2"));
        Assert.assertEquals((Object)new MappableObject("p1", null, null), (Object)new MappableObject("p1", (List<String>)ImmutableList.of(), null));
    }

    @Test
    public void testSimpleConfigurate() {
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "prop1");
        this.properties.setProperty("test.property.prefix.prop1List", "[\"prop2\"]");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"prop1", (Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of((Object)"prop2"), obj.prop1List);
    }

    @Test
    public void testMissingConfigList() {
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "prop1");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"prop1", (Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of(), obj.prop1List);
    }

    @Test
    public void testMissingConfig() {
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1List", "[\"prop2\"]");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertNull((Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of((Object)"prop2"), obj.prop1List);
    }

    @Test
    public void testQuotedConfig() {
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "testing \"prop1\"");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"testing \"prop1\"", (Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of(), obj.prop1List);
    }

    @Test
    public void testPropertyWithDot() {
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop2.prop.2", "testing");
        this.properties.setProperty("test.property.prefix.prop1", "prop1");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"testing", (Object)obj.prop2);
        Assert.assertEquals((Object)ImmutableList.of(), obj.prop1List);
        Assert.assertEquals((Object)"prop1", (Object)obj.prop1);
    }

    @Test
    public void testPropertyInterpolation() {
        System.setProperty("my.property", "value1");
        ImmutableList list = ImmutableList.of((Object)"list", (Object)"of", (Object)"strings");
        this.environmentVariables.set("MY_VAR", "value2");
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "${sys:my.property}");
        this.properties.setProperty("test.property.prefix.prop1List", "${file:UTF-8:src/test/resources/list.json}");
        this.properties.setProperty("test.property.prefix.prop2.prop.2", "${env:MY_VAR}");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)System.getProperty("my.property"), (Object)obj.prop1);
        Assert.assertEquals((Object)list, obj.prop1List);
        Assert.assertEquals((Object)"value2", (Object)obj.prop2);
    }

    @Test
    public void testPropertyInterpolationInName() {
        System.setProperty("my.property", "value1");
        ImmutableList list = ImmutableList.of((Object)"list", (Object)"of", (Object)"strings");
        this.environmentVariables.set("MY_VAR", "value2");
        this.environmentVariables.set("SYS_PROP", "my.property");
        System.setProperty("json.path", "src/test/resources/list.json");
        this.environmentVariables.set("PROP2_NAME", "MY_VAR");
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "${sys:${env:SYS_PROP}}");
        this.properties.setProperty("test.property.prefix.prop1List", "${file:UTF-8:${sys:json.path}}");
        this.properties.setProperty("test.property.prefix.prop2.prop.2", "${env:${env:PROP2_NAME}}");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)System.getProperty("my.property"), (Object)obj.prop1);
        Assert.assertEquals((Object)list, obj.prop1List);
        Assert.assertEquals((Object)"value2", (Object)obj.prop2);
    }

    @Test
    public void testPropertyInterpolationFallback() {
        ImmutableList list = ImmutableList.of((Object)"list", (Object)"of", (Object)"strings");
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "${sys:my.property:-value1}");
        this.properties.setProperty("test.property.prefix.prop1List", "${unknown:-[\"list\", \"of\", \"strings\"]}");
        this.properties.setProperty("test.property.prefix.prop2.prop.2", "${MY_VAR:-value2}");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"value1", (Object)obj.prop1);
        Assert.assertEquals((Object)list, obj.prop1List);
        Assert.assertEquals((Object)"value2", (Object)obj.prop2);
    }

    @Test
    public void testPropertyInterpolationUndefinedException() {
        JsonConfigurator configurator = new JsonConfigurator(this.jsonMapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "${sys:my.property}");
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            MappableObject cfr_ignored_0 = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        });
    }
}

