/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.net.HostAndPort;
import java.net.MalformedURLException;
import java.net.URL;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.indexer.TaskLocation;
import org.junit.Assert;
import org.junit.Test;

public class TaskLocationTest {
    @Test
    public void testMakeURL() throws MalformedURLException {
        Assert.assertEquals((Object)new URL("http://abc:80/foo"), (Object)new TaskLocation("abc", 80, 0, null).makeURL("/foo"));
        Assert.assertEquals((Object)new URL("http://abc:80/foo"), (Object)new TaskLocation("abc", 80, -1, null).makeURL("/foo"));
        Assert.assertEquals((Object)new URL("https://abc:443/foo"), (Object)new TaskLocation("abc", 80, 443, null).makeURL("/foo"));
        Assert.assertThrows((String)"URL that does not start with '/'", IllegalArgumentException.class, () -> new TaskLocation("abc", 80, 443, null).makeURL("foo"));
    }

    @Test
    public void testTlsForPeonJobs() {
        TaskLocation noTls = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)false);
        Assert.assertEquals((long)-1L, (long)noTls.getTlsPort());
        Assert.assertEquals((long)1L, (long)noTls.getPort());
        TaskLocation tls = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)true);
        Assert.assertEquals((long)-1L, (long)tls.getPort());
        Assert.assertEquals((long)2L, (long)tls.getTlsPort());
    }

    @Test
    public void testDefaultK8sJobName() {
        TaskLocation noK8sJobName = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)false);
        Assert.assertNull((Object)noK8sJobName.getK8sPodName());
        noK8sJobName = TaskLocation.create((String)"foo", (int)1, (int)2);
        Assert.assertNull((Object)noK8sJobName.getK8sPodName());
    }

    @Test
    public void testK8sJobNameSet() {
        TaskLocation k8sJobName = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)false, (String)"job-name");
        Assert.assertEquals((Object)"job-name", (Object)k8sJobName.getK8sPodName());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(TaskLocation.class).usingGetClass().verify();
    }

    @Test
    public void testGetLocationWithK8sPodNameShouldReturnK8sPodName() {
        TaskLocation taskLocation = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)false, (String)"job-name");
        Assert.assertEquals((Object)"job-name", (Object)taskLocation.getLocation());
    }

    @Test
    public void testGetLocationWithK8sPodNameAndTlsShouldReturnK8sPodName() {
        TaskLocation taskLocation = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)true, (String)"job-name");
        Assert.assertEquals((Object)"job-name", (Object)taskLocation.getLocation());
    }

    @Test
    public void testGetLocationWithK8sPodNameAndNoHostShouldReturnK8sPodName() {
        TaskLocation taskLocation = TaskLocation.create(null, (int)1, (int)2, (boolean)true, (String)"job-name");
        Assert.assertEquals((Object)"job-name", (Object)taskLocation.getLocation());
    }

    @Test
    public void testGetLocationWithoutK8sPodNameAndHostShouldReturnNull() {
        TaskLocation taskLocation = TaskLocation.create(null, (int)1, (int)2, (boolean)false);
        Assert.assertNull((Object)taskLocation.getLocation());
    }

    @Test
    public void testGetLocationWithoutK8sPodNameAndNoTlsPortShouldReturnLocation() {
        TaskLocation taskLocation = TaskLocation.create((String)"foo", (int)1, (int)-1, (boolean)false);
        Assert.assertEquals((Object)HostAndPort.fromParts((String)"foo", (int)1).toString(), (Object)taskLocation.getLocation());
    }

    @Test
    public void testGetLocationWithoutK8sPodNameAndNonZeroTlsPortShouldReturnLocation() {
        TaskLocation taskLocation = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)true);
        Assert.assertEquals((Object)HostAndPort.fromParts((String)"foo", (int)2).toString(), (Object)taskLocation.getLocation());
    }
}

