/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import com.google.common.io.FileWriteMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.utils.CompressionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CompressionUtilsTest {
    private static final String CONTENT;
    private static final byte[] EXPECTED;
    private static final byte[] GZ_BYTES;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File testDir;
    private File testFile;

    public static void assertGoodDataStream(InputStream stream) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(EXPECTED.length);){
            ByteStreams.copy((InputStream)stream, (OutputStream)bos);
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])bos.toByteArray());
        }
    }

    @Before
    public void setUp() throws IOException {
        this.testDir = this.temporaryFolder.newFolder("testDir");
        this.testFile = new File(this.testDir, "test.dat");
        try (FileOutputStream outputStream = new FileOutputStream(this.testFile);){
            ((OutputStream)outputStream).write(StringUtils.toUtf8((String)CONTENT));
        }
        Assert.assertTrue((boolean)this.testFile.getParentFile().equals(this.testDir));
    }

    @Test
    public void testGoodGzNameResolution() {
        Assert.assertEquals((Object)"foo", (Object)CompressionUtils.getGzBaseName((String)"foo.gz"));
    }

    @Test(expected=IAE.class)
    public void testBadGzName() {
        CompressionUtils.getGzBaseName((String)"foo");
    }

    @Test(expected=IAE.class)
    public void testBadShortGzName() {
        CompressionUtils.getGzBaseName((String)".gz");
    }

    @Test
    public void testGoodZipCompressUncompress() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodZipCompressUncompress");
        File zipFile = new File(tmpDir, "compressionUtilTest.zip");
        CompressionUtils.zip((File)this.testDir, (File)zipFile);
        File newDir = new File(tmpDir, "newDir");
        newDir.mkdir();
        FileUtils.FileCopyResult result = CompressionUtils.unzip((File)zipFile, (File)newDir);
        this.verifyUnzip(newDir, result, (Map<String, byte[]>)ImmutableMap.of((Object)this.testFile.getName(), (Object)StringUtils.toUtf8((String)CONTENT)));
    }

    @Test
    public void testGoodZipCompressUncompressWithLocalCopy() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodZipCompressUncompressWithLocalCopy");
        final File zipFile = new File(tmpDir, "testGoodZipCompressUncompressWithLocalCopy.zip");
        CompressionUtils.zip((File)this.testDir, (File)zipFile);
        File newDir = new File(tmpDir, "newDir");
        newDir.mkdir();
        FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)new ByteSource(){

            public InputStream openStream() throws IOException {
                return new FileInputStream(zipFile);
            }
        }, (File)newDir, (Predicate)FileUtils.IS_EXCEPTION, (boolean)true);
        this.verifyUnzip(newDir, result, (Map<String, byte[]>)ImmutableMap.of((Object)this.testFile.getName(), (Object)StringUtils.toUtf8((String)CONTENT)));
    }

    @Test
    public void testGoodGZCompressUncompressToFile() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGZCompressUncompressToFile");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((File)this.testFile, (File)gzFile);
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = new GZIPInputStream(new FileInputStream(gzFile));){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        this.testFile.delete();
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((File)gzFile, (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var4_4 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var4_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testGoodZipStream() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodZipStream");
        File zipFile = new File(tmpDir, "compressionUtilTest.zip");
        CompressionUtils.zip((File)this.testDir, (OutputStream)new FileOutputStream(zipFile));
        File newDir = new File(tmpDir, "newDir");
        newDir.mkdir();
        FileUtils.FileCopyResult result = CompressionUtils.unzip((InputStream)new FileInputStream(zipFile), (File)newDir);
        this.verifyUnzip(newDir, result, (Map<String, byte[]>)ImmutableMap.of((Object)this.testFile.getName(), (Object)StringUtils.toUtf8((String)CONTENT)));
    }

    private Map<String, byte[]> writeZipWithManyFiles(File zipFile) throws IOException {
        File srcDir = this.temporaryFolder.newFolder();
        HashMap<String, byte[]> expectedFiles = new HashMap<String, byte[]>();
        for (int i = 0; i < 100; ++i) {
            String filePath = "file" + i;
            try (FileOutputStream out = new FileOutputStream(new File(srcDir, filePath));){
                out.write(i);
                expectedFiles.put(filePath, new byte[]{(byte)i});
                continue;
            }
        }
        CompressionUtils.zip((File)srcDir, (OutputStream)new FileOutputStream(zipFile));
        return expectedFiles;
    }

    @Test
    public void testZipWithManyFiles() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testZipWithManyFilesStream");
        File zipFile = new File(tmpDir, "compressionUtilTest.zip");
        Map<String, byte[]> expectedFiles = this.writeZipWithManyFiles(zipFile);
        File unzipDir = new File(tmpDir, "unzipDir");
        unzipDir.mkdir();
        FileUtils.FileCopyResult result = CompressionUtils.unzip((File)zipFile, (File)unzipDir);
        this.verifyUnzip(unzipDir, result, expectedFiles);
    }

    @Test
    public void testZipWithManyFilesStreamWithLocalCopy() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testZipWithManyFilesStream");
        final File zipFile = new File(tmpDir, "compressionUtilTest.zip");
        Map<String, byte[]> expectedFiles = this.writeZipWithManyFiles(zipFile);
        File unzipDir = new File(tmpDir, "unzipDir");
        unzipDir.mkdir();
        FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)new ByteSource(){

            public InputStream openStream() throws IOException {
                return new FileInputStream(zipFile);
            }
        }, (File)unzipDir, (Predicate)FileUtils.IS_EXCEPTION, (boolean)true);
        this.verifyUnzip(unzipDir, result, expectedFiles);
    }

    @Test
    public void testZipWithManyFilesStream() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testZipWithManyFilesStream");
        File zipFile = new File(tmpDir, "compressionUtilTest.zip");
        Map<String, byte[]> expectedFiles = this.writeZipWithManyFiles(zipFile);
        File unzipDir = new File(tmpDir, "unzipDir");
        unzipDir.mkdir();
        try (CountingInputStream zipIn = new CountingInputStream((InputStream)new FileInputStream(zipFile));){
            FileUtils.FileCopyResult result = CompressionUtils.unzip((InputStream)zipIn, (File)unzipDir);
            this.verifyUnzip(unzipDir, result, expectedFiles);
            Assert.assertEquals((long)zipFile.length(), (long)zipIn.getCount());
        }
    }

    @Test
    public void testGoodGzipByteSource() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((ByteSource)com.google.common.io.Files.asByteSource((File)this.testFile), (ByteSink)com.google.common.io.Files.asByteSink((File)gzFile, (FileWriteMode[])new FileWriteMode[0]), (Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(gzFile), (String)gzFile.getName());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (!this.testFile.delete()) {
            throw new IOE("Unable to delete file [%s]", new Object[]{this.testFile.getAbsolutePath()});
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((ByteSource)com.google.common.io.Files.asByteSource((File)gzFile), (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var4_4 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var4_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testDecompressBzip2() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testDecompressBzip2");
        File bzFile = new File(tmpDir, this.testFile.getName() + ".bz2");
        Assert.assertFalse((boolean)bzFile.exists());
        try (BZip2CompressorOutputStream out = new BZip2CompressorOutputStream((OutputStream)new FileOutputStream(bzFile));){
            ByteStreams.copy((InputStream)new FileInputStream(this.testFile), (OutputStream)out);
        }
        var4_4 = null;
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(bzFile), (String)bzFile.getName());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDecompressXz() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testDecompressXz");
        File xzFile = new File(tmpDir, this.testFile.getName() + ".xz");
        Assert.assertFalse((boolean)xzFile.exists());
        try (XZCompressorOutputStream out = new XZCompressorOutputStream((OutputStream)new FileOutputStream(xzFile));){
            ByteStreams.copy((InputStream)new FileInputStream(this.testFile), (OutputStream)out);
        }
        var4_4 = null;
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(xzFile), (String)xzFile.getName());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDecompressSnappy() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testDecompressSnappy");
        File snappyFile = new File(tmpDir, this.testFile.getName() + ".sz");
        Assert.assertFalse((boolean)snappyFile.exists());
        try (FramedSnappyCompressorOutputStream out = new FramedSnappyCompressorOutputStream((OutputStream)new FileOutputStream(snappyFile));){
            ByteStreams.copy((InputStream)new FileInputStream(this.testFile), (OutputStream)out);
        }
        var4_4 = null;
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(snappyFile), (String)snappyFile.getName());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDecompressZstd() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testDecompressZstd");
        File zstdFile = new File(tmpDir, this.testFile.getName() + ".zst");
        Assert.assertFalse((boolean)zstdFile.exists());
        try (ZstdCompressorOutputStream out = new ZstdCompressorOutputStream((OutputStream)new FileOutputStream(zstdFile));){
            ByteStreams.copy((InputStream)new FileInputStream(this.testFile), (OutputStream)out);
        }
        var4_4 = null;
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(zstdFile), (String)zstdFile.getName());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDecompressZip() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testDecompressZip");
        File zipFile = new File(tmpDir, this.testFile.getName() + ".zip");
        Assert.assertFalse((boolean)zipFile.exists());
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));){
            out.putNextEntry(new ZipEntry("cool.file"));
            ByteStreams.copy((InputStream)new FileInputStream(this.testFile), (OutputStream)out);
            out.closeEntry();
        }
        var4_4 = null;
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(zipFile), (String)zipFile.getName());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDecompressZipWithManyFiles() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testDecompressZip");
        File zipFile = new File(tmpDir, this.testFile.getName() + ".zip");
        this.writeZipWithManyFiles(zipFile);
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(zipFile), (String)zipFile.getName());){
            Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])ByteStreams.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    public void testGoodGZStream() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGZStream");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((InputStream)new FileInputStream(this.testFile), (OutputStream)new FileOutputStream(gzFile));
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = new GZIPInputStream(new FileInputStream(gzFile));){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (!this.testFile.delete()) {
            throw new IOE("Unable to delete file [%s]", new Object[]{this.testFile.getAbsolutePath()});
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((InputStream)new FileInputStream(gzFile), (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var4_4 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var4_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testEvilZip() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testEvilZip");
        File evilResult = new File("/tmp/evil.txt");
        Files.deleteIfExists(evilResult.toPath());
        File evilZip = new File(tmpDir, "evil.zip");
        Files.deleteIfExists(evilZip.toPath());
        CompressionUtilsTest.makeEvilZip(evilZip);
        try {
            CompressionUtils.unzip((File)evilZip, (File)tmpDir);
        }
        catch (ISE ise) {
            Assert.assertTrue((boolean)ise.getMessage().contains("does not start with outDir"));
            Assert.assertFalse((String)"Zip exploit triggered, /tmp/evil.txt was written.", (boolean)evilResult.exists());
            return;
        }
        Assert.fail((String)"Exception was not thrown for malicious zip file");
    }

    @Test
    public void testEvilZipInputStream() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testEvilZip");
        File evilResult = new File("/tmp/evil.txt");
        Files.deleteIfExists(evilResult.toPath());
        File evilZip = new File(tmpDir, "evil.zip");
        Files.deleteIfExists(evilZip.toPath());
        CompressionUtilsTest.makeEvilZip(evilZip);
        try {
            CompressionUtils.unzip((InputStream)new FileInputStream(evilZip), (File)tmpDir);
        }
        catch (ISE ise) {
            Assert.assertTrue((boolean)ise.getMessage().contains("does not start with outDir"));
            Assert.assertFalse((String)"Zip exploit triggered, /tmp/evil.txt was written.", (boolean)evilResult.exists());
            return;
        }
        Assert.fail((String)"Exception was not thrown for malicious zip file");
    }

    @Test
    public void testEvilZipInputStreamWithLocalCopy() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testEvilZip");
        File evilResult = new File("/tmp/evil.txt");
        Files.deleteIfExists(evilResult.toPath());
        final File evilZip = new File(tmpDir, "evil.zip");
        Files.deleteIfExists(evilZip.toPath());
        CompressionUtilsTest.makeEvilZip(evilZip);
        try {
            CompressionUtils.unzip((ByteSource)new ByteSource(){

                public InputStream openStream() throws IOException {
                    return new FileInputStream(evilZip);
                }
            }, (File)tmpDir, (Predicate)FileUtils.IS_EXCEPTION, (boolean)true);
        }
        catch (ISE ise) {
            Assert.assertTrue((boolean)ise.getMessage().contains("does not start with outDir"));
            Assert.assertFalse((String)"Zip exploit triggered, /tmp/evil.txt was written.", (boolean)evilResult.exists());
            return;
        }
        Assert.fail((String)"Exception was not thrown for malicious zip file");
    }

    @Test
    public void testZeroRemainingInputStream() throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(this.testFile);){
            Assert.assertEquals((long)GZ_BYTES.length, (long)ByteStreams.copy((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(GZ_BYTES)), (OutputStream)outputStream));
            Assert.assertEquals((long)GZ_BYTES.length, (long)ByteStreams.copy((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(GZ_BYTES)), (OutputStream)outputStream));
            Assert.assertEquals((long)GZ_BYTES.length, (long)ByteStreams.copy((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(GZ_BYTES)), (OutputStream)outputStream));
        }
        Assert.assertEquals((long)(GZ_BYTES.length * 3), (long)this.testFile.length());
        var2_2 = null;
        try (ZeroRemainingInputStream inputStream = new ZeroRemainingInputStream(new FileInputStream(this.testFile));){
            for (int i = 0; i < 3; ++i) {
                byte[] bytes = new byte[GZ_BYTES.length];
                Assert.assertEquals((long)bytes.length, (long)((InputStream)inputStream).read(bytes));
                Assert.assertArrayEquals((String)StringUtils.format((String)"Failed on range %d", (Object[])new Object[]{i}), (byte[])GZ_BYTES, (byte[])bytes);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test(expected=AssertionError.class)
    public void testGunzipBug() throws IOException {
        ByteArrayOutputStream tripleGzByteStream = new ByteArrayOutputStream(GZ_BYTES.length * 3);
        tripleGzByteStream.write(GZ_BYTES);
        tripleGzByteStream.write(GZ_BYTES);
        tripleGzByteStream.write(GZ_BYTES);
        try (GZIPInputStream inputStream = new GZIPInputStream(new ZeroRemainingInputStream(new ByteArrayInputStream(tripleGzByteStream.toByteArray())));
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream(EXPECTED.length * 3);){
            Assert.assertEquals((String)"Read terminated too soon (bug 7036144)", (long)(EXPECTED.length * 3), (long)ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream));
            byte[] found = outputStream.toByteArray();
            Assert.assertEquals((long)(EXPECTED.length * 3), (long)found.length);
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 0, EXPECTED.length * 1));
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 1, EXPECTED.length * 2));
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 2, EXPECTED.length * 3));
        }
    }

    @Test
    public void testGunzipBugworkarround() throws IOException {
        this.testFile.delete();
        Assert.assertFalse((boolean)this.testFile.exists());
        final ByteArrayOutputStream tripleGzByteStream = new ByteArrayOutputStream(GZ_BYTES.length * 3);
        tripleGzByteStream.write(GZ_BYTES);
        tripleGzByteStream.write(GZ_BYTES);
        tripleGzByteStream.write(GZ_BYTES);
        ByteSource inputStreamFactory = new ByteSource(){

            public InputStream openStream() {
                return new ZeroRemainingInputStream(new ByteArrayInputStream(tripleGzByteStream.toByteArray()));
            }
        };
        Assert.assertEquals((long)(EXPECTED.length * 3), (long)CompressionUtils.gunzip((ByteSource)inputStreamFactory, (File)this.testFile).size());
        try (FileInputStream inputStream = new FileInputStream(this.testFile);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream(EXPECTED.length * 3);){
            Assert.assertEquals((String)"Read terminated too soon (7036144)", (long)(EXPECTED.length * 3), (long)ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream));
            byte[] found = outputStream.toByteArray();
            Assert.assertEquals((long)(EXPECTED.length * 3), (long)found.length);
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 0, EXPECTED.length * 1));
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 1, EXPECTED.length * 2));
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 2, EXPECTED.length * 3));
        }
    }

    @Test
    public void testGunzipBugStreamWorkarround() throws IOException {
        ByteArrayOutputStream tripleGzByteStream = new ByteArrayOutputStream(GZ_BYTES.length * 3);
        tripleGzByteStream.write(GZ_BYTES);
        tripleGzByteStream.write(GZ_BYTES);
        tripleGzByteStream.write(GZ_BYTES);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(EXPECTED.length * 3);){
            Assert.assertEquals((long)(EXPECTED.length * 3), (long)CompressionUtils.gunzip((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(tripleGzByteStream.toByteArray())), (OutputStream)bos));
            byte[] found = bos.toByteArray();
            Assert.assertEquals((long)(EXPECTED.length * 3), (long)found.length);
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 0, EXPECTED.length * 1));
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 1, EXPECTED.length * 2));
            Assert.assertArrayEquals((byte[])EXPECTED, (byte[])Arrays.copyOfRange(found, EXPECTED.length * 2, EXPECTED.length * 3));
        }
    }

    @Test
    public void testZipName() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testZipName");
        File zipDir = new File(tmpDir, "zipDir");
        zipDir.mkdir();
        File file = new File(tmpDir, "zipDir.zip");
        Path unzipPath = Paths.get(zipDir.getPath(), "test.dat");
        file.delete();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)unzipPath.toFile().exists());
        CompressionUtils.zip((File)this.testDir, (File)file);
        Assert.assertTrue((boolean)file.exists());
        CompressionUtils.unzip((File)file, (File)zipDir);
        Assert.assertTrue((boolean)unzipPath.toFile().exists());
        try (FileInputStream inputStream = new FileInputStream(unzipPath.toFile());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
    }

    @Test
    public void testNewFileDoesntCreateFile() {
        File tmpFile = new File(this.testDir, "fofooofodshfudhfwdjkfwf.dat");
        Assert.assertFalse((boolean)tmpFile.exists());
    }

    @Test
    public void testGoodGzipName() {
        Assert.assertEquals((Object)"foo", (Object)CompressionUtils.getGzBaseName((String)"foo.gz"));
    }

    @Test
    public void testGoodGzipNameWithPath() {
        Assert.assertEquals((Object)"foo", (Object)CompressionUtils.getGzBaseName((String)"/tar/ball/baz/bock/foo.gz"));
    }

    @Test(expected=IAE.class)
    public void testBadShortName() {
        CompressionUtils.getGzBaseName((String)".gz");
    }

    @Test(expected=IAE.class)
    public void testBadName() {
        CompressionUtils.getGzBaseName((String)"BANANAS");
    }

    @Test(expected=IAE.class)
    public void testBadNameWithPath() {
        CompressionUtils.getGzBaseName((String)"/foo/big/.gz");
    }

    @Test
    public void testGoodGzipWithException() throws Exception {
        final AtomicLong flushes = new AtomicLong(0L);
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        final File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((ByteSource)com.google.common.io.Files.asByteSource((File)this.testFile), (ByteSink)new ByteSink(){

            public OutputStream openStream() throws IOException {
                return new FilterOutputStream(new FileOutputStream(gzFile)){

                    @Override
                    public void flush() throws IOException {
                        if (flushes.getAndIncrement() <= 0L) {
                            throw new IOException("Haven't flushed enough");
                        }
                        super.flush();
                    }
                };
            }
        }, (Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(gzFile), (String)"file.gz");){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (!this.testFile.delete()) {
            throw new IOE("Unable to delete file [%s]", new Object[]{this.testFile.getAbsolutePath()});
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((ByteSource)com.google.common.io.Files.asByteSource((File)gzFile), (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var5_5 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var5_5 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        Assert.assertEquals((long)4L, (long)flushes.get());
    }

    @Test(expected=IOException.class)
    public void testStreamErrorGzip() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        final AtomicLong flushes = new AtomicLong(0L);
        CompressionUtils.gzip((InputStream)new FileInputStream(this.testFile), (OutputStream)new FileOutputStream(gzFile){

            @Override
            public void flush() throws IOException {
                if (flushes.getAndIncrement() <= 0L) {
                    throw new IOException("Test exception");
                }
                super.flush();
            }
        });
    }

    @Test(expected=IOException.class)
    public void testStreamErrorGunzip() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((ByteSource)com.google.common.io.Files.asByteSource((File)this.testFile), (ByteSink)com.google.common.io.Files.asByteSink((File)gzFile, (FileWriteMode[])new FileWriteMode[0]), (Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = CompressionUtils.decompress((InputStream)new FileInputStream(gzFile), (String)"file.gz");){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (this.testFile.exists() && !this.testFile.delete()) {
            throw new RE("Unable to delete file [%s]", new Object[]{this.testFile.getAbsolutePath()});
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        final AtomicLong flushes = new AtomicLong(0L);
        CompressionUtils.gunzip((InputStream)new FileInputStream(gzFile), (OutputStream)new FilterOutputStream(new FileOutputStream(this.testFile){

            @Override
            public void flush() throws IOException {
                if (flushes.getAndIncrement() <= 0L) {
                    throw new IOException("Test exception");
                }
                super.flush();
            }
        }));
    }

    private void verifyUnzip(File unzipDir, FileUtils.FileCopyResult result, Map<String, byte[]> expectedFiles) throws IOException {
        List filePaths = expectedFiles.keySet().stream().sorted().collect(Collectors.toList());
        Assert.assertEquals((long)expectedFiles.values().stream().mapToLong(arr -> ((byte[])arr).length).sum(), (long)result.size());
        Assert.assertEquals(filePaths.stream().map(filePath -> new File(unzipDir, (String)filePath)).collect(Collectors.toList()), result.getFiles().stream().sorted().collect(Collectors.toList()));
        Assert.assertEquals(filePaths, Arrays.stream(unzipDir.listFiles()).map(File::getName).sorted().collect(Collectors.toList()));
        for (Map.Entry<String, byte[]> entry : expectedFiles.entrySet()) {
            FileInputStream in = new FileInputStream(new File(unzipDir, entry.getKey()));
            Throwable throwable = null;
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)in);
                Assert.assertArrayEquals((byte[])entry.getValue(), (byte[])bytes);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    public static void makeEvilZip(File outputFile) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(outputFile));
        ZipEntry zipEntry = new ZipEntry("../../../../../../../../../../../../../../../tmp/evil.txt");
        zipOutputStream.putNextEntry(zipEntry);
        byte[] output = StringUtils.toUtf8((String)"evil text");
        zipOutputStream.write(output);
        zipOutputStream.closeEntry();
        zipOutputStream.close();
    }

    static {
        StringBuilder builder = new StringBuilder();
        try (InputStream stream = CompressionUtilsTest.class.getClassLoader().getResourceAsStream("white-rabbit.txt");){
            Scanner it = new Scanner(new InputStreamReader(stream, StandardCharsets.UTF_8)).useDelimiter(Pattern.quote(System.lineSeparator()));
            while (it.hasNext()) {
                builder.append((String)it.next());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CONTENT = builder.toString();
        EXPECTED = StringUtils.toUtf8((String)CONTENT);
        ByteArrayOutputStream gzByteStream = new ByteArrayOutputStream(EXPECTED.length);
        try (GZIPOutputStream outputStream = new GZIPOutputStream(gzByteStream);
             ByteArrayInputStream in = new ByteArrayInputStream(EXPECTED);){
            ByteStreams.copy((InputStream)in, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GZ_BYTES = gzByteStream.toByteArray();
    }

    private static class ZeroRemainingInputStream
    extends FilterInputStream {
        private final AtomicInteger pos = new AtomicInteger(0);

        protected ZeroRemainingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public synchronized void reset() throws IOException {
            super.reset();
            this.pos.set(0);
        }

        @Override
        public int read(byte[] b) throws IOException {
            int len = Math.min(b.length, GZ_BYTES.length - this.pos.get() % GZ_BYTES.length);
            this.pos.addAndGet(len);
            return this.read(b, 0, len);
        }

        @Override
        public int read() throws IOException {
            this.pos.incrementAndGet();
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int l = Math.min(len, GZ_BYTES.length - this.pos.get() % GZ_BYTES.length);
            this.pos.addAndGet(l);
            return super.read(b, off, l);
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

