/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.druid.java.util.common.BufferUtils;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MappedByteBufferHandler;
import org.apache.druid.java.util.common.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.TemporaryFolder;

public class FileUtilsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testMap() throws IOException {
        File dataFile = this.temporaryFolder.newFile("data");
        long buffersMemoryBefore = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        try (RandomAccessFile raf = new RandomAccessFile(dataFile, "rw");){
            raf.write(42);
            raf.setLength(0x100000L);
        }
        var5_5 = null;
        try (MappedByteBufferHandler mappedByteBufferHandler = FileUtils.map((File)dataFile);){
            Assert.assertEquals((long)42L, (long)mappedByteBufferHandler.get().get(0));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        long buffersMemoryAfter = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        Assert.assertEquals((long)buffersMemoryBefore, (long)buffersMemoryAfter);
    }

    @Test
    public void testMapFileTooLarge() throws IOException {
        File dataFile = this.temporaryFolder.newFile("data");
        try (RandomAccessFile raf = new RandomAccessFile(dataFile, "rw");){
            raf.write(42);
            raf.setLength(0x100000L);
        }
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> FileUtils.map((File)dataFile, (long)0L, (long)0x80000000L));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot map region larger than"));
    }

    @Test
    public void testMapRandomAccessFileTooLarge() throws IOException {
        File dataFile = this.temporaryFolder.newFile("data");
        try (RandomAccessFile raf = new RandomAccessFile(dataFile, "rw");){
            raf.write(42);
            raf.setLength(0x100000L);
        }
        raf = new RandomAccessFile(dataFile, "r");
        var3_3 = null;
        try {
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> FileUtils.map((RandomAccessFile)raf, (long)0L, (long)0x80000000L));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot map region larger than"));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (raf != null) {
                if (var3_3 != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    raf.close();
                }
            }
        }
    }

    @Test
    public void testWriteAtomically() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = new File(tmpDir, "file1");
        FileUtils.writeAtomically((File)tmpFile, out -> {
            out.write(StringUtils.toUtf8((String)"foo"));
            return null;
        });
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
        try {
            FileUtils.writeAtomically((File)tmpFile, out -> {
                out.write(StringUtils.toUtf8((String)"bar"));
                out.flush();
                throw new ISE("OMG!", new Object[0]);
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
        FileUtils.writeAtomically((File)tmpFile, out -> {
            out.write(StringUtils.toUtf8((String)"baz"));
            return null;
        });
        Assert.assertEquals((Object)"baz", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
    }

    @Test
    public void testCreateTempDir() throws IOException {
        File tempDir = FileUtils.createTempDir();
        try {
            Assert.assertEquals((Object)new File(System.getProperty("java.io.tmpdir")).toPath(), (Object)tempDir.getParentFile().toPath());
        }
        finally {
            Files.delete(tempDir.toPath());
        }
    }

    @Test
    public void testCreateTempDirInLocation() throws IOException {
        File baseDir = this.temporaryFolder.newFolder();
        File tmp = FileUtils.createTempDirInLocation((Path)baseDir.toPath(), null);
        Assert.assertTrue((boolean)tmp.getName().startsWith("druid"));
        Assert.assertEquals((Object)baseDir.toPath(), (Object)tmp.getParentFile().toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTempDirNonexistentBase() {
        String oldJavaTmpDir = System.getProperty("java.io.tmpdir");
        String nonExistentDir = oldJavaTmpDir + "nonexistent";
        try {
            System.setProperty("java.io.tmpdir", nonExistentDir);
            Throwable e = Assert.assertThrows(IllegalStateException.class, () -> FileUtils.createTempDir());
            Assert.assertEquals((Object)("Path [" + nonExistentDir + "] does not exist"), (Object)e.getMessage());
        }
        finally {
            System.setProperty("java.io.tmpdir", oldJavaTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTempDirUnwritableBase() throws IOException {
        File baseDir = FileUtils.createTempDir();
        String oldJavaTmpDir = System.getProperty("java.io.tmpdir");
        try {
            System.setProperty("java.io.tmpdir", baseDir.getPath());
            baseDir.setWritable(false);
            Throwable e = Assert.assertThrows(IllegalStateException.class, () -> FileUtils.createTempDir());
            Assert.assertEquals((Object)("Path [" + baseDir + "] is not writable, check permissions"), (Object)e.getMessage());
        }
        finally {
            baseDir.setWritable(true);
            Files.delete(baseDir.toPath());
            System.setProperty("java.io.tmpdir", oldJavaTmpDir);
        }
    }

    @Test
    public void testMkdirp() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder();
        File testDirectory = new File(tmpDir, "test");
        FileUtils.mkdirp((File)testDirectory);
        Assert.assertTrue((boolean)testDirectory.isDirectory());
        FileUtils.mkdirp((File)testDirectory);
        Assert.assertTrue((boolean)testDirectory.isDirectory());
    }

    @Test
    public void testMkdirpCannotCreateOverExistingFile() throws IOException {
        File tmpFile = this.temporaryFolder.newFile();
        Throwable t = Assert.assertThrows(IOException.class, () -> FileUtils.mkdirp((File)tmpFile));
        MatcherAssert.assertThat((Object)t, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot create directory")));
    }

    @Test
    public void testMkdirpCannotCreateInNonWritableDirectory() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder();
        File testDirectory = new File(tmpDir, "test");
        tmpDir.setWritable(false);
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> FileUtils.mkdirp((File)testDirectory));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot create directory")));
        tmpDir.setWritable(true);
        FileUtils.mkdirp((File)testDirectory);
        Assert.assertTrue((boolean)testDirectory.isDirectory());
    }

    @Test
    public void testCopyLarge() throws IOException {
        File dstDirectory = this.temporaryFolder.newFolder();
        File dstFile = new File(dstDirectory, "dst");
        String data = "test data to write";
        long result = FileUtils.copyLarge(() -> new ByteArrayInputStream(StringUtils.toUtf8((String)"test data to write")), (File)dstFile, (byte[])new byte[1024], (Predicate)Predicates.alwaysFalse(), (int)3, null);
        Assert.assertEquals((long)"test data to write".length(), (long)result);
        Assert.assertEquals((Object)"test data to write", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(dstFile.toPath())));
    }

    @Test
    public void testLinkOrCopy1() throws IOException {
        File fromFile = this.temporaryFolder.newFile();
        File toDir = this.temporaryFolder.newFolder();
        File toFile = new File(toDir, "toFile");
        Files.write(fromFile.toPath(), StringUtils.toUtf8((String)"foo"), new OpenOption[0]);
        FileUtils.LinkOrCopyResult linkOrCopyResult = FileUtils.linkOrCopy((File)fromFile, (File)toFile);
        Assert.assertEquals((Object)FileUtils.LinkOrCopyResult.LINK, (Object)linkOrCopyResult);
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(toFile.toPath())));
        Files.write(fromFile.toPath(), StringUtils.toUtf8((String)"bar"), new OpenOption[0]);
        Assert.assertEquals((Object)"bar", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(toFile.toPath())));
    }

    @Test
    public void testLinkOrCopy2() throws IOException {
        File fromFile = this.temporaryFolder.newFile();
        File toFile = this.temporaryFolder.newFile();
        Files.write(fromFile.toPath(), StringUtils.toUtf8((String)"foo"), new OpenOption[0]);
        FileUtils.LinkOrCopyResult linkOrCopyResult = FileUtils.linkOrCopy((File)fromFile, (File)toFile);
        Assert.assertEquals((Object)FileUtils.LinkOrCopyResult.COPY, (Object)linkOrCopyResult);
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(toFile.toPath())));
        Files.write(fromFile.toPath(), StringUtils.toUtf8((String)"bar"), new OpenOption[0]);
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(toFile.toPath())));
    }
}

