/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BytesFullResponseHolderTest {
    ObjectMapper objectMapper = (ObjectMapper)Mockito.spy((Object)new DefaultObjectMapper());

    @Test
    public void testDeserialize() throws Exception {
        ResponseObject payload = new ResponseObject("payload123");
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        BytesFullResponseHolder target = (BytesFullResponseHolder)Mockito.spy((Object)new BytesFullResponseHolder((HttpResponse)response));
        target.addChunk(this.objectMapper.writeValueAsBytes((Object)payload));
        ResponseObject deserialize = (ResponseObject)target.deserialize(this.objectMapper, (TypeReference)new TypeReference<ResponseObject>(){});
        Assert.assertEquals((Object)payload, (Object)deserialize);
        ((BytesFullResponseHolder)Mockito.verify((Object)target, (VerificationMode)Mockito.times((int)1))).deserialize((ObjectMapper)ArgumentMatchers.any(), (TypeReference)ArgumentMatchers.any());
    }

    @Test
    public void testDeserializeException() throws IOException {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        BytesFullResponseHolder target = (BytesFullResponseHolder)Mockito.spy((Object)new BytesFullResponseHolder((HttpResponse)response));
        ((ObjectMapper)Mockito.doThrow(IOException.class).when((Object)this.objectMapper)).readValue((byte[])ArgumentMatchers.isA(byte[].class), (TypeReference)ArgumentMatchers.isA(TypeReference.class));
        Assert.assertThrows(RuntimeException.class, () -> {
            ResponseObject cfr_ignored_0 = (ResponseObject)target.deserialize(this.objectMapper, (TypeReference)new TypeReference<ResponseObject>(){});
        });
        ((BytesFullResponseHolder)Mockito.verify((Object)target, (VerificationMode)Mockito.times((int)1))).deserialize((ObjectMapper)ArgumentMatchers.any(), (TypeReference)ArgumentMatchers.any());
    }

    static class ResponseObject {
        String payload;

        @JsonCreator
        public ResponseObject(@JsonProperty(value="payload") String payload) {
            this.payload = payload;
        }

        @JsonProperty(value="payload")
        public String getPayload() {
            return this.payload;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResponseObject that = (ResponseObject)o;
            return Objects.equals(this.payload, that.payload);
        }

        public int hashCode() {
            return Objects.hashCode(this.payload);
        }
    }
}

