/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.CgroupDiskMonitor;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CgroupDiskMonitorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private File servicedFile;
    private File serviceBytesFile;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws IOException {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(this.procDir.toPath());
        TestUtils.setUpCgroups(this.procDir, this.cgroupDir);
        File blkioDir = new File(this.cgroupDir, "blkio/system.slice/some.service/");
        FileUtils.mkdirp((File)blkioDir);
        this.servicedFile = new File(blkioDir, "blkio.throttle.io_serviced");
        this.serviceBytesFile = new File(blkioDir, "blkio.throttle.io_service_bytes");
        TestUtils.copyResource("/blkio.throttle.io_service_bytes", this.serviceBytesFile);
        TestUtils.copyResource("/blkio.throttle.io_serviced", this.servicedFile);
    }

    @Test
    public void testMonitor() throws IOException {
        CgroupDiskMonitor monitor = new CgroupDiskMonitor(this.discoverer, (Map)ImmutableMap.of(), "some_feed");
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        Assert.assertEquals((long)0L, (long)emitter.getEvents().size());
        TestUtils.copyOrReplaceResource("/blkio.throttle.io_service_bytes-2", this.serviceBytesFile);
        TestUtils.copyOrReplaceResource("/blkio.throttle.io_serviced-2", this.servicedFile);
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        Assert.assertEquals((long)8L, (long)emitter.getEvents().size());
        Assert.assertTrue((boolean)emitter.getEvents().stream().map(e -> e.toMap().get((Object)"value")).allMatch(val -> Long.valueOf(10L).equals(val)));
    }
}

