/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Disk;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DiskTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws Exception {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(this.procDir.toPath());
        TestUtils.setUpCgroups(this.procDir, this.cgroupDir);
        File blkioDir = new File(this.cgroupDir, "blkio/system.slice/some.service");
        FileUtils.mkdirp((File)blkioDir);
        TestUtils.copyResource("/blkio.throttle.io_serviced", new File(blkioDir, "blkio.throttle.io_serviced"));
        TestUtils.copyResource("/blkio.throttle.io_service_bytes", new File(blkioDir, "blkio.throttle.io_service_bytes"));
    }

    @Test
    public void testWontCrash() {
        Disk disk = new Disk(cgroup -> {
            throw new RuntimeException("shouldContinue");
        });
        Map stats = disk.snapshot();
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)stats);
    }

    @Test
    public void testSimpleSnapshot() {
        Map stats = new Disk(this.discoverer).snapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"259:0", (Object)"259:7"), stats.keySet());
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:0")).getReadCount(), (long)98L);
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:0")).getWriteCount(), (long)756L);
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:0")).getReadBytes(), (long)55000L);
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:0")).getWriteBytes(), (long)6208512L);
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:7")).getReadCount(), (long)26L);
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:7")).getWriteCount(), (long)0L);
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:7")).getReadBytes(), (long)0x1B1000L);
        Assert.assertEquals((long)((Disk.Metrics)stats.get("259:7")).getWriteBytes(), (long)0L);
    }
}

