/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerialization() throws IOException {
        TableDataSource dataSource = new TableDataSource("somedatasource");
        String json = JSON_MAPPER.writeValueAsString((Object)dataSource);
        DataSource serdeDataSource = (DataSource)JSON_MAPPER.readValue(json, DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serdeDataSource);
    }

    @Test
    public void testLegacyDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("\"somedatasource\"", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testTableDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"table\", \"name\":\"somedatasource\"}", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testQueryDataSource() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        String dataSourceJSON = "{\"type\":\"query\", \"query\":" + JSON_MAPPER.writeValueAsString((Object)query) + "}";
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue(dataSourceJSON, DataSource.class);
        Assert.assertEquals((Object)new QueryDataSource((Query)query), (Object)dataSource);
    }

    @Test
    public void testUnionDataSource() throws Exception {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"union\", \"dataSources\":[\"ds1\", \"ds2\"]}", DataSource.class);
        Assert.assertTrue((boolean)(dataSource instanceof UnionDataSource));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new TableDataSource[]{new TableDataSource("ds1"), new TableDataSource("ds2")}), (Object)Lists.newArrayList((Iterable)((UnionDataSource)dataSource).getDataSourcesAsTableDataSources()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"ds1", (Object)"ds2"), (Object)dataSource.getTableNames());
        DataSource serde = (DataSource)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)dataSource), DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serde);
    }
}

