/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class GlobalTableDataSourceTest {
    private static final GlobalTableDataSource GLOBAL_TABLE_DATA_SOURCE = new GlobalTableDataSource("foo");

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(GlobalTableDataSource.class).usingGetClass().withNonnullFields(new String[]{"name"}).verify();
    }

    @Test
    public void testGlobalTableIsNotEqualsTable() {
        TableDataSource tbl = new TableDataSource(GLOBAL_TABLE_DATA_SOURCE.getName());
        Assert.assertNotEquals((Object)GLOBAL_TABLE_DATA_SOURCE, (Object)tbl);
        Assert.assertNotEquals((Object)tbl, (Object)GLOBAL_TABLE_DATA_SOURCE);
    }

    @Test
    public void testIsGlobal() {
        Assert.assertTrue((boolean)GLOBAL_TABLE_DATA_SOURCE.isGlobal());
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        GlobalTableDataSource deserialized = (GlobalTableDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)GLOBAL_TABLE_DATA_SOURCE), DataSource.class);
        Assert.assertEquals((Object)GLOBAL_TABLE_DATA_SOURCE, (Object)deserialized);
    }
}

