/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.ResourceInputSource;
import org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedDataColumnSchema;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.timeline.SegmentId;
import org.junit.rules.TemporaryFolder;

public class NestedDataTestUtils {
    public static final String SIMPLE_DATA_FILE = "nested-simple-test-data.json";
    public static final String SIMPLE_DATA_TSV_FILE = "nested-simple-test-data.tsv";
    public static final String NUMERIC_DATA_FILE = "nested-numeric-test-data.json";
    public static final String TYPES_DATA_FILE = "nested-types-test-data.json";
    public static final String ARRAY_TYPES_DATA_FILE = "nested-array-test-data.json";
    public static final String ARRAY_TYPES_DATA_FILE_2 = "nested-array-test-data-2.json";
    public static final String ALL_TYPES_TEST_DATA_FILE = "nested-all-types-test-data.json";
    public static final String INCREMENTAL_SEGMENTS_NAME = "incremental";
    public static final String DEFAULT_SEGMENTS_NAME = "segments";
    public static final String FRONT_CODED_SEGMENTS_NAME = "segments-frontcoded";
    public static final String MIX_SEGMENTS_NAME = "mixed";
    public static final ObjectMapper JSON_MAPPER;
    public static final TimestampSpec TIMESTAMP_SPEC;
    public static final JsonInputFormat DEFAULT_JSON_INPUT_FORMAT;
    public static final DimensionsSpec AUTO_DISCOVERY;
    public static final DimensionsSpec TSV_SCHEMA;
    public static final DimensionsSpec TSV_V4_SCHEMA;
    public static final InputRowSchema AUTO_SCHEMA;
    public static DelimitedInputFormat SIMPLE_DATA_TSV_INPUT_FORMAT;
    public static final TransformSpec SIMPLE_DATA_TSV_TRANSFORM;
    public static final AggregatorFactory[] COUNT;

    public static List<Segment> createSimpleSegmentsTsv(TemporaryFolder tempFolder, Closer closer) throws Exception {
        return NestedDataTestUtils.createSimpleNestedTestDataTsvSegments(tempFolder, closer, Granularities.NONE, TSV_SCHEMA, true);
    }

    public static List<Segment> createSimpleSegmentsTsvV4(TemporaryFolder tempFolder, Closer closer) throws Exception {
        return NestedDataTestUtils.createSimpleNestedTestDataTsvSegments(tempFolder, closer, Granularities.NONE, TSV_V4_SCHEMA, true);
    }

    public static List<Segment> createSimpleNestedTestDataTsvSegments(TemporaryFolder tempFolder, Closer closer, Granularity granularity, DimensionsSpec dimensionsSpec, boolean rollup) throws Exception {
        return NestedDataTestUtils.createSegments(tempFolder, closer, SIMPLE_DATA_TSV_FILE, (InputFormat)SIMPLE_DATA_TSV_INPUT_FORMAT, TIMESTAMP_SPEC, dimensionsSpec, SIMPLE_DATA_TSV_TRANSFORM, COUNT, granularity, rollup, IndexSpec.DEFAULT);
    }

    public static Segment createSimpleNestedTestDataIncrementalIndex(TemporaryFolder tempFolder) throws Exception {
        return NestedDataTestUtils.createIncrementalIndexForJsonInput(tempFolder, SIMPLE_DATA_FILE, Granularities.NONE, true);
    }

    public static List<Segment> createSimpleNestedTestDataSegments(TemporaryFolder tempFolder, Closer closer) throws Exception {
        return NestedDataTestUtils.createSegmentsForJsonInput(tempFolder, closer, SIMPLE_DATA_FILE, Granularities.NONE, true, IndexSpec.DEFAULT);
    }

    public static Segment createIncrementalIndexForJsonInput(TemporaryFolder tempFolder, String fileName) throws Exception {
        return NestedDataTestUtils.createIncrementalIndexForJsonInput(tempFolder, fileName, Granularities.NONE, true);
    }

    public static Segment createIncrementalIndexForJsonInput(TemporaryFolder tempFolder, String file, Granularity granularity, boolean rollup) throws Exception {
        return NestedDataTestUtils.createIncrementalIndex(tempFolder, file, (InputFormat)DEFAULT_JSON_INPUT_FORMAT, TIMESTAMP_SPEC, AUTO_DISCOVERY, TransformSpec.NONE, COUNT, granularity, rollup);
    }

    public static List<Segment> createSegmentsForJsonInput(TemporaryFolder tempFolder, Closer closer, String inputFile, Granularity granularity, boolean rollup, IndexSpec indexSpec) throws Exception {
        return NestedDataTestUtils.createSegments(tempFolder, closer, inputFile, (InputFormat)DEFAULT_JSON_INPUT_FORMAT, TIMESTAMP_SPEC, AUTO_DISCOVERY, TransformSpec.NONE, COUNT, granularity, rollup, indexSpec);
    }

    public static List<Segment> createSegmentsWithConcatenatedJsonInput(TemporaryFolder tempFolder, Closer closer, String inputFile, Granularity granularity, boolean rollup, int numCopies, int numSegments) throws Exception {
        ArrayList inputFiles = Lists.newArrayListWithCapacity((int)numSegments);
        for (int i = 0; i < numSegments; ++i) {
            File file = NestedDataTestUtils.selfConcatenateResourceFile(tempFolder, inputFile, numCopies);
            inputFiles.add(new LocalInputSource(file.getParentFile(), file.getName()));
        }
        return NestedDataTestUtils.createSegments(tempFolder, closer, inputFiles, (InputFormat)DEFAULT_JSON_INPUT_FORMAT, TIMESTAMP_SPEC, AUTO_DISCOVERY, TransformSpec.NONE, COUNT, granularity, rollup, IndexSpec.DEFAULT);
    }

    public static List<Segment> createSegmentsForJsonInput(TemporaryFolder tempFolder, Closer closer, String inputFile, IndexSpec indexSpec) throws Exception {
        return NestedDataTestUtils.createSegmentsForJsonInput(tempFolder, closer, inputFile, Granularities.NONE, true, indexSpec);
    }

    public static Segment createIncrementalIndex(TemporaryFolder tempFolder, String inputFileName, InputFormat inputFormat, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, AggregatorFactory[] aggregators, Granularity queryGranularity, boolean rollup) throws Exception {
        IndexBuilder bob = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withTimestampSpec(timestampSpec).withDimensionsSpec(dimensionsSpec).withMetrics(aggregators).withQueryGranularity(queryGranularity).withRollup(rollup).withMinTimestamp(0L).build()).inputSource((InputSource)ResourceInputSource.of(NestedDataTestUtils.class.getClassLoader(), inputFileName)).inputFormat(inputFormat).transform(transformSpec).inputTmpDir(tempFolder.newFolder());
        return new IncrementalIndexSegment(bob.buildIncrementalIndex(), SegmentId.dummy((String)"test_datasource"));
    }

    public static List<Segment> createSegments(TemporaryFolder tempFolder, Closer closer, String input, InputFormat inputFormat, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, AggregatorFactory[] aggregators, Granularity queryGranularity, boolean rollup, IndexSpec indexSpec) throws Exception {
        return NestedDataTestUtils.createSegments(tempFolder, closer, Collections.singletonList(ResourceInputSource.of(NestedDataTestUtils.class.getClassLoader(), input)), inputFormat, timestampSpec, dimensionsSpec, transformSpec, aggregators, queryGranularity, rollup, indexSpec);
    }

    public static List<Segment> createSegments(TemporaryFolder tempFolder, Closer closer, List<InputSource> inputs, InputFormat inputFormat, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, AggregatorFactory[] aggregators, Granularity queryGranularity, boolean rollup, IndexSpec indexSpec) throws Exception {
        ArrayList segments = Lists.newArrayListWithCapacity((int)inputs.size());
        for (InputSource inputSource : inputs) {
            File segmentDir = tempFolder.newFolder();
            IndexBuilder bob = IndexBuilder.create().tmpDir(segmentDir).schema(IncrementalIndexSchema.builder().withTimestampSpec(timestampSpec).withDimensionsSpec(dimensionsSpec).withMetrics(aggregators).withQueryGranularity(queryGranularity).withRollup(rollup).withMinTimestamp(0L).build()).indexSpec(indexSpec).inputSource(inputSource).inputFormat(inputFormat).transform(transformSpec).inputTmpDir(tempFolder.newFolder());
            segments.add(new QueryableIndexSegment((QueryableIndex)closer.register((Closeable)bob.buildMMappedIndex()), SegmentId.dummy((String)"test_datasource")));
        }
        return segments;
    }

    public static File selfConcatenateResourceFile(TemporaryFolder tempFolder, String inputFileName, int numCopies) throws IOException {
        ArrayList inputStreams = Lists.newArrayListWithCapacity((int)numCopies);
        for (int i = 0; i < numCopies; ++i) {
            InputStream stream = NestedDataTestUtils.class.getClassLoader().getResourceAsStream(inputFileName);
            inputStreams.add(stream);
            if (i + 1 >= numCopies) continue;
            inputStreams.add(new ByteArrayInputStream(StringUtils.toUtf8((String)"\n")));
        }
        File tmpFile = tempFolder.newFile();
        try (SequenceInputStream inputDataStream = new SequenceInputStream(Collections.enumeration(inputStreams));
             OutputStream outStream = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8096];
            while ((bytesRead = inputDataStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        return tmpFile;
    }

    public static List<BiFunction<TemporaryFolder, Closer, List<Segment>>> getSegmentGenerators(final String jsonInputFile) {
        ArrayList<BiFunction<TemporaryFolder, Closer, List<Segment>>> segmentsGenerators = new ArrayList<BiFunction<TemporaryFolder, Closer, List<Segment>>>();
        segmentsGenerators.add(new BiFunction<TemporaryFolder, Closer, List<Segment>>(){

            @Override
            public List<Segment> apply(TemporaryFolder tempFolder, Closer closer) {
                try {
                    return ImmutableList.builder().addAll(NestedDataTestUtils.createSegmentsForJsonInput(tempFolder, closer, jsonInputFile, IndexSpec.DEFAULT)).add((Object)NestedDataTestUtils.createIncrementalIndexForJsonInput(tempFolder, jsonInputFile)).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return NestedDataTestUtils.MIX_SEGMENTS_NAME;
            }
        });
        segmentsGenerators.add(new BiFunction<TemporaryFolder, Closer, List<Segment>>(){

            @Override
            public List<Segment> apply(TemporaryFolder tempFolder, Closer closer) {
                try {
                    return ImmutableList.of((Object)NestedDataTestUtils.createIncrementalIndexForJsonInput(tempFolder, jsonInputFile), (Object)NestedDataTestUtils.createIncrementalIndexForJsonInput(tempFolder, jsonInputFile));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return NestedDataTestUtils.INCREMENTAL_SEGMENTS_NAME;
            }
        });
        segmentsGenerators.add(new BiFunction<TemporaryFolder, Closer, List<Segment>>(){

            @Override
            public List<Segment> apply(TemporaryFolder tempFolder, Closer closer) {
                try {
                    return ImmutableList.builder().addAll(NestedDataTestUtils.createSegmentsForJsonInput(tempFolder, closer, jsonInputFile, IndexSpec.DEFAULT)).addAll(NestedDataTestUtils.createSegmentsForJsonInput(tempFolder, closer, jsonInputFile, IndexSpec.DEFAULT)).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return NestedDataTestUtils.DEFAULT_SEGMENTS_NAME;
            }
        });
        segmentsGenerators.add(new BiFunction<TemporaryFolder, Closer, List<Segment>>(){

            @Override
            public List<Segment> apply(TemporaryFolder tempFolder, Closer closer) {
                try {
                    return ImmutableList.builder().addAll(NestedDataTestUtils.createSegmentsForJsonInput(tempFolder, closer, jsonInputFile, IndexSpec.builder().withStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1))).build())).addAll(NestedDataTestUtils.createSegmentsForJsonInput(tempFolder, closer, jsonInputFile, IndexSpec.builder().withStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)0))).build())).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return NestedDataTestUtils.FRONT_CODED_SEGMENTS_NAME;
            }
        });
        return segmentsGenerators;
    }

    public static boolean expectSegmentGeneratorCanVectorize(String name) {
        return DEFAULT_SEGMENTS_NAME.equals(name) || FRONT_CODED_SEGMENTS_NAME.equals(name);
    }

    static {
        TIMESTAMP_SPEC = new TimestampSpec("timestamp", null, null);
        DEFAULT_JSON_INPUT_FORMAT = new JsonInputFormat(JSONPathSpec.DEFAULT, null, null, null, null);
        AUTO_DISCOVERY = DimensionsSpec.builder().useSchemaDiscovery(true).build();
        TSV_SCHEMA = DimensionsSpec.builder().setDimensions(Arrays.asList(new AutoTypeColumnSchema("dim", null), new AutoTypeColumnSchema("nest_json", null), new AutoTypeColumnSchema("nester_json", null), new AutoTypeColumnSchema("variant_json", null), new AutoTypeColumnSchema("list_json", null), new AutoTypeColumnSchema("nonexistent", null))).build();
        TSV_V4_SCHEMA = DimensionsSpec.builder().setDimensions(Arrays.asList(new NestedDataColumnSchema("dim", 4), new NestedDataColumnSchema("nest_json", 4), new NestedDataColumnSchema("nester_json", 4), new NestedDataColumnSchema("variant_json", 4), new NestedDataColumnSchema("list_json", 4), new NestedDataColumnSchema("nonexistent", 4))).build();
        AUTO_SCHEMA = new InputRowSchema(TIMESTAMP_SPEC, AUTO_DISCOVERY, null);
        SIMPLE_DATA_TSV_INPUT_FORMAT = new DelimitedInputFormat(Arrays.asList("timestamp", "dim", "nest", "nester", "variant", "list"), null, null, Boolean.valueOf(false), Boolean.valueOf(false), 0);
        SIMPLE_DATA_TSV_TRANSFORM = new TransformSpec(null, Arrays.asList(new ExpressionTransform("nest_json", "parse_json(nest)", TestExprMacroTable.INSTANCE), new ExpressionTransform("nester_json", "parse_json(nester)", TestExprMacroTable.INSTANCE), new ExpressionTransform("variant_json", "parse_json(variant)", TestExprMacroTable.INSTANCE), new ExpressionTransform("list_json", "parse_json(list)", TestExprMacroTable.INSTANCE)));
        COUNT = new AggregatorFactory[]{new CountAggregatorFactory("count")};
        JSON_MAPPER = TestHelper.makeJsonMapper();
        JSON_MAPPER.registerModules((Iterable)BuiltInTypesModule.getJacksonModulesList());
    }
}

