/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.BadQueryContextException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class QueryContextTest {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Test
    public void testEquals() {
        EqualsVerifier.configure().suppress(new Warning[]{Warning.NONFINAL_FIELDS, Warning.ALL_FIELDS_SHOULD_BE_USED}).usingGetClass().forClass(QueryContext.class).withNonnullFields(new String[]{"context"}).verify();
    }

    @Test
    public void testEmptyContext() {
        QueryContext context = new QueryContext(null);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)context.asMap());
        context = new QueryContext(new HashMap());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)context.asMap());
        context = QueryContext.of(null);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)context.asMap());
        context = QueryContext.of(new HashMap());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)context.asMap());
        context = QueryContext.empty();
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)context.asMap());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)QueryContext.empty().isEmpty());
        Assert.assertFalse((boolean)QueryContext.of((Map)ImmutableMap.of((Object)"k", (Object)"v")).isEmpty());
    }

    @Test
    public void testGetString() {
        QueryContext context = QueryContext.of((Map)ImmutableMap.of((Object)"key", (Object)"val", (Object)"key2", (Object)2));
        Assert.assertEquals((Object)"val", (Object)context.get("key"));
        Assert.assertEquals((Object)"val", (Object)context.getString("key"));
        Assert.assertNull((Object)context.getString("non-exist"));
        Assert.assertEquals((Object)"foo", (Object)context.getString("non-exist", "foo"));
        Assert.assertThrows(BadQueryContextException.class, () -> context.getString("key2"));
    }

    @Test
    public void testGetBoolean() {
        QueryContext context = QueryContext.of((Map)ImmutableMap.of((Object)"key1", (Object)"true", (Object)"key2", (Object)true));
        Assert.assertTrue((boolean)context.getBoolean("key1", false));
        Assert.assertTrue((boolean)context.getBoolean("key2", false));
        Assert.assertTrue((boolean)context.getBoolean("key1"));
        Assert.assertFalse((boolean)context.getBoolean("non-exist", false));
        Assert.assertNull((Object)context.getBoolean("non-exist"));
    }

    @Test
    public void testGetInt() {
        QueryContext context = QueryContext.of((Map)ImmutableMap.of((Object)"key1", (Object)"100", (Object)"key2", (Object)100, (Object)"key3", (Object)"abc"));
        Assert.assertEquals((long)100L, (long)context.getInt("key1", 0));
        Assert.assertEquals((long)100L, (long)context.getInt("key2", 0));
        Assert.assertEquals((long)0L, (long)context.getInt("non-exist", 0));
        Assert.assertThrows(BadQueryContextException.class, () -> context.getInt("key3", 5));
    }

    @Test
    public void testGetLong() {
        QueryContext context = QueryContext.of((Map)ImmutableMap.of((Object)"key1", (Object)"100", (Object)"key2", (Object)100, (Object)"key3", (Object)"abc"));
        Assert.assertEquals((long)100L, (long)context.getLong("key1", 0L));
        Assert.assertEquals((long)100L, (long)context.getLong("key2", 0L));
        Assert.assertEquals((long)0L, (long)context.getLong("non-exist", 0L));
        Assert.assertThrows(BadQueryContextException.class, () -> context.getLong("key3", 5L));
    }

    @Test
    public void testGetLongCompatibility() throws JsonProcessingException {
        String value = null;
        Assert.assertNull((Object)QueryContextTest.getContextLong(value));
        Assert.assertThrows(NullPointerException.class, () -> QueryContextTest.getDimensionLong(value));
        Assert.assertThrows(IllegalArgumentException.class, () -> QueryContextTest.getJsonLong(value));
        value = "";
        Assert.assertThrows(BadQueryContextException.class, () -> QueryContextTest.getContextLong(value));
        Assert.assertNull((Object)QueryContextTest.getDimensionLong(value));
        Assert.assertThrows(MismatchedInputException.class, () -> QueryContextTest.getJsonLong(value));
        value = "0";
        Assert.assertEquals((long)0L, (long)QueryContextTest.getContextLong(value));
        Assert.assertEquals((long)0L, (long)QueryContextTest.getDimensionLong(value));
        Assert.assertEquals((long)0L, (long)QueryContextTest.getJsonLong(value));
        value = "+1";
        Assert.assertEquals((long)1L, (long)QueryContextTest.getContextLong(value));
        Assert.assertEquals((long)1L, (long)QueryContextTest.getDimensionLong(value));
        Assert.assertThrows(JsonParseException.class, () -> QueryContextTest.getJsonLong(value));
        value = "-1";
        Assert.assertEquals((long)-1L, (long)QueryContextTest.getContextLong(value));
        Assert.assertEquals((long)-1L, (long)QueryContextTest.getDimensionLong(value));
        Assert.assertEquals((long)-1L, (long)QueryContextTest.getJsonLong(value));
        value = "0xabcd";
        Assert.assertThrows(BadQueryContextException.class, () -> QueryContextTest.getContextLong(value));
        Assert.assertNull((Object)QueryContextTest.getDimensionLong(value));
        Assert.assertThrows(JsonParseException.class, () -> QueryContextTest.getJsonLong(value));
        value = "05";
        Assert.assertEquals((long)5L, (long)QueryContextTest.getContextLong(value));
        Assert.assertEquals((long)5L, (long)QueryContextTest.getDimensionLong(value));
        Assert.assertThrows(JsonParseException.class, () -> QueryContextTest.getJsonLong(value));
        value = "10.00";
        Assert.assertEquals((long)10L, (long)QueryContextTest.getContextLong(value));
        Assert.assertEquals((long)10L, (long)QueryContextTest.getDimensionLong(value));
        Assert.assertEquals((long)10L, (long)QueryContextTest.getJsonLong(value));
        value = "1_234";
        Assert.assertThrows(BadQueryContextException.class, () -> QueryContextTest.getContextLong(value));
        Assert.assertNull((Object)QueryContextTest.getDimensionLong(value));
        Assert.assertThrows(JsonParseException.class, () -> QueryContextTest.getJsonLong(value));
    }

    private static Long getContextLong(String value) {
        return QueryContexts.getAsLong((String)"dummy", (Object)value);
    }

    private static Long getJsonLong(String value) throws JsonProcessingException {
        return (Long)JSON_MAPPER.readValue(value, Long.class);
    }

    private static Long getDimensionLong(String value) {
        return DimensionHandlerUtils.getExactLongFromDecimalString((String)value);
    }

    @Test
    public void testGetFloat() {
        QueryContext context = QueryContext.of((Map)ImmutableMap.of((Object)"f1", (Object)"500", (Object)"f2", (Object)500, (Object)"f3", (Object)500.1, (Object)"f4", (Object)"ab"));
        Assert.assertEquals((long)0L, (long)Float.compare(500.0f, context.getFloat("f1", 100.0f)));
        Assert.assertEquals((long)0L, (long)Float.compare(500.0f, context.getFloat("f2", 100.0f)));
        Assert.assertEquals((long)0L, (long)Float.compare(500.1f, context.getFloat("f3", 100.0f)));
        Assert.assertThrows(BadQueryContextException.class, () -> context.getFloat("f4", 5.0f));
    }

    @Test
    public void testGetHumanReadableBytes() {
        QueryContext context = new QueryContext((Map)ImmutableMap.builder().put((Object)"m1", (Object)500000000).put((Object)"m2", (Object)"500M").put((Object)"m3", (Object)"500Mi").put((Object)"m4", (Object)"500MiB").put((Object)"m5", (Object)"500000000").put((Object)"m6", (Object)"abc").build());
        Assert.assertEquals((long)500000000L, (long)context.getHumanReadableBytes("m1", HumanReadableBytes.ZERO).getBytes());
        Assert.assertEquals((long)500000000L, (long)context.getHumanReadableBytes("m2", HumanReadableBytes.ZERO).getBytes());
        Assert.assertEquals((long)524288000L, (long)context.getHumanReadableBytes("m3", HumanReadableBytes.ZERO).getBytes());
        Assert.assertEquals((long)524288000L, (long)context.getHumanReadableBytes("m4", HumanReadableBytes.ZERO).getBytes());
        Assert.assertEquals((long)500000000L, (long)context.getHumanReadableBytes("m5", HumanReadableBytes.ZERO).getBytes());
        Assert.assertThrows(BadQueryContextException.class, () -> context.getHumanReadableBytes("m6", HumanReadableBytes.ZERO));
    }

    @Test
    public void testGetMaxSubqueryBytes() {
        QueryContext context1 = new QueryContext((Map)ImmutableMap.of((Object)"maxSubqueryBytes", (Object)500000000));
        Assert.assertEquals((Object)"500000000", (Object)context1.getMaxSubqueryMemoryBytes(null));
        QueryContext context2 = new QueryContext((Map)ImmutableMap.of((Object)"maxSubqueryBytes", (Object)"auto"));
        Assert.assertEquals((Object)"auto", (Object)context2.getMaxSubqueryMemoryBytes(null));
        QueryContext context3 = new QueryContext((Map)ImmutableMap.of());
        Assert.assertEquals((Object)"disabled", (Object)context3.getMaxSubqueryMemoryBytes("disabled"));
    }

    @Test
    public void testGetInFunctionThreshold() {
        QueryContext context1 = new QueryContext((Map)ImmutableMap.of((Object)"inFunctionThreshold", (Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)context1.getInFunctionThreshold());
        QueryContext context2 = QueryContext.empty();
        Assert.assertEquals((long)100L, (long)context2.getInFunctionThreshold());
    }

    @Test
    public void testGetInFunctionExprThreshold() {
        QueryContext context1 = new QueryContext((Map)ImmutableMap.of((Object)"inFunctionExprThreshold", (Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)context1.getInFunctionExprThreshold());
        QueryContext context2 = QueryContext.empty();
        Assert.assertEquals((long)2L, (long)context2.getInFunctionExprThreshold());
    }

    @Test
    public void testDefaultEnableQueryDebugging() {
        Assert.assertFalse((boolean)QueryContext.empty().isDebug());
        Assert.assertTrue((boolean)QueryContext.of((Map)ImmutableMap.of((Object)"debug", (Object)true)).isDebug());
    }

    @Test
    public void testLegacyReturnsLegacy() {
        ImmutableMap context = ImmutableMap.of((Object)"foo", (Object)"bar");
        LegacyContextQuery legacy = new LegacyContextQuery((Map<String, Object>)context);
        Assert.assertEquals((Object)context, (Object)legacy.getContext());
    }

    @Test
    public void testNonLegacyIsNotLegacyContext() {
        TimeseriesQuery timeseries = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2015-01-02/2015-01-03").granularity(Granularities.DAY).aggregators(Collections.singletonList(new CountAggregatorFactory("theCount"))).context((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build();
        Assert.assertNotNull((Object)timeseries.getContext());
    }

    public static class LegacyContextQuery
    implements Query<Integer> {
        private final Map<String, Object> context;

        public LegacyContextQuery(Map<String, Object> context) {
            this.context = context;
        }

        public DataSource getDataSource() {
            return new TableDataSource("fake");
        }

        public boolean hasFilters() {
            return false;
        }

        public DimFilter getFilter() {
            return null;
        }

        public String getType() {
            return "legacy-context-query";
        }

        public QueryRunner<Integer> getRunner(QuerySegmentWalker walker) {
            return new NoopQueryRunner();
        }

        public List<Interval> getIntervals() {
            return Collections.singletonList(Intervals.ETERNITY);
        }

        public Duration getDuration() {
            return this.getIntervals().get(0).toDuration();
        }

        public Granularity getGranularity() {
            return Granularities.ALL;
        }

        public DateTimeZone getTimezone() {
            return DateTimeZone.UTC;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public Ordering<Integer> getResultOrdering() {
            return Ordering.natural();
        }

        public Query<Integer> withQuerySegmentSpec(QuerySegmentSpec spec) {
            return new LegacyContextQuery(this.context);
        }

        public Query<Integer> withId(String id) {
            this.context.put("queryId", id);
            return this;
        }

        @Nullable
        public String getId() {
            return (String)this.context.get("queryId");
        }

        public Query<Integer> withSubQueryId(String subQueryId) {
            this.context.put("subQueryId", subQueryId);
            return this;
        }

        @Nullable
        public String getSubQueryId() {
            return (String)this.context.get("subQueryId");
        }

        public Query<Integer> withDataSource(DataSource dataSource) {
            return this;
        }

        public Query<Integer> withOverriddenContext(Map<String, Object> contextOverride) {
            return new LegacyContextQuery(contextOverride);
        }
    }
}

