/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringDeltaEncodedStagedSerde;
import org.apache.druid.segment.serde.cell.RandomStringUtils;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.serde.cell.StorableBuffer;
import org.junit.Assert;
import org.junit.Test;

public class BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest {
    private static final OlderSerializablePairLongStringDeltaEncodedStagedSerde OLDER_INTEGER_SERDE = new OlderSerializablePairLongStringDeltaEncodedStagedSerde(0L, true);
    private static final SerializablePairLongStringDeltaEncodedStagedSerde INTEGER_SERDE = new SerializablePairLongStringDeltaEncodedStagedSerde(0L, true);
    private static final OlderSerializablePairLongStringDeltaEncodedStagedSerde OLDER_LONG_SERDE = new OlderSerializablePairLongStringDeltaEncodedStagedSerde(0L, false);
    private static final SerializablePairLongStringDeltaEncodedStagedSerde LONG_SERDE = new SerializablePairLongStringDeltaEncodedStagedSerde(0L, false);
    private static final Long TIMESTAMP = 100L;
    private final RandomStringUtils randomStringUtils = new RandomStringUtils(new Random(0L));

    @Test
    public void testSimple() {
        SerializablePairLongString value = new SerializablePairLongString(TIMESTAMP, "fuu");
        this.testValue(value, OLDER_INTEGER_SERDE, (StagedSerde<SerializablePairLongString>)INTEGER_SERDE);
        this.testValue(value, OLDER_LONG_SERDE, (StagedSerde<SerializablePairLongString>)LONG_SERDE);
    }

    @Test
    public void testNull() {
        this.testValue(null, OLDER_INTEGER_SERDE, (StagedSerde<SerializablePairLongString>)INTEGER_SERDE);
        this.testValue(null, OLDER_LONG_SERDE, (StagedSerde<SerializablePairLongString>)LONG_SERDE);
    }

    @Test
    public void testNullString() {
        SerializablePairLongString value = new SerializablePairLongString(TIMESTAMP, null);
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_INTEGER_SERDE), (StagedSerde<SerializablePairLongString>)INTEGER_SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_LONG_SERDE), (StagedSerde<SerializablePairLongString>)LONG_SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)INTEGER_SERDE), OLDER_INTEGER_SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)LONG_SERDE), OLDER_LONG_SERDE));
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_INTEGER_SERDE).length, (long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)INTEGER_SERDE).length);
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_LONG_SERDE).length, (long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)LONG_SERDE).length);
    }

    @Test
    public void testEmptyString() {
        SerializablePairLongString value = new SerializablePairLongString(TIMESTAMP, "");
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_INTEGER_SERDE), (StagedSerde<SerializablePairLongString>)INTEGER_SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_LONG_SERDE), (StagedSerde<SerializablePairLongString>)LONG_SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)INTEGER_SERDE), OLDER_INTEGER_SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(TIMESTAMP, null), (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)LONG_SERDE), OLDER_LONG_SERDE));
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_INTEGER_SERDE).length, (long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)INTEGER_SERDE).length);
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, OLDER_LONG_SERDE).length, (long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)LONG_SERDE).length);
    }

    @Test
    public void testLargeString() {
        SerializablePairLongString value = new SerializablePairLongString(TIMESTAMP, this.randomStringUtils.randomAlphanumeric(0x100000));
        this.testValue(value, OLDER_INTEGER_SERDE, (StagedSerde<SerializablePairLongString>)INTEGER_SERDE);
        this.testValue(value, OLDER_LONG_SERDE, (StagedSerde<SerializablePairLongString>)LONG_SERDE);
    }

    private void testValue(@Nullable SerializablePairLongString value, StagedSerde<SerializablePairLongString> olderSerde, StagedSerde<SerializablePairLongString> serde) {
        Assert.assertEquals((Object)value, (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, olderSerde), serde));
        Assert.assertEquals((Object)value, (Object)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, serde), olderSerde));
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, olderSerde).length, (long)BackwardCompatibleSerializablePairLongStringDeltaEncodedStagedSerdeTest.writeUsingSerde(value, serde).length);
    }

    private static byte[] writeUsingSerde(@Nullable SerializablePairLongString value, StagedSerde<SerializablePairLongString> serde) {
        return serde.serialize((Object)value);
    }

    private static SerializablePairLongString readUsingSerde(byte[] bytes, StagedSerde<SerializablePairLongString> serde) {
        return (SerializablePairLongString)serde.deserialize(bytes);
    }

    private static class OlderSerializablePairLongStringDeltaEncodedStagedSerde
    implements StagedSerde<SerializablePairLongString> {
        private final long minValue;
        private final boolean useIntegerDelta;

        public OlderSerializablePairLongStringDeltaEncodedStagedSerde(long minValue, boolean useIntegerDelta) {
            this.minValue = minValue;
            this.useIntegerDelta = useIntegerDelta;
        }

        public StorableBuffer serializeDelayed(final @Nullable SerializablePairLongString value) {
            if (value == null) {
                return StorableBuffer.EMPTY;
            }
            String rhsString = (String)value.rhs;
            final byte[] rhsBytes = StringUtils.toUtf8WithNullToEmpty((String)rhsString);
            return new StorableBuffer(){

                public void store(ByteBuffer byteBuffer) {
                    Preconditions.checkNotNull((Object)value.lhs, (Object)"Long in SerializablePairLongString must be non-null");
                    long delta = (Long)value.lhs - minValue;
                    Preconditions.checkState((delta >= 0L || delta == (Long)value.lhs ? 1 : 0) != 0);
                    if (useIntegerDelta) {
                        byteBuffer.putInt(Ints.checkedCast((long)delta));
                    } else {
                        byteBuffer.putLong(delta);
                    }
                    byteBuffer.putInt(rhsBytes.length);
                    if (rhsBytes.length > 0) {
                        byteBuffer.put(rhsBytes);
                    }
                }

                public int getSerializedSize() {
                    return (useIntegerDelta ? 4 : 8) + 4 + rhsBytes.length;
                }
            };
        }

        @Nullable
        public SerializablePairLongString deserialize(ByteBuffer byteBuffer) {
            if (byteBuffer.remaining() == 0) {
                return null;
            }
            ByteBuffer readOnlyBuffer = byteBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            long lhs = this.useIntegerDelta ? (long)readOnlyBuffer.getInt() : readOnlyBuffer.getLong();
            lhs += this.minValue;
            int stringSize = readOnlyBuffer.getInt();
            String lastString = null;
            if (stringSize > 0) {
                byte[] stringBytes = new byte[stringSize];
                readOnlyBuffer.get(stringBytes, 0, stringSize);
                lastString = StringUtils.fromUtf8((byte[])stringBytes);
            }
            return new SerializablePairLongString(Long.valueOf(lhs), lastString);
        }
    }
}

