/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringSimpleStagedSerde;
import org.apache.druid.segment.serde.cell.RandomStringUtils;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.serde.cell.StorableBuffer;
import org.junit.Assert;
import org.junit.Test;

public class BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest {
    private static final OlderSerializablePairLongStringSimpleStagedSerde OLDER_SERDE = new OlderSerializablePairLongStringSimpleStagedSerde();
    private static final SerializablePairLongStringSimpleStagedSerde SERDE = new SerializablePairLongStringSimpleStagedSerde();
    private final RandomStringUtils randomStringUtils = new RandomStringUtils(new Random(0L));

    @Test
    public void testSimple() {
        this.testValue(new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), "fuu"));
    }

    @Test
    public void testNull() {
        this.testValue(null);
    }

    @Test
    public void testNullString() {
        SerializablePairLongString value = new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), null);
        Assert.assertEquals((Object)new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), null), (Object)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, OLDER_SERDE), (StagedSerde<SerializablePairLongString>)SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), null), (Object)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)SERDE), OLDER_SERDE));
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, OLDER_SERDE).length, (long)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)SERDE).length);
    }

    @Test
    public void testEmptyString() {
        SerializablePairLongString value = new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), "");
        Assert.assertEquals((Object)new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), null), (Object)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, OLDER_SERDE), (StagedSerde<SerializablePairLongString>)SERDE));
        Assert.assertEquals((Object)new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), null), (Object)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)SERDE), OLDER_SERDE));
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, OLDER_SERDE).length, (long)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)SERDE).length);
    }

    @Test
    public void testLargeString() {
        this.testValue(new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), this.randomStringUtils.randomAlphanumeric(0x100000)));
    }

    private void testValue(@Nullable SerializablePairLongString value) {
        Assert.assertEquals((Object)value, (Object)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, OLDER_SERDE), (StagedSerde<SerializablePairLongString>)SERDE));
        Assert.assertEquals((Object)value, (Object)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.readUsingSerde(BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)SERDE), OLDER_SERDE));
        Assert.assertEquals((long)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, OLDER_SERDE).length, (long)BackwardCompatibleSerializablePairLongStringSimpleStagedSerdeTest.writeUsingSerde(value, (StagedSerde<SerializablePairLongString>)SERDE).length);
    }

    private static byte[] writeUsingSerde(@Nullable SerializablePairLongString value, StagedSerde<SerializablePairLongString> serde) {
        return serde.serialize((Object)value);
    }

    private static SerializablePairLongString readUsingSerde(byte[] bytes, StagedSerde<SerializablePairLongString> serde) {
        return (SerializablePairLongString)serde.deserialize(bytes);
    }

    private static class OlderSerializablePairLongStringSimpleStagedSerde
    implements StagedSerde<SerializablePairLongString> {
        private OlderSerializablePairLongStringSimpleStagedSerde() {
        }

        public StorableBuffer serializeDelayed(final @Nullable SerializablePairLongString value) {
            if (value == null) {
                return StorableBuffer.EMPTY;
            }
            String rhsString = (String)value.rhs;
            final byte[] rhsBytes = StringUtils.toUtf8WithNullToEmpty((String)rhsString);
            return new StorableBuffer(){

                public void store(ByteBuffer byteBuffer) {
                    Preconditions.checkNotNull((Object)value.lhs, (Object)"Long in SerializablePairLongString must be non-null");
                    byteBuffer.putLong((Long)value.lhs);
                    byteBuffer.putInt(rhsBytes.length);
                    if (rhsBytes.length > 0) {
                        byteBuffer.put(rhsBytes);
                    }
                }

                public int getSerializedSize() {
                    return 12 + rhsBytes.length;
                }
            };
        }

        @Nullable
        public SerializablePairLongString deserialize(ByteBuffer byteBuffer) {
            if (byteBuffer.remaining() == 0) {
                return null;
            }
            ByteBuffer readOnlyBuffer = byteBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            long lhs = readOnlyBuffer.getLong();
            int stringSize = readOnlyBuffer.getInt();
            String lastString = null;
            if (stringSize > 0) {
                byte[] stringBytes = new byte[stringSize];
                readOnlyBuffer.get(stringBytes, 0, stringSize);
                lastString = StringUtils.fromUtf8((byte[])stringBytes);
            }
            return new SerializablePairLongString(Long.valueOf(lhs), lastString);
        }
    }
}

