/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.SerializablePairLongDoubleComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongDoubleComplexMetricSerde;
import org.apache.druid.query.aggregation.SingleObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongDoubleComplexMetricSerdeTest {
    private static final SerializablePairLongDoubleComplexMetricSerde COMPRESSED_SERDE;
    private final Random random = new Random(0L);

    @Test
    public void testSingle() throws Exception {
        this.assertExpected((List<SerializablePairLongDouble>)ImmutableList.of((Object)new SerializablePairLongDouble(Long.valueOf(100L), Double.valueOf(10.0))), 75);
    }

    @Test
    public void testLargeRHS() throws Exception {
        this.assertExpected((List<SerializablePairLongDouble>)ImmutableList.of((Object)new SerializablePairLongDouble(Long.valueOf(100L), Double.valueOf(this.random.nextDouble()))), 78);
    }

    @Test
    public void testCompressable() throws Exception {
        int i;
        int numLongs = 10;
        ArrayList<SerializablePairLongDouble> valueList = new ArrayList<SerializablePairLongDouble>();
        ArrayList<Double> doubleList = new ArrayList<Double>();
        for (i = 0; i < numLongs; ++i) {
            doubleList.add(this.random.nextDouble());
        }
        for (i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongDouble(Long.valueOf(Integer.MAX_VALUE + (long)i), (Double)doubleList.get(i % numLongs)));
        }
        this.assertExpected(valueList, 80509);
    }

    @Test
    public void testHighlyCompressable() throws Exception {
        ArrayList<SerializablePairLongDouble> valueList = new ArrayList<SerializablePairLongDouble>();
        Double doubleValue = this.random.nextDouble();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongDouble(Long.valueOf(Integer.MAX_VALUE + (long)i), doubleValue));
        }
        this.assertExpected(valueList, 80274);
    }

    @Test
    public void testRandom() throws Exception {
        ArrayList<SerializablePairLongDouble> valueList = new ArrayList<SerializablePairLongDouble>();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongDouble(Long.valueOf(this.random.nextLong()), Double.valueOf(this.random.nextDouble())));
        }
        this.assertExpected(valueList, 210958);
    }

    @Test
    public void testNullRHS() throws Exception {
        this.assertExpected((List<SerializablePairLongDouble>)ImmutableList.of((Object)new SerializablePairLongDouble(Long.valueOf(100L), null)), 71);
    }

    @Test
    public void testEmpty() throws Exception {
        this.assertExpected(Collections.emptyList(), 57);
    }

    @Test
    public void testSingleNull() throws Exception {
        this.assertExpected(Arrays.asList(new SerializablePairLongDouble[]{null}), 58);
    }

    @Test
    public void testMultipleNull() throws Exception {
        this.assertExpected(Arrays.asList(null, null, null, null), 59);
    }

    private ByteBuffer assertExpected(List<SerializablePairLongDouble> expected, int expectedCompressedSize) throws IOException {
        OnHeapMemorySegmentWriteOutMedium writeOutMedium = new OnHeapMemorySegmentWriteOutMedium();
        ByteBuffer compressedBuffer = SerializablePairLongDoubleComplexMetricSerdeTest.serializeAllValuesToByteBuffer(expected, COMPRESSED_SERDE.getSerializer((SegmentWriteOutMedium)writeOutMedium, "not-used", IndexSpec.DEFAULT), expectedCompressedSize).asReadOnlyBuffer();
        try (ComplexColumn compressedCol = this.createComplexColumn(compressedBuffer);){
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals((Object)expected.get(i), (Object)compressedCol.getRowValue(i));
            }
        }
        return compressedBuffer;
    }

    private ComplexColumn createComplexColumn(ByteBuffer byteBuffer) {
        ColumnBuilder builder = new ColumnBuilder();
        int serializedSize = byteBuffer.remaining();
        COMPRESSED_SERDE.deserializeColumn(byteBuffer, builder);
        builder.setType(ValueType.COMPLEX);
        ColumnHolder columnHolder = builder.build();
        ComplexColumn col = (ComplexColumn)columnHolder.getColumn();
        if (col instanceof SerializablePairLongDoubleComplexColumn) {
            Assert.assertEquals((long)serializedSize, (long)col.getLength());
        }
        Assert.assertEquals((Object)"serializablePairLongDouble", (Object)col.getTypeName());
        Assert.assertEquals(SerializablePairLongDouble.class, (Object)col.getClazz());
        return col;
    }

    private static ByteBuffer serializeAllValuesToByteBuffer(List<SerializablePairLongDouble> values, GenericColumnSerializer serializer, int expectedSize) throws IOException {
        serializer.open();
        final AtomicReference<Object> reference = new AtomicReference<Object>(null);
        SingleObjectColumnValueSelector<SerializablePairLongDouble> valueSelector = new SingleObjectColumnValueSelector<SerializablePairLongDouble>(SerializablePairLongDouble.class){

            @Nullable
            public SerializablePairLongDouble getObject() {
                return (SerializablePairLongDouble)reference.get();
            }
        };
        for (SerializablePairLongDouble selector : values) {
            reference.set(selector);
            serializer.serialize((ColumnValueSelector)valueSelector);
        }
        return SerializablePairLongDoubleComplexMetricSerdeTest.serializeToByteBuffer((GenericColumnSerializer<SerializablePairLongDouble>)serializer, expectedSize);
    }

    private static ByteBuffer serializeToByteBuffer(GenericColumnSerializer<SerializablePairLongDouble> serializer, int expectedSize) throws IOException {
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        serializer.writeTo((WritableByteChannel)channel, null);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)channel.size()).order(ByteOrder.nativeOrder());
        channel.readFully(0L, byteBuffer);
        byteBuffer.flip();
        if (expectedSize > -1) {
            Assert.assertEquals((long)expectedSize, (long)serializer.getSerializedSize());
        }
        Assert.assertEquals((long)serializer.getSerializedSize(), (long)byteBuffer.limit());
        return byteBuffer;
    }

    static {
        NullHandling.initializeForTests();
        COMPRESSED_SERDE = new SerializablePairLongDoubleComplexMetricSerde();
    }
}

