/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SingleValueAggregatorFactory;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.TestFloatColumnSelector;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.TestColumnSelectorFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleValueAggregationTest
extends InitializedNullHandlingTest {
    private SingleValueAggregatorFactory longAggFactory;
    private ColumnSelectorFactory colSelectorFactoryLong;
    private ColumnCapabilities columnCapabilitiesLong;
    private TestLongColumnSelector selectorLong;
    private SingleValueAggregatorFactory doubleAggFactory;
    private ColumnSelectorFactory colSelectorFactoryDouble;
    private ColumnCapabilities columnCapabilitiesDouble;
    private TestDoubleColumnSelectorImpl selectorDouble;
    private SingleValueAggregatorFactory floatAggFactory;
    private ColumnSelectorFactory colSelectorFactoryFloat;
    private ColumnCapabilities columnCapabilitiesFloat;
    private TestFloatColumnSelector selectorFloat;
    private SingleValueAggregatorFactory stringAggFactory;
    private ColumnSelectorFactory colSelectorFactoryString;
    private ColumnCapabilities columnCapabilitiesString;
    private TestObjectColumnSelector selectorString;
    private final long[] longValues = new long[]{0x7FFFFFFFFFFFFFFAL, 0x7FFFFFFFFFFFFFFBL};
    private final double[] doubleValues = new double[]{5.2, 2.8976552};
    private final float[] floatValues = new float[]{5.2f, 2.89f};
    private final String[] strValues = new String[]{"str1", "str2"};

    public SingleValueAggregationTest() throws Exception {
        String longAggSpecJson = "{\"type\": \"singleValue\", \"name\": \"lng\", \"fieldName\": \"lngFld\", \"columnType\": \"LONG\"}";
        this.longAggFactory = (SingleValueAggregatorFactory)TestHelper.makeJsonMapper().readValue(longAggSpecJson, SingleValueAggregatorFactory.class);
        String doubleAggSpecJson = "{\"type\": \"singleValue\", \"name\": \"dbl\", \"fieldName\": \"dblFld\", \"columnType\": \"DOUBLE\"}";
        this.doubleAggFactory = (SingleValueAggregatorFactory)TestHelper.makeJsonMapper().readValue(doubleAggSpecJson, SingleValueAggregatorFactory.class);
        String floatAggSpecJson = "{\"type\": \"singleValue\", \"name\": \"dbl\", \"fieldName\": \"fltFld\", \"columnType\": \"FLOAT\"}";
        this.floatAggFactory = (SingleValueAggregatorFactory)TestHelper.makeJsonMapper().readValue(floatAggSpecJson, SingleValueAggregatorFactory.class);
        String strAggSpecJson = "{\"type\": \"singleValue\", \"name\": \"str\", \"fieldName\": \"strFld\", \"columnType\": \"STRING\"}";
        this.stringAggFactory = (SingleValueAggregatorFactory)TestHelper.makeJsonMapper().readValue(strAggSpecJson, SingleValueAggregatorFactory.class);
    }

    @Before
    public void setup() {
        this.selectorLong = new TestLongColumnSelector(this.longValues);
        this.columnCapabilitiesLong = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
        this.colSelectorFactoryLong = new TestColumnSelectorFactory().addCapabilities("lngFld", this.columnCapabilitiesLong).addColumnSelector("lngFld", this.selectorLong);
        this.selectorDouble = new TestDoubleColumnSelectorImpl(this.doubleValues);
        this.columnCapabilitiesDouble = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
        this.colSelectorFactoryDouble = new TestColumnSelectorFactory().addCapabilities("dblFld", this.columnCapabilitiesDouble).addColumnSelector("dblFld", this.selectorDouble);
        this.selectorFloat = new TestFloatColumnSelector(this.floatValues);
        this.columnCapabilitiesFloat = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT);
        this.colSelectorFactoryFloat = new TestColumnSelectorFactory().addCapabilities("fltFld", this.columnCapabilitiesFloat).addColumnSelector("fltFld", this.selectorFloat);
        this.selectorString = new TestObjectColumnSelector<String>(this.strValues);
        this.columnCapabilitiesString = ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities();
        this.colSelectorFactoryString = new TestColumnSelectorFactory().addCapabilities("strFld", this.columnCapabilitiesString).addColumnSelector("strFld", this.selectorString);
    }

    @Test
    public void testLongAggregator() {
        Assert.assertEquals((Object)ColumnType.LONG, (Object)this.longAggFactory.getIntermediateType());
        Assert.assertEquals((Object)ColumnType.LONG, (Object)this.longAggFactory.getResultType());
        Assert.assertEquals((Object)"lng", (Object)this.longAggFactory.getName());
        Assert.assertEquals((Object)"lngFld", (Object)this.longAggFactory.getFieldName());
        Assert.assertThrows(DruidException.class, () -> this.longAggFactory.getComparator());
        Aggregator agg = this.longAggFactory.factorize(this.colSelectorFactoryLong);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertFalse((boolean)agg.isNull());
            Assert.assertEquals((long)0L, (long)agg.getLong());
        } else {
            Assert.assertTrue((boolean)agg.isNull());
            Assert.assertThrows(AssertionError.class, () -> agg.getLong());
        }
        this.aggregate(this.selectorLong, agg);
        Assert.assertEquals((long)this.longValues[0], (long)((Long)agg.get()));
        Assert.assertEquals((long)this.longValues[0], (long)agg.getLong());
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorLong, agg));
    }

    @Test
    public void testLongBufferAggregator() {
        BufferAggregator agg = this.longAggFactory.factorizeBuffered(this.colSelectorFactoryLong);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[9]);
        agg.init(buffer, 0);
        Assert.assertEquals((long)0L, (long)agg.getLong(buffer, 0));
        this.aggregate(this.selectorLong, agg, buffer, 0);
        Assert.assertEquals((long)this.longValues[0], (long)((Long)agg.get(buffer, 0)));
        Assert.assertEquals((long)this.longValues[0], (long)agg.getLong(buffer, 0));
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorLong, agg, buffer, 0));
    }

    @Test
    public void testCombine() {
        Assert.assertThrows(DruidException.class, () -> this.longAggFactory.combine((Object)0x7FFFFFFFFFFFFFF8L, (Object)0x7FFFFFFFFFFFFFFBL));
    }

    @Test
    public void testDoubleAggregator() {
        Aggregator agg = this.doubleAggFactory.factorize(this.colSelectorFactoryDouble);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((double)0.0, (double)agg.getDouble(), (double)1.0E-6);
        } else {
            Assert.assertThrows(AssertionError.class, () -> agg.getDouble());
        }
        this.aggregate(this.selectorDouble, agg);
        Assert.assertEquals((double)this.doubleValues[0], (double)((Double)agg.get()), (double)1.0E-6);
        Assert.assertEquals((double)this.doubleValues[0], (double)agg.getDouble(), (double)1.0E-6);
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorDouble, agg));
    }

    @Test
    public void testDoubleBufferAggregator() {
        BufferAggregator agg = this.doubleAggFactory.factorizeBuffered(this.colSelectorFactoryDouble);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[1025]);
        agg.init(buffer, 0);
        Assert.assertEquals((double)0.0, (double)agg.getDouble(buffer, 0), (double)1.0E-6);
        this.aggregate(this.selectorDouble, agg, buffer, 0);
        Assert.assertEquals((double)this.doubleValues[0], (double)((Double)agg.get(buffer, 0)), (double)1.0E-6);
        Assert.assertEquals((double)this.doubleValues[0], (double)agg.getDouble(buffer, 0), (double)1.0E-6);
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorDouble, agg, buffer, 0));
    }

    @Test
    public void testFloatAggregator() {
        Aggregator agg = this.floatAggFactory.factorize(this.colSelectorFactoryFloat);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((double)0.0, (double)agg.getFloat(), (double)1.0E-6);
        } else {
            Assert.assertThrows(AssertionError.class, () -> agg.getFloat());
        }
        this.aggregate(this.selectorFloat, agg);
        Assert.assertEquals((double)this.floatValues[0], (double)((Float)agg.get()).floatValue(), (double)1.0E-6);
        Assert.assertEquals((double)this.floatValues[0], (double)agg.getFloat(), (double)1.0E-6);
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorFloat, agg));
    }

    @Test
    public void testFloatBufferAggregator() {
        BufferAggregator agg = this.floatAggFactory.factorizeBuffered(this.colSelectorFactoryFloat);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[9]);
        agg.init(buffer, 0);
        Assert.assertEquals((double)0.0, (double)agg.getFloat(buffer, 0), (double)1.0E-6);
        this.aggregate(this.selectorFloat, agg, buffer, 0);
        Assert.assertEquals((double)this.floatValues[0], (double)((Float)agg.get(buffer, 0)).floatValue(), (double)1.0E-6);
        Assert.assertEquals((double)this.floatValues[0], (double)agg.getFloat(buffer, 0), (double)1.0E-6);
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorFloat, agg, buffer, 0));
    }

    @Test
    public void testStringAggregator() {
        Aggregator agg = this.stringAggFactory.factorize(this.colSelectorFactoryString);
        Assert.assertEquals(null, (Object)agg.get());
        this.aggregate(this.selectorString, agg);
        Assert.assertEquals((Object)this.strValues[0], (Object)agg.get());
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorString, agg));
    }

    @Test
    public void testStringBufferAggregator() {
        BufferAggregator agg = this.stringAggFactory.factorizeBuffered(this.colSelectorFactoryString);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[1025]);
        agg.init(buffer, 0);
        this.aggregate(this.selectorString, agg, buffer, 0);
        Assert.assertEquals((Object)this.strValues[0], (Object)agg.get(buffer, 0));
        Assert.assertThrows(DruidException.class, () -> this.aggregate(this.selectorString, agg, buffer, 0));
    }

    @Test
    public void testEqualsAndHashCode() {
        SingleValueAggregatorFactory one = new SingleValueAggregatorFactory("name1", "fieldName1", ColumnType.LONG);
        SingleValueAggregatorFactory oneMore = new SingleValueAggregatorFactory("name1", "fieldName1", ColumnType.LONG);
        SingleValueAggregatorFactory two = new SingleValueAggregatorFactory("name2", "fieldName2", ColumnType.LONG);
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    private void aggregate(TestLongColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestLongColumnSelector selector, BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }

    private void aggregate(TestFloatColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestFloatColumnSelector selector, BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }

    private void aggregate(TestDoubleColumnSelectorImpl selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestDoubleColumnSelectorImpl selector, BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }

    private void aggregate(TestObjectColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestObjectColumnSelector selector, BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

