/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.query.aggregation.any.LongAnyVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LongAnyVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final int NULL_POSITION = 32;
    private static final int POSITION = 2;
    private static final long[] VALUES = new long[]{7L, 11L, -892587293L, 60L, 123L};
    private ByteBuffer buf;
    @Mock
    private VectorValueSelector selector;
    private LongAnyVectorAggregator target;

    @Before
    public void setUp() {
        byte[] randomBytes = new byte[128];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        ((VectorValueSelector)Mockito.doReturn((Object)VALUES).when((Object)this.selector)).getLongVector();
        this.target = (LongAnyVectorAggregator)Mockito.spy((Object)new LongAnyVectorAggregator(this.selector));
        Mockito.when((Object)this.target.isValueNull(this.buf, 32)).thenReturn((Object)true);
        Mockito.when((Object)this.target.isValueNull(this.buf, 2)).thenReturn((Object)false);
    }

    @Test
    public void initValueShouldInitZero() {
        this.target.initValue(this.buf, 2);
        Assert.assertEquals((long)0L, (long)this.buf.getLong(2));
    }

    @Test
    public void getAtPositionIsNullShouldReturnNull() {
        Assert.assertNull((Object)this.target.get(this.buf, 32));
    }

    @Test
    public void getAtPositionShouldReturnValue() {
        this.buf.putLong(3, VALUES[3]);
        Assert.assertEquals((long)VALUES[3], (long)((Long)this.target.get(this.buf, 2)));
    }

    @Test
    public void putValueShouldAddToBuffer() {
        Assert.assertTrue((boolean)this.target.putAnyValueFromRow(this.buf, 2, 2, 3));
        Assert.assertEquals((long)VALUES[2], (long)this.buf.getLong(2));
    }

    @Test
    public void putValueStartAfterEndShouldNotAddToBuffer() {
        Assert.assertFalse((boolean)this.target.putAnyValueFromRow(this.buf, 2, 2, 2));
        Assert.assertNotEquals((long)VALUES[2], (long)this.buf.getLong(2));
    }

    @Test
    public void putValueStartOutsideRangeShouldNotAddToBuffer() {
        Assert.assertFalse((boolean)this.target.putAnyValueFromRow(this.buf, 2, 5, 6));
        Assert.assertNotEquals((long)VALUES[2], (long)this.buf.getLong(2));
    }
}

