/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.constant;

import java.nio.ByteBuffer;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.druid.query.aggregation.constant.LongConstantVectorAggregator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongConstantVectorAggregatorTest {
    private long randomVal;
    private LongConstantVectorAggregator aggregator;
    private ByteBuffer byteBuffer;

    @Before
    public void setup() {
        this.randomVal = RandomUtils.nextLong();
        this.aggregator = new LongConstantVectorAggregator(this.randomVal);
        this.byteBuffer = null;
    }

    @Test
    public void testAggregate() {
        this.aggregator.aggregate(this.byteBuffer, 0, 1, 10);
        Assert.assertEquals((Object)this.randomVal, (Object)this.aggregator.get(this.byteBuffer, 0));
    }

    @Test
    public void testAggregateWithIndirection() {
        this.aggregator.aggregate(this.byteBuffer, 2, new int[]{2, 3}, null, 0);
        Assert.assertEquals((Object)this.randomVal, (Object)this.aggregator.get(this.byteBuffer, 0));
    }

    @Test
    public void testGet() {
        Assert.assertEquals((Object)this.randomVal, (Object)this.aggregator.get(this.byteBuffer, 0));
    }
}

