/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.first;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.firstlast.StringFirstLastUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringFirstLastUtilsTest {
    private static final SerializablePairLongString PAIR_TO_WRITE = new SerializablePairLongString(Long.valueOf(DateTimes.MAX.getMillis()), "asdasddsaasd");
    private static final int BUFFER_CAPACITY = 100;
    private static final int MAX_BYTE_TO_WRITE = 15;

    @Test
    public void testWritePairThenReadPairAtBeginningBuffer() {
        int positionAtBeginning = 0;
        ByteBuffer buf = ByteBuffer.allocate(100);
        StringFirstLastUtils.writePair((ByteBuffer)buf, (int)positionAtBeginning, (SerializablePairLongString)PAIR_TO_WRITE, (int)15);
        SerializablePairLongString actual = StringFirstLastUtils.readPair((ByteBuffer)buf, (int)positionAtBeginning);
        Assert.assertEquals((Object)PAIR_TO_WRITE, (Object)actual);
    }

    @Test
    public void testWritePairThenReadPairAtMiddleBuffer() {
        int positionAtMiddle = 60;
        ByteBuffer buf = ByteBuffer.allocate(100);
        StringFirstLastUtils.writePair((ByteBuffer)buf, (int)positionAtMiddle, (SerializablePairLongString)PAIR_TO_WRITE, (int)15);
        SerializablePairLongString actual = StringFirstLastUtils.readPair((ByteBuffer)buf, (int)positionAtMiddle);
        Assert.assertEquals((Object)PAIR_TO_WRITE, (Object)actual);
    }
}

