/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.last;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringComplexMetricSerde;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.query.timeseries.DefaultTimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IncrementalIndexTimeBoundaryInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexTimeBoundaryInspector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.Test;

public class StringLastTimeseriesQueryTest
extends InitializedNullHandlingTest {
    private static final String VISITOR_ID = "visitor_id";
    private static final String CLIENT_TYPE = "client_type";
    private static final String LAST_CLIENT_TYPE = "last_client_type";
    private static final String MULTI_VALUE = "mv";
    private static final DateTime TIME1 = DateTimes.of((String)"2016-03-04T00:00:00.000Z");
    private static final DateTime TIME2 = DateTimes.of((String)"2016-03-04T01:00:00.000Z");
    private IncrementalIndex incrementalIndex;
    private QueryableIndex queryableIndex;

    @Before
    public void setUp() throws IndexSizeExceededException {
        SerializablePairLongStringComplexMetricSerde serde = new SerializablePairLongStringComplexMetricSerde();
        ComplexMetrics.registerSerde((String)serde.getTypeName(), (ComplexMetricSerde)serde);
        this.incrementalIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.SECOND).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withMetrics(new AggregatorFactory[]{new StringLastAggregatorFactory(LAST_CLIENT_TYPE, CLIENT_TYPE, null, Integer.valueOf(1024))}).build()).setMaxRowCount(1000).build();
        this.incrementalIndex.add((InputRow)new MapBasedInputRow(TIME1, (List)Lists.newArrayList((Object[])new String[]{VISITOR_ID, CLIENT_TYPE, MULTI_VALUE}), (Map)ImmutableMap.of((Object)VISITOR_ID, (Object)"0", (Object)CLIENT_TYPE, (Object)"iphone", (Object)MULTI_VALUE, (Object)ImmutableList.of((Object)"a", (Object)"b"))));
        this.incrementalIndex.add((InputRow)new MapBasedInputRow(TIME1, (List)Lists.newArrayList((Object[])new String[]{VISITOR_ID, CLIENT_TYPE, MULTI_VALUE}), (Map)ImmutableMap.of((Object)VISITOR_ID, (Object)"1", (Object)CLIENT_TYPE, (Object)"iphone", (Object)MULTI_VALUE, (Object)ImmutableList.of((Object)"c", (Object)"d"))));
        this.incrementalIndex.add((InputRow)new MapBasedInputRow(TIME2, (List)Lists.newArrayList((Object[])new String[]{VISITOR_ID, CLIENT_TYPE, MULTI_VALUE}), (Map)ImmutableMap.of((Object)VISITOR_ID, (Object)"0", (Object)CLIENT_TYPE, (Object)"android", (Object)MULTI_VALUE, (Object)ImmutableList.of((Object)"a", (Object)"e"))));
        this.queryableIndex = TestIndex.persistRealtimeAndLoadMMapped(this.incrementalIndex);
    }

    @Test
    public void testTimeseriesQuery() {
        TimeseriesQueryEngine engine = new TimeseriesQueryEngine();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)ImmutableList.of((Object)new StringLastAggregatorFactory("nonfolding", CLIENT_TYPE, null, Integer.valueOf(1024)), (Object)new StringLastAggregatorFactory("folding", LAST_CLIENT_TYPE, null, Integer.valueOf(1024)), (Object)new StringLastAggregatorFactory("nonexistent", "nonexistent", null, Integer.valueOf(1024)), (Object)new StringLastAggregatorFactory("numeric", "cnt", null, Integer.valueOf(1024)), (Object)new StringLastAggregatorFactory("multiValue", MULTI_VALUE, null, Integer.valueOf(1024)))).build();
        List expectedResults = Collections.singletonList(new Result(TIME1, (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"nonfolding", (Object)new SerializablePairLongString(Long.valueOf(TIME2.getMillis()), "android")).put((Object)"folding", (Object)new SerializablePairLongString(Long.valueOf(TIME2.getMillis()), "android")).put((Object)"nonexistent", (Object)new SerializablePairLongString(Long.valueOf(DateTimes.MIN.getMillis()), null)).put((Object)"numeric", (Object)new SerializablePairLongString(Long.valueOf(DateTimes.MIN.getMillis()), null)).put((Object)"multiValue", (Object)new SerializablePairLongString(Long.valueOf(TIME2.getMillis()), "[a, e]")).build())));
        DefaultTimeseriesQueryMetrics defaultTimeseriesQueryMetrics = new DefaultTimeseriesQueryMetrics();
        List iiResults = engine.process(query, (CursorFactory)new IncrementalIndexCursorFactory(this.incrementalIndex), (TimeBoundaryInspector)new IncrementalIndexTimeBoundaryInspector(this.incrementalIndex), (TimeseriesQueryMetrics)defaultTimeseriesQueryMetrics).toList();
        List qiResults = engine.process(query, (CursorFactory)new QueryableIndexCursorFactory(this.queryableIndex), (TimeBoundaryInspector)QueryableIndexTimeBoundaryInspector.create((QueryableIndex)this.queryableIndex), (TimeseriesQueryMetrics)defaultTimeseriesQueryMetrics).toList();
        TestHelper.assertExpectedResults(expectedResults, iiResults, "incremental index");
        TestHelper.assertExpectedResults(expectedResults, qiResults, "queryable index");
    }
}

