/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.MacroTestBase;
import org.apache.druid.query.expression.RegexpLikeExprMacro;
import org.junit.Assert;
import org.junit.Test;

public class RegexpLikeExprMacroTest
extends MacroTestBase {
    public RegexpLikeExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new RegexpLikeExprMacro());
    }

    @Test
    public void testErrorZeroArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_like] requires 2 arguments");
        this.eval("regexp_like()", InputBindings.nilBindings());
    }

    @Test
    public void testErrorThreeArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_like] requires 2 arguments");
        this.eval("regexp_like('a', 'b', 'c')", InputBindings.nilBindings());
    }

    @Test
    public void testMatch() {
        ExprEval<?> result = this.eval("regexp_like(a, 'f.o')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNoMatch() {
        ExprEval<?> result = this.eval("regexp_like(a, 'f.x')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)false).value(), (Object)result.value());
    }

    @Test
    public void testNullPattern() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[regexp_like] pattern must be a STRING literal");
        }
        ExprEval<?> result = this.eval("regexp_like(a, null)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringPattern() {
        ExprEval<?> result = this.eval("regexp_like(a, '')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNullPatternOnEmptyString() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[regexp_like] pattern must be a STRING literal");
        }
        ExprEval<?> result = this.eval("regexp_like(a, null)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> ""));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringPatternOnEmptyString() {
        ExprEval<?> result = this.eval("regexp_like(a, '')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> ""));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNullPatternOnNull() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[regexp_like] pattern must be a STRING literal");
        }
        ExprEval<?> result = this.eval("regexp_like(a, null)", InputBindings.nilBindings());
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringPatternOnNull() {
        ExprEval<?> result = this.eval("regexp_like(a, '')", InputBindings.nilBindings());
        if (NullHandling.sqlCompatible()) {
            Assert.assertNull((Object)result.value());
        } else {
            Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
        }
    }
}

