/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.MacroTestBase;
import org.apache.druid.query.expression.TimestampShiftExprMacro;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;
import org.junit.Assert;
import org.junit.Test;

public class TimestampShiftMacroTest
extends MacroTestBase {
    private DateTime timestamp = DateTimes.of((String)"2020-11-05T04:05:06");

    public TimestampShiftMacroTest() {
        super((ExprMacroTable.ExprMacro)new TimestampShiftExprMacro());
    }

    @Test
    public void testZeroArguments() {
        this.expectException(IAE.class, "Function[timestamp_shift] requires 3 to 4 arguments");
        this.apply(Collections.emptyList());
    }

    @Test
    public void testOneArguments() {
        this.expectException(IAE.class, "Function[timestamp_shift] requires 3 to 4 arguments");
        this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr()));
    }

    @Test
    public void testTwoArguments() {
        this.expectException(IAE.class, "Function[timestamp_shift] requires 3 to 4 arguments");
        this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1M").toExpr()));
    }

    @Test
    public void testMoreThanFourArguments() {
        this.expectException(IAE.class, "Function[timestamp_shift] requires 3 to 4 arguments");
        this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1M").toExpr(), (Object)ExprEval.of((String)"1").toExpr(), (Object)ExprEval.of((String)"+08:00").toExpr(), (Object)ExprEval.of((String)"extra").toExpr()));
    }

    @Test
    public void testZeroStep() {
        int step = 0;
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1M").toExpr(), (Object)ExprEval.of((long)step).toExpr()));
        Assert.assertEquals((long)this.timestamp.withPeriodAdded((ReadablePeriod)Months.ONE, step).getMillis(), (long)expr.eval(InputBindings.nilBindings()).asLong());
    }

    @Test
    public void testPositiveStep() {
        int step = 5;
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1M").toExpr(), (Object)ExprEval.of((long)step).toExpr()));
        Assert.assertEquals((long)this.timestamp.withPeriodAdded((ReadablePeriod)Months.ONE, step).getMillis(), (long)expr.eval(InputBindings.nilBindings()).asLong());
    }

    @Test
    public void testNegativeStep() {
        int step = -3;
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1M").toExpr(), (Object)ExprEval.of((long)step).toExpr()));
        Assert.assertEquals((long)this.timestamp.withPeriodAdded((ReadablePeriod)Months.ONE, step).getMillis(), (long)expr.eval(InputBindings.nilBindings()).asLong());
    }

    @Test
    public void testPeriodMinute() {
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"PT1M").toExpr(), (Object)ExprEval.of((long)1L).toExpr()));
        Assert.assertEquals((long)this.timestamp.withPeriodAdded((ReadablePeriod)Minutes.ONE, 1).getMillis(), (long)expr.eval(InputBindings.nilBindings()).asLong());
    }

    @Test
    public void testPeriodDay() {
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1D").toExpr(), (Object)ExprEval.of((long)1L).toExpr()));
        Assert.assertEquals((long)this.timestamp.withPeriodAdded((ReadablePeriod)Days.ONE, 1).getMillis(), (long)expr.eval(InputBindings.nilBindings()).asLong());
    }

    @Test
    public void testPeriodYearAndTimeZone() {
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1Y").toExpr(), (Object)ExprEval.of((long)1L).toExpr(), (Object)ExprEval.of((String)"America/Los_Angeles").toExpr()));
        Assert.assertEquals((long)this.timestamp.toDateTime(DateTimes.inferTzFromString((String)"America/Los_Angeles")).withPeriodAdded((ReadablePeriod)Years.ONE, 1).getMillis(), (long)expr.eval(InputBindings.nilBindings()).asLong());
    }

    @Test
    public void testDynamicExpression() {
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.of((long)this.timestamp.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1Y").toExpr(), (Object)Parser.parse((String)"\"step\"", (ExprMacroTable)ExprMacroTable.nil()), (Object)ExprEval.of((String)"America/Los_Angeles").toExpr()));
        int step = 3;
        Assert.assertEquals((long)this.timestamp.toDateTime(DateTimes.inferTzFromString((String)"America/Los_Angeles")).withPeriodAdded((ReadablePeriod)Years.ONE, 3).getMillis(), (long)expr.eval(new Expr.ObjectBinding(){

            @Nullable
            public ExpressionType getType(String name) {
                return null;
            }

            @Nullable
            public Object get(String name) {
                if ("step".equals(name)) {
                    return 3;
                }
                throw new IAE("Invalid bindings", new Object[0]);
            }
        }).asLong());
    }

    @Test
    public void testNull() {
        Expr expr = this.apply((List<Expr>)ImmutableList.of((Object)ExprEval.ofLong(null).toExpr(), (Object)ExprEval.of((String)"P1M").toExpr(), (Object)ExprEval.of((long)1L).toExpr()));
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((Object)2678400000L, (Object)expr.eval(InputBindings.nilBindings()).value());
        } else {
            Assert.assertNull((Object)expr.eval(InputBindings.nilBindings()).value());
        }
    }
}

