/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterTestUtils;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.FilterTestUtils;
import org.apache.druid.segment.filter.TrueFilter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class AndDimFilterTest
extends InitializedNullHandlingTest {
    @Test
    public void testGetRequiredColumns() {
        AndDimFilter andDimFilter = new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("a", "d", null), new SelectorDimFilter("b", "d", null), new SelectorDimFilter("c", "d", null)}));
        Assert.assertEquals((Object)andDimFilter.getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"a", "b", "c"}));
    }

    @Test
    public void testToFilterWithDuplicateFilters() {
        AndDimFilter dimFilter = DimFilterTestUtils.and(new DimFilter[]{DimFilterTestUtils.or(new DimFilter[]{DimFilterTestUtils.selector("col1", "1"), DimFilterTestUtils.selector("col2", "2")}), DimFilterTestUtils.or(new DimFilter[]{DimFilterTestUtils.selector("col2", "2"), DimFilterTestUtils.selector("col1", "1")}), DimFilterTestUtils.selector("col3", "3")});
        AndFilter expected = FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "1"), FilterTestUtils.selector("col2", "2")}), FilterTestUtils.selector("col3", "3")});
        Assert.assertEquals((Object)expected, (Object)dimFilter.toFilter());
    }

    @Test
    public void testToFilterShortCircuitWithFalseFilter() {
        AndDimFilter filter = DimFilterTestUtils.and(new DimFilter[]{DimFilterTestUtils.selector("col1", "1"), FalseDimFilter.instance()});
        Assert.assertTrue((boolean)(filter.toFilter() instanceof FalseFilter));
    }

    @Test
    public void testToFilterOringTrueFilters() {
        AndDimFilter filter = DimFilterTestUtils.and(new DimFilter[]{TrueDimFilter.instance(), TrueDimFilter.instance()});
        Assert.assertSame((Object)TrueFilter.instance(), (Object)filter.toFilter());
    }

    @Test
    public void testToFilterAndOfSingleFilterUnwrapAnd() {
        SelectorDimFilter expected = DimFilterTestUtils.selector("col1", "1");
        AndDimFilter filter = DimFilterTestUtils.and(new DimFilter[]{expected});
        Assert.assertEquals((Object)expected.toFilter(), (Object)filter.toFilter());
    }

    @Test
    public void testToFilterAndOfMultipleFiltersReturningAsItIs() {
        AndDimFilter filter = DimFilterTestUtils.and(new DimFilter[]{DimFilterTestUtils.selector("col1", "1"), DimFilterTestUtils.selector("col1", "2")});
        Assert.assertEquals((Object)filter.toFilter(), (Object)filter.toFilter());
    }
}

