/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.QueryResourceId;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryResources;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class GroupByResourcesReservationPoolTest {
    private static final GroupByQueryConfig CONFIG = new GroupByQueryConfig();
    private static final GroupByQuery QUERY = GroupByQuery.builder().setInterval(Intervals.ETERNITY).setDataSource("foo").setDimensions((List)ImmutableList.of((Object)new DefaultDimensionSpec("dim2", "_d0"))).setGranularity(Granularities.ALL).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)0)).build();

    @Ignore(value="Isn't run as a part of CI since it sleeps for 5 seconds. Callers must run the test manually if any changes are made to the corresponding class")
    @Test(timeout=100000L)
    public void testInterleavedReserveAndRemove() {
        ExecutorService executor = Execs.multiThreaded((int)3, (String)"group-by-resources-reservation-pool-test-%d");
        Assert.assertEquals((long)1L, (long)(GroupByQueryResources.countRequiredMergeBufferNumForMergingQueryRunner((GroupByQueryConfig)CONFIG, (GroupByQuery)QUERY) + GroupByQueryResources.countRequiredMergeBufferNumForToolchestMerge((GroupByQuery)QUERY)));
        DefaultBlockingPool mergeBufferPool = new DefaultBlockingPool(() -> ByteBuffer.allocate(100), 1);
        GroupByResourcesReservationPool groupByResourcesReservationPool = new GroupByResourcesReservationPool((BlockingPool)mergeBufferPool, CONFIG);
        CountDownLatch reserveCalledByFirstThread = new CountDownLatch(1);
        CountDownLatch reserveCalledBySecondThread = new CountDownLatch(1);
        CountDownLatch threadsCompleted = new CountDownLatch(2);
        executor.submit(() -> {
            QueryResourceId queryResourceId1 = new QueryResourceId("test-id-1"){

                public int hashCode() {
                    return 10;
                }

                public boolean equals(Object o) {
                    return super.equals(o);
                }
            };
            groupByResourcesReservationPool.reserve(queryResourceId1, QUERY, true);
            reserveCalledByFirstThread.countDown();
            try {
                reserveCalledBySecondThread.await();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted while waiting for second reserve call to be made");
            }
            groupByResourcesReservationPool.clean(queryResourceId1);
            threadsCompleted.countDown();
        });
        executor.submit(() -> {
            try {
                reserveCalledByFirstThread.await();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted while waiting for first reserve call to be made");
            }
            QueryResourceId queryResourceId2 = new QueryResourceId("test-id-2"){

                public int hashCode() {
                    return 10;
                }

                public boolean equals(Object o) {
                    return super.equals(o);
                }
            };
            executor.submit(() -> {
                groupByResourcesReservationPool.reserve(queryResourceId2, QUERY, true);
                threadsCompleted.countDown();
            });
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted while sleeping");
            }
            reserveCalledBySecondThread.countDown();
        });
        try {
            threadsCompleted.await();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while waiting for the threads to complete");
        }
    }

    @Test
    public void testMultipleSimultaneousAllocationAttemptsFail() {
        DefaultBlockingPool mergeBufferPool = new DefaultBlockingPool(() -> ByteBuffer.allocate(100), 1);
        GroupByResourcesReservationPool groupByResourcesReservationPool = new GroupByResourcesReservationPool((BlockingPool)mergeBufferPool, CONFIG);
        QueryResourceId queryResourceId = new QueryResourceId("test-id");
        groupByResourcesReservationPool.reserve(queryResourceId, QUERY, true);
        Assert.assertThrows(DruidException.class, () -> groupByResourcesReservationPool.reserve(queryResourceId, QUERY, true));
    }

    @Test
    public void testMultipleSequentialAllocationAttemptsSucceed() {
        DefaultBlockingPool mergeBufferPool = new DefaultBlockingPool(() -> ByteBuffer.allocate(100), 1);
        GroupByResourcesReservationPool groupByResourcesReservationPool = new GroupByResourcesReservationPool((BlockingPool)mergeBufferPool, CONFIG);
        QueryResourceId queryResourceId = new QueryResourceId("test-id");
        groupByResourcesReservationPool.reserve(queryResourceId, QUERY, true);
        GroupByQueryResources oldResources = groupByResourcesReservationPool.fetch(queryResourceId);
        groupByResourcesReservationPool.clean(queryResourceId);
        groupByResourcesReservationPool.reserve(queryResourceId, QUERY, true);
        GroupByQueryResources newResources = groupByResourcesReservationPool.fetch(queryResourceId);
        Assert.assertNotNull((Object)newResources);
        Assert.assertNotSame((Object)oldResources, (Object)newResources);
    }
}

