/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.TestBufferPool;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.having.GreaterThanHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NestedQueryPushDownTest
extends InitializedNullHandlingTest {
    private static final IndexIO INDEX_IO;
    private static final IndexMergerV9 INDEX_MERGER_V9;
    public static final ObjectMapper JSON_MAPPER;
    private File tmpDir;
    private QueryRunnerFactory<ResultRow, GroupByQuery> groupByFactory;
    private QueryRunnerFactory<ResultRow, GroupByQuery> groupByFactory2;
    private List<IncrementalIndex> incrementalIndices = new ArrayList<IncrementalIndex>();
    private List<QueryableIndex> groupByIndices = new ArrayList<QueryableIndex>();
    private ExecutorService executorService;
    private Closer closer;
    public static final QueryWatcher NOOP_QUERYWATCHER;

    private IncrementalIndex makeIncIndex() {
        return new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dimA"), new StringDimensionSchema("dimB"), new LongDimensionSchema("metA"), new LongDimensionSchema("metB")))).build()).setMaxRowCount(1000).build();
    }

    @Before
    public void setup() throws Exception {
        this.closer = Closer.create();
        this.tmpDir = FileUtils.createTempDir();
        List<String> dimNames = Arrays.asList("dimA", "metA", "dimB", "metB");
        IncrementalIndex indexA = this.makeIncIndex();
        this.incrementalIndices.add(indexA);
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("dimA", "pomegranate");
        event.put("metA", 1000L);
        event.put("dimB", "sweet");
        event.put("metB", 10L);
        MapBasedInputRow row = new MapBasedInputRow(1505260888888L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 1000L);
        event.put("dimB", "sweet");
        event.put("metB", 20L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 1000L);
        event.put("dimB", "sweet");
        event.put("metB", 10L);
        row = new MapBasedInputRow(1505264400000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 1000L);
        event.put("dimB", "sweet");
        event.put("metB", 20L);
        row = new MapBasedInputRow(1505264400400L, dimNames, event);
        indexA.add((InputRow)row);
        File fileA = INDEX_MERGER_V9.persist(indexA, new File(this.tmpDir, "A"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexA = INDEX_IO.loadIndex(fileA);
        IncrementalIndex indexB = this.makeIncIndex();
        this.incrementalIndices.add(indexB);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 1000L);
        event.put("dimB", "sweet");
        event.put("metB", 10L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 1000L);
        event.put("dimB", "sweet");
        event.put("metB", 20L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 1000L);
        event.put("dimB", "sour");
        event.put("metB", 10L);
        row = new MapBasedInputRow(1505264400000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 1000L);
        event.put("dimB", "sour");
        event.put("metB", 20L);
        row = new MapBasedInputRow(1505264400000L, dimNames, event);
        indexB.add((InputRow)row);
        File fileB = INDEX_MERGER_V9.persist(indexB, new File(this.tmpDir, "B"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexB = INDEX_IO.loadIndex(fileB);
        this.groupByIndices = Arrays.asList(qindexA, qindexB);
        this.setupGroupByFactory();
    }

    private void setupGroupByFactory() {
        this.executorService = Execs.multiThreaded((int)3, (String)"GroupByThreadPool[%d]");
        TestBufferPool bufferPool = TestBufferPool.offHeap(10000000, Integer.MAX_VALUE);
        TestBufferPool mergePool = TestBufferPool.offHeap(10000000, 10);
        TestBufferPool mergePool2 = TestBufferPool.offHeap(10000000, 10);
        this.closer.register(() -> {
            Assert.assertEquals((long)0L, (long)bufferPool.getOutstandingObjectCount());
            Assert.assertEquals((long)0L, (long)mergePool.getOutstandingObjectCount());
            Assert.assertEquals((long)0L, (long)mergePool2.getOutstandingObjectCount());
        });
        GroupByQueryConfig config = new GroupByQueryConfig(){

            public int getBufferGrouperInitialBuckets() {
                return -1;
            }

            public HumanReadableBytes getMaxOnDiskStorage() {
                return HumanReadableBytes.valueOf((long)1000000000L);
            }
        };
        config.setSingleThreaded(false);
        DruidProcessingConfig druidProcessingConfig = new DruidProcessingConfig(){

            public int getNumThreads() {
                return 2;
            }

            public String getFormatString() {
                return null;
            }
        };
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByResourcesReservationPool groupByResourcesReservationPool = new GroupByResourcesReservationPool((BlockingPool)mergePool, config);
        GroupByResourcesReservationPool groupByResourcesReservationPool2 = new GroupByResourcesReservationPool((BlockingPool)mergePool2, config);
        GroupingEngine engine1 = new GroupingEngine(druidProcessingConfig, configSupplier, groupByResourcesReservationPool, TestHelper.makeJsonMapper(), new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER);
        GroupingEngine engine2 = new GroupingEngine(druidProcessingConfig, configSupplier, groupByResourcesReservationPool2, TestHelper.makeJsonMapper(), new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER);
        this.groupByFactory = new GroupByQueryRunnerFactory(engine1, new GroupByQueryQueryToolChest(engine1, groupByResourcesReservationPool), (NonBlockingPool)bufferPool);
        this.groupByFactory2 = new GroupByQueryRunnerFactory(engine2, new GroupByQueryQueryToolChest(engine2, groupByResourcesReservationPool2), (NonBlockingPool)bufferPool);
    }

    @After
    public void tearDown() throws Exception {
        this.closer.close();
        this.closer = null;
        for (IncrementalIndex incrementalIndex : this.incrementalIndices) {
            incrementalIndex.close();
        }
        for (QueryableIndex queryableIndex : this.groupByIndices) {
            queryableIndex.close();
        }
        if (this.tmpDir != null) {
            FileUtils.deleteDirectory((File)this.tmpDir);
        }
    }

    @Test
    public void testSimpleDoubleAggregation() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)query).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("totalSum", "metASum")}).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).build();
        Sequence<ResultRow> queryResult = this.runNestedQueryWithForcePushDown(nestedQuery);
        List results = queryResult.toList();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "dimB", "sour", "totalSum", 2000L);
        ResultRow expectedRow1 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "dimB", "sweet", "totalSum", 6000L);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
        Assert.assertEquals((Object)expectedRow1, results.get(1));
    }

    @Test
    public void testNestedQueryWithRenamedDimensions() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "newDimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)query).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("newDimB", "renamedDimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("maxBSum", "metBSum")}).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).build();
        Sequence<ResultRow> queryResult = this.runNestedQueryWithForcePushDown(nestedQuery);
        List results = queryResult.toList();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "renamedDimB", "sour", "maxBSum", 20L);
        ResultRow expectedRow1 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "renamedDimB", "sweet", "maxBSum", 60L);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
        Assert.assertEquals((Object)expectedRow1, results.get(1));
    }

    @Test
    public void testDimensionFilterOnOuterAndInnerQueries() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimFilter((DimFilter)new JavaScriptDimFilter("dimA", "function(dim){ return dim == 'mango' }", null, JavaScriptConfig.getEnabledInstance())).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)query).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "newDimA")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("finalSum", "metASum")}).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).setDimFilter((DimFilter)new JavaScriptDimFilter("dimA", "function(dim){ return dim == 'pomegranate' }", null, JavaScriptConfig.getEnabledInstance())).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        Sequence<ResultRow> queryResult = this.runNestedQueryWithForcePushDown(nestedQuery);
        List results = queryResult.toList();
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testDimensionFilterOnOuterQuery() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)query).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "newDimA")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("finalSum", "metASum")}).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).setDimFilter((DimFilter)new JavaScriptDimFilter("dimA", "function(dim){ return dim == 'mango' }", null, JavaScriptConfig.getEnabledInstance())).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "finalSum", 4000L, "newDimA", "mango");
        Sequence<ResultRow> queryResult = this.runNestedQueryWithForcePushDown(nestedQuery);
        List results = queryResult.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
    }

    @Test
    public void testDimensionFilterOnInnerQuery() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimFilter((DimFilter)new JavaScriptDimFilter("dimA", "function(dim){ return dim == 'mango' }", null, JavaScriptConfig.getEnabledInstance())).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)query).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "newDimA")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("finalSum", "metASum")}).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "finalSum", 4000L, "newDimA", "mango");
        Sequence<ResultRow> queryResult = this.runNestedQueryWithForcePushDown(nestedQuery);
        List results = queryResult.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
    }

    @Test
    public void testSubqueryWithExtractionFnInOuterQuery() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)query).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dimA", "extractedDimA", (ExtractionFn)new RegexDimExtractionFn("^(p)", Boolean.valueOf(true), "replacement"))}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("finalSum", "metASum")}).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "finalSum", 4000L, "extractedDimA", "p");
        ResultRow expectedRow1 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "finalSum", 4000L, "extractedDimA", "replacement");
        Sequence<ResultRow> queryResult = this.runNestedQueryWithForcePushDown(nestedQuery);
        List results = queryResult.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
        Assert.assertEquals((Object)expectedRow1, results.get(1));
    }

    @Test
    public void testHavingClauseInNestedPushDownQuery() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery innerQuery = GroupByQuery.builder().setDataSource("blah").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)innerQuery).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("finalSum", "metBSum")}).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("finalSum", (Number)70L)).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).build();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(nestedQuery, "2017-07-14T02:40:00.000Z", "dimB", "sweet", "finalSum", 90L);
        Sequence<ResultRow> queryResult = this.runNestedQueryWithForcePushDown(nestedQuery);
        List results = queryResult.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
    }

    private Sequence<ResultRow> runNestedQueryWithForcePushDown(GroupByQuery nestedQuery) {
        ResponseContext context = ResponseContext.createEmpty();
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        QueryToolChest toolChest2 = this.groupByFactory2.getToolchest();
        GroupByQuery pushDownQuery = nestedQuery;
        FinalizeResultsQueryRunner segment1Runner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, this.getQueryRunnerForSegment1()), true), toolChest);
        FinalizeResultsQueryRunner segment2Runner = new FinalizeResultsQueryRunner(toolChest2.mergeResults(this.groupByFactory2.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, this.getQueryRunnerForSegment2()), true), toolChest);
        QueryRunner baseRunner = toolChest.mergeResults((arg_0, arg_1) -> NestedQueryPushDownTest.lambda$runNestedQueryWithForcePushDown$1((QueryRunner)segment1Runner, toolChest, (QueryRunner)segment2Runner, arg_0, arg_1), true);
        FinalizeResultsQueryRunner queryRunnerForSegments = new FinalizeResultsQueryRunner(baseRunner, toolChest);
        GroupingEngine groupingEngine = ((GroupByQueryRunnerFactory)this.groupByFactory).getGroupingEngine();
        GroupByQuery queryWithPushDownDisabled = pushDownQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)false));
        Sequence pushDownQueryResults = groupingEngine.mergeResults((QueryRunner)queryRunnerForSegments, (GroupByQuery)GroupByQueryRunnerTestHelper.populateResourceId(queryWithPushDownDisabled), context);
        return toolChest.mergeResults((queryPlus, responseContext) -> pushDownQueryResults).run(QueryPlus.wrap(GroupByQueryRunnerTestHelper.populateResourceId(nestedQuery)), context);
    }

    @Test
    public void testQueryRewriteForPushDown() {
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        String outputNameB = "dimBOutput";
        String outputNameAgg = "totalSum";
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new DefaultDimensionSpec("dimB", "dimB")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA"), new LongSumAggregatorFactory("metBSum", "metB")}).setGranularity(Granularities.ALL).build();
        GroupByQuery nestedQuery = GroupByQuery.builder().setDataSource((Query)query).setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimB", outputNameB)}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory(outputNameAgg, "metASum")}).setContext((Map)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)true)).setGranularity(Granularities.ALL).build();
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        GroupByQuery rewrittenQuery = ((GroupByQueryQueryToolChest)toolChest).rewriteNestedQueryForPushDown(nestedQuery);
        Assert.assertEquals((Object)outputNameB, (Object)((DimensionSpec)rewrittenQuery.getDimensions().get(0)).getDimension());
        Assert.assertEquals((Object)outputNameAgg, (Object)((AggregatorFactory)rewrittenQuery.getAggregatorSpecs().get(0)).getName());
    }

    public static <T, QueryType extends Query<T>> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, QueryType> factory, SegmentId segmentId, Segment adapter) {
        return new FinalizeResultsQueryRunner((QueryRunner)new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), factory.createRunner(adapter)), factory.getToolchest());
    }

    private List<QueryRunner<ResultRow>> getQueryRunnerForSegment1() {
        ArrayList<QueryRunner<ResultRow>> runners = new ArrayList<QueryRunner<ResultRow>>();
        QueryableIndex index = this.groupByIndices.get(0);
        QueryRunner<ResultRow> runner = NestedQueryPushDownTest.makeQueryRunnerForSegment(this.groupByFactory, SegmentId.dummy((String)index.toString()), (Segment)new QueryableIndexSegment(index, SegmentId.dummy((String)index.toString())));
        runners.add(this.groupByFactory.getToolchest().preMergeQueryDecoration(runner));
        return runners;
    }

    private List<QueryRunner<ResultRow>> getQueryRunnerForSegment2() {
        ArrayList<QueryRunner<ResultRow>> runners = new ArrayList<QueryRunner<ResultRow>>();
        QueryableIndex index2 = this.groupByIndices.get(1);
        QueryRunner<ResultRow> tooSmallRunner = NestedQueryPushDownTest.makeQueryRunnerForSegment(this.groupByFactory2, SegmentId.dummy((String)index2.toString()), (Segment)new QueryableIndexSegment(index2, SegmentId.dummy((String)index2.toString())));
        runners.add(this.groupByFactory2.getToolchest().preMergeQueryDecoration(tooSmallRunner));
        return runners;
    }

    private static <T, QueryType extends Query<T>> QueryRunner<T> makeQueryRunnerForSegment(QueryRunnerFactory<T, QueryType> factory, SegmentId segmentId, Segment adapter) {
        return new FinalizeResultsQueryRunner((QueryRunner)new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), factory.createRunner(adapter)), factory.getToolchest());
    }

    private static /* synthetic */ Sequence lambda$runNestedQueryWithForcePushDown$1(QueryRunner segment1Runner, QueryToolChest toolChest, QueryRunner segment2Runner, QueryPlus queryPlus, ResponseContext responseContext) {
        return Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.map((Sequence)segment1Runner.run(GroupByQueryRunnerTestHelper.populateResourceId(queryPlus), responseContext), (Function)toolChest.makePreComputeManipulatorFn((Query)((GroupByQuery)queryPlus.getQuery()), MetricManipulatorFns.deserializing())), (Object)Sequences.map((Sequence)segment2Runner.run(GroupByQueryRunnerTestHelper.populateResourceId(queryPlus), responseContext), (Function)toolChest.makePreComputeManipulatorFn((Query)((GroupByQuery)queryPlus.getQuery()), MetricManipulatorFns.deserializing())))).flatMerge(java.util.function.Function.identity(), queryPlus.getQuery().getResultOrdering());
    }

    static {
        JSON_MAPPER = new DefaultObjectMapper();
        JSON_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)ExprMacroTable.nil()));
        INDEX_IO = new IndexIO(JSON_MAPPER, ColumnConfig.DEFAULT);
        INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        NOOP_QUERYWATCHER = (query, future) -> {};
    }
}

