/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.GroupByColumnSelectorStrategyFactory;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FixedWidthGroupByColumnSelectorStrategyTest
extends InitializedNullHandlingTest {
    private static final List<Object[]> DATASOURCE_ROWS = ImmutableList.of((Object)new Object[]{1L, Float.valueOf(1.0f), 1.0}, (Object)new Object[]{2L, Float.valueOf(2.0f), 2.0}, (Object)new Object[]{null, null, null}, (Object)new Object[]{3L, Float.valueOf(3.0f), 3.0});
    private static final GroupByColumnSelectorStrategyFactory STRATEGY_FACTORY = new GroupByColumnSelectorStrategyFactory();
    private static final ByteBuffer BUFFER1 = ByteBuffer.allocate(10);
    private static final ByteBuffer BUFFER2 = ByteBuffer.allocate(10);
    private static final String LONG_COLUMN = "long";
    private static final String FLOAT_COLUMN = "float";
    private static final String DOUBLE_COLUMN = "double";

    private static Cursor createCursor() {
        return (Cursor)IterableRowsCursorHelper.getCursorFromIterable(FixedWidthGroupByColumnSelectorStrategyTest.DATASOURCE_ROWS, (RowSignature)RowSignature.builder().add((String)LONG_COLUMN, (ColumnType)ColumnType.LONG).add((String)FLOAT_COLUMN, (ColumnType)ColumnType.FLOAT).add((String)DOUBLE_COLUMN, (ColumnType)ColumnType.DOUBLE).build()).lhs;
    }

    static /* synthetic */ GroupByColumnSelectorStrategyFactory access$100() {
        return STRATEGY_FACTORY;
    }

    public static class DoubleGroupByColumnSelectorStrategyTest {
        private static final GroupByColumnSelectorStrategy STRATEGY = FixedWidthGroupByColumnSelectorStrategyTest.access$100().makeColumnSelectorStrategy(FixedWidthGroupByColumnSelectorStrategyTest.access$000().getColumnSelectorFactory().getColumnCapabilities("double"), FixedWidthGroupByColumnSelectorStrategyTest.access$000().getColumnSelectorFactory().makeColumnValueSelector("double"), "dimension");

        @Test
        public void testKeySize() {
            Assert.assertEquals((long)9L, (long)STRATEGY.getGroupingKeySizeBytes());
        }

        @Test
        public void testWriteToKeyBuffer() {
            Cursor cursor = FixedWidthGroupByColumnSelectorStrategyTest.createCursor();
            ResultRow resultRow = ResultRow.create((int)1);
            ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(FixedWidthGroupByColumnSelectorStrategyTest.DOUBLE_COLUMN);
            GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
            Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
            int rowNum = 0;
            while (!cursor.isDone()) {
                int sizeIncrease = STRATEGY.writeToKeyBuffer(0, columnValueSelector, BUFFER1);
                STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
                Assert.assertEquals((long)0L, (long)sizeIncrease);
                Assert.assertEquals((Object)NullHandling.nullToEmptyIfNeeded((Double)((Double)((Object[])DATASOURCE_ROWS.get(rowNum))[2])), (Object)resultRow.get(0));
                cursor.advance();
                ++rowNum;
            }
        }

        @Test
        public void testInitColumnValues() {
            Cursor cursor = FixedWidthGroupByColumnSelectorStrategyTest.createCursor();
            ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(FixedWidthGroupByColumnSelectorStrategyTest.DOUBLE_COLUMN);
            Object[] valuess = new Object[1];
            int rowNum = 0;
            while (!cursor.isDone()) {
                int sizeIncrease = STRATEGY.initColumnValues(columnValueSelector, 0, valuess);
                Assert.assertEquals((long)0L, (long)sizeIncrease);
                Assert.assertEquals((Object)NullHandling.nullToEmptyIfNeeded((Double)((Double)((Object[])DATASOURCE_ROWS.get(rowNum))[2])), (Object)valuess[0]);
                cursor.advance();
                ++rowNum;
            }
        }

        @Test
        public void testBufferComparator() {
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 100.0);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 200.0);
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 100.0);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100.0);
            Assert.assertEquals((long)0L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 200.0);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100.0);
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, null);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 0.0);
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 0.0);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, null);
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, null);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, null);
            Assert.assertEquals((long)0L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 2.0);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100.0);
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, StringComparators.LEXICOGRAPHIC).compare(BUFFER1, BUFFER2, 0, 0));
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 2.0);
            DoubleGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100.0);
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, StringComparators.ALPHANUMERIC).compare(BUFFER1, BUFFER2, 0, 0));
        }

        private static void writeGroupingKeyToBuffer(ByteBuffer buffer, @Nullable Double key) {
            ColumnValueSelector columnValueSelector1 = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
            Mockito.when((Object)columnValueSelector1.getObject()).thenReturn((Object)key);
            Mockito.when((Object)columnValueSelector1.getDouble()).thenReturn((Object)(key == null ? 0.0 : key));
            Mockito.when((Object)columnValueSelector1.isNull()).thenReturn((Object)(key == null ? 1 : 0));
            Assert.assertEquals((long)0L, (long)STRATEGY.writeToKeyBuffer(0, columnValueSelector1, buffer));
        }

        @Test
        public void testMultiValueHandling() {
            Assert.assertFalse((boolean)STRATEGY.checkRowIndexAndAddValueToGroupingKey(0, (Object)1.0, 0, BUFFER1));
            Assert.assertFalse((boolean)STRATEGY.checkRowIndexAndAddValueToGroupingKey(0, (Object)1.0, 10, BUFFER1));
        }

        @Test
        public void testInitGroupingKeyColumnValue() {
            GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
            Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
            int[] stack = new int[1];
            ResultRow resultRow = ResultRow.create((int)1);
            STRATEGY.initGroupingKeyColumnValue(0, 0, (Object)1001.0, BUFFER1, stack);
            Assert.assertEquals((long)1L, (long)stack[0]);
            STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
            Assert.assertEquals((Object)1001.0, (Object)resultRow.get(0));
            STRATEGY.initGroupingKeyColumnValue(0, 0, null, BUFFER1, stack);
            Assert.assertEquals((long)0L, (long)stack[0]);
            STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
            Assert.assertEquals(null, (Object)resultRow.get(0));
        }
    }

    public static class FloatGroupByColumnSelectorStrategyTest {
        private static final GroupByColumnSelectorStrategy STRATEGY = FixedWidthGroupByColumnSelectorStrategyTest.access$100().makeColumnSelectorStrategy(FixedWidthGroupByColumnSelectorStrategyTest.access$000().getColumnSelectorFactory().getColumnCapabilities("float"), FixedWidthGroupByColumnSelectorStrategyTest.access$000().getColumnSelectorFactory().makeColumnValueSelector("float"), "dimension");

        @Test
        public void testKeySize() {
            Assert.assertEquals((long)5L, (long)STRATEGY.getGroupingKeySizeBytes());
        }

        @Test
        public void testWriteToKeyBuffer() {
            Cursor cursor = FixedWidthGroupByColumnSelectorStrategyTest.createCursor();
            ResultRow resultRow = ResultRow.create((int)1);
            ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(FixedWidthGroupByColumnSelectorStrategyTest.FLOAT_COLUMN);
            GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
            Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
            int rowNum = 0;
            while (!cursor.isDone()) {
                int sizeIncrease = STRATEGY.writeToKeyBuffer(0, columnValueSelector, BUFFER1);
                STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
                Assert.assertEquals((long)0L, (long)sizeIncrease);
                Assert.assertEquals((Object)NullHandling.nullToEmptyIfNeeded((Float)((Float)((Object[])DATASOURCE_ROWS.get(rowNum))[1])), (Object)resultRow.get(0));
                cursor.advance();
                ++rowNum;
            }
        }

        @Test
        public void testInitColumnValues() {
            Cursor cursor = FixedWidthGroupByColumnSelectorStrategyTest.createCursor();
            ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(FixedWidthGroupByColumnSelectorStrategyTest.FLOAT_COLUMN);
            Object[] valuess = new Object[1];
            int rowNum = 0;
            while (!cursor.isDone()) {
                int sizeIncrease = STRATEGY.initColumnValues(columnValueSelector, 0, valuess);
                Assert.assertEquals((long)0L, (long)sizeIncrease);
                Assert.assertEquals((Object)NullHandling.nullToEmptyIfNeeded((Float)((Float)((Object[])DATASOURCE_ROWS.get(rowNum))[1])), (Object)valuess[0]);
                cursor.advance();
                ++rowNum;
            }
        }

        @Test
        public void testBufferComparator() {
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, Float.valueOf(100.0f));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, Float.valueOf(200.0f));
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, Float.valueOf(100.0f));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, Float.valueOf(100.0f));
            Assert.assertEquals((long)0L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, Float.valueOf(200.0f));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, Float.valueOf(100.0f));
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, null);
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, Float.valueOf(0.0f));
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, Float.valueOf(0.0f));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, null);
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, null);
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, null);
            Assert.assertEquals((long)0L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, Float.valueOf(2.0f));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, Float.valueOf(100.0f));
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, StringComparators.LEXICOGRAPHIC).compare(BUFFER1, BUFFER2, 0, 0));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, Float.valueOf(2.0f));
            FloatGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, Float.valueOf(100.0f));
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, StringComparators.ALPHANUMERIC).compare(BUFFER1, BUFFER2, 0, 0));
        }

        private static void writeGroupingKeyToBuffer(ByteBuffer buffer, @Nullable Float key) {
            ColumnValueSelector columnValueSelector1 = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
            Mockito.when((Object)columnValueSelector1.getObject()).thenReturn((Object)key);
            Mockito.when((Object)Float.valueOf(columnValueSelector1.getFloat())).thenReturn((Object)Float.valueOf(key == null ? 0.0f : key.floatValue()));
            Mockito.when((Object)columnValueSelector1.isNull()).thenReturn((Object)(key == null ? 1 : 0));
            Assert.assertEquals((long)0L, (long)STRATEGY.writeToKeyBuffer(0, columnValueSelector1, buffer));
        }

        @Test
        public void testMultiValueHandling() {
            Assert.assertFalse((boolean)STRATEGY.checkRowIndexAndAddValueToGroupingKey(0, (Object)Float.valueOf(1.0f), 0, BUFFER1));
            Assert.assertFalse((boolean)STRATEGY.checkRowIndexAndAddValueToGroupingKey(0, (Object)Float.valueOf(1.0f), 10, BUFFER1));
        }

        @Test
        public void testInitGroupingKeyColumnValue() {
            GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
            Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
            int[] stack = new int[1];
            ResultRow resultRow = ResultRow.create((int)1);
            STRATEGY.initGroupingKeyColumnValue(0, 0, (Object)Float.valueOf(1001.0f), BUFFER1, stack);
            Assert.assertEquals((long)1L, (long)stack[0]);
            STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
            Assert.assertEquals((Object)Float.valueOf(1001.0f), (Object)resultRow.get(0));
            STRATEGY.initGroupingKeyColumnValue(0, 0, null, BUFFER1, stack);
            Assert.assertEquals((long)0L, (long)stack[0]);
            STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
            Assert.assertEquals(null, (Object)resultRow.get(0));
        }
    }

    public static class LongGroupByColumnSelectorStrategyTest {
        private static final GroupByColumnSelectorStrategy STRATEGY = FixedWidthGroupByColumnSelectorStrategyTest.access$100().makeColumnSelectorStrategy(FixedWidthGroupByColumnSelectorStrategyTest.access$000().getColumnSelectorFactory().getColumnCapabilities("long"), FixedWidthGroupByColumnSelectorStrategyTest.access$000().getColumnSelectorFactory().makeColumnValueSelector("long"), "dimension");

        @Test
        public void testKeySize() {
            Assert.assertEquals((long)9L, (long)STRATEGY.getGroupingKeySizeBytes());
        }

        @Test
        public void testWriteToKeyBuffer() {
            Cursor cursor = FixedWidthGroupByColumnSelectorStrategyTest.createCursor();
            ResultRow resultRow = ResultRow.create((int)1);
            ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(FixedWidthGroupByColumnSelectorStrategyTest.LONG_COLUMN);
            GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
            Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
            int rowNum = 0;
            while (!cursor.isDone()) {
                int sizeIncrease = STRATEGY.writeToKeyBuffer(0, columnValueSelector, BUFFER1);
                STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
                Assert.assertEquals((long)0L, (long)sizeIncrease);
                Assert.assertEquals((Object)NullHandling.nullToEmptyIfNeeded((Long)((Long)((Object[])DATASOURCE_ROWS.get(rowNum))[0])), (Object)resultRow.get(0));
                cursor.advance();
                ++rowNum;
            }
        }

        @Test
        public void testInitColumnValues() {
            Cursor cursor = FixedWidthGroupByColumnSelectorStrategyTest.createCursor();
            ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(FixedWidthGroupByColumnSelectorStrategyTest.LONG_COLUMN);
            Object[] valuess = new Object[1];
            int rowNum = 0;
            while (!cursor.isDone()) {
                int sizeIncrease = STRATEGY.initColumnValues(columnValueSelector, 0, valuess);
                Assert.assertEquals((long)0L, (long)sizeIncrease);
                Assert.assertEquals((Object)NullHandling.nullToEmptyIfNeeded((Long)((Long)((Object[])DATASOURCE_ROWS.get(rowNum))[0])), (Object)valuess[0]);
                cursor.advance();
                ++rowNum;
            }
        }

        @Test
        public void testBufferComparator() {
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 100L);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 200L);
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 100L);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100L);
            Assert.assertEquals((long)0L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 200L);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100L);
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, null);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 0L);
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 0L);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, null);
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, null);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, null);
            Assert.assertEquals((long)0L, (long)STRATEGY.bufferComparator(0, null).compare(BUFFER1, BUFFER2, 0, 0));
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 2L);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100L);
            Assert.assertEquals((long)1L, (long)STRATEGY.bufferComparator(0, StringComparators.LEXICOGRAPHIC).compare(BUFFER1, BUFFER2, 0, 0));
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER1, 2L);
            LongGroupByColumnSelectorStrategyTest.writeGroupingKeyToBuffer(BUFFER2, 100L);
            Assert.assertEquals((long)-1L, (long)STRATEGY.bufferComparator(0, StringComparators.ALPHANUMERIC).compare(BUFFER1, BUFFER2, 0, 0));
        }

        private static void writeGroupingKeyToBuffer(ByteBuffer buffer, @Nullable Long key) {
            ColumnValueSelector columnValueSelector1 = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
            Mockito.when((Object)columnValueSelector1.getObject()).thenReturn((Object)key);
            Mockito.when((Object)columnValueSelector1.getLong()).thenReturn((Object)(key == null ? 0L : key));
            Mockito.when((Object)columnValueSelector1.isNull()).thenReturn((Object)(key == null ? 1 : 0));
            Assert.assertEquals((long)0L, (long)STRATEGY.writeToKeyBuffer(0, columnValueSelector1, buffer));
        }

        @Test
        public void testMultiValueHandling() {
            Assert.assertFalse((boolean)STRATEGY.checkRowIndexAndAddValueToGroupingKey(0, (Object)1L, 0, BUFFER1));
            Assert.assertFalse((boolean)STRATEGY.checkRowIndexAndAddValueToGroupingKey(0, (Object)1L, 10, BUFFER1));
        }

        @Test
        public void testInitGroupingKeyColumnValue() {
            GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
            Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
            int[] stack = new int[1];
            ResultRow resultRow = ResultRow.create((int)1);
            STRATEGY.initGroupingKeyColumnValue(0, 0, (Object)1001L, BUFFER1, stack);
            Assert.assertEquals((long)1L, (long)stack[0]);
            STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
            Assert.assertEquals((Object)1001L, (Object)resultRow.get(0));
            STRATEGY.initGroupingKeyColumnValue(0, 0, null, BUFFER1, stack);
            Assert.assertEquals((long)0L, (long)stack[0]);
            STRATEGY.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
            Assert.assertEquals(null, (Object)resultRow.get(0));
        }
    }
}

