/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LookupExtractionFnTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private final boolean retainMissing;
    private final String replaceMissing;
    private final Boolean injective;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return Iterables.transform((Iterable)Sets.cartesianProduct((List)ImmutableList.of((Object)ImmutableSet.of((Object)true, (Object)false), (Object)ImmutableSet.of((Object)"", (Object)"MISSING VALUE"), (Object)ImmutableSet.of(Optional.of(true), Optional.of(false), Optional.empty()))), List::toArray);
    }

    public LookupExtractionFnTest(boolean retainMissing, String replaceMissing, Optional<Boolean> injective) {
        this.replaceMissing = NullHandling.emptyToNullIfNeeded((String)replaceMissing);
        this.retainMissing = retainMissing;
        this.injective = injective.orElse(null);
    }

    @Test
    public void testEqualsAndHash() {
        if (this.retainMissing && !NullHandling.isNullOrEquivalent((String)this.replaceMissing)) {
            return;
        }
        LookupExtractionFn lookupExtractionFn1 = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        LookupExtractionFn lookupExtractionFn2 = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        LookupExtractionFn lookupExtractionFn3 = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar2"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        Assert.assertEquals((Object)lookupExtractionFn1, (Object)lookupExtractionFn2);
        Assert.assertEquals((long)lookupExtractionFn1.hashCode(), (long)lookupExtractionFn2.hashCode());
        Assert.assertNotEquals((Object)lookupExtractionFn1, (Object)lookupExtractionFn3);
        Assert.assertNotEquals((long)lookupExtractionFn1.hashCode(), (long)lookupExtractionFn3.hashCode());
    }

    @Test
    public void testSimpleSerDe() throws IOException {
        if (this.retainMissing && !NullHandling.isNullOrEquivalent((String)this.replaceMissing)) {
            return;
        }
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        String str1 = OBJECT_MAPPER.writeValueAsString((Object)lookupExtractionFn);
        LookupExtractionFn lookupExtractionFn2 = (LookupExtractionFn)OBJECT_MAPPER.readValue(str1, LookupExtractionFn.class);
        Assert.assertEquals((Object)this.retainMissing, (Object)lookupExtractionFn2.isRetainMissingValue());
        Assert.assertEquals((Object)this.replaceMissing, (Object)lookupExtractionFn2.getReplaceMissingValueWith());
        if (this.injective == null) {
            Assert.assertEquals((Object)lookupExtractionFn2.getLookup().isOneToOne(), (Object)lookupExtractionFn2.isInjective());
        } else {
            Assert.assertEquals((Object)this.injective, (Object)lookupExtractionFn2.isInjective());
        }
        Assert.assertArrayEquals((byte[])lookupExtractionFn.getCacheKey(), (byte[])lookupExtractionFn2.getCacheKey());
        Assert.assertEquals((Object)str1, (Object)OBJECT_MAPPER.writeValueAsString((Object)lookupExtractionFn2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArgs() {
        if (!this.retainMissing || NullHandling.isNullOrEquivalent((String)this.replaceMissing)) {
            throw new IAE("Case not valid", new Object[0]);
        }
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, NullHandling.emptyToNullIfNeeded((String)this.replaceMissing), this.injective, Boolean.valueOf(false));
    }

    @Test
    public void testCacheKey() {
        if (this.retainMissing && !NullHandling.isNullOrEquivalent((String)this.replaceMissing)) {
            return;
        }
        HashMap<String, Object> weirdMap = new HashMap<String, Object>();
        weirdMap.put("foobar", null);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        if (NullHandling.isNullOrEquivalent((String)this.replaceMissing) || this.retainMissing) {
            Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), !lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), Boolean.valueOf(lookupExtractionFn.isInjective()), Boolean.valueOf(false)).getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), !lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), Boolean.valueOf(!lookupExtractionFn.isInjective()), Boolean.valueOf(false)).getCacheKey()));
        }
        Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(weirdMap, false), lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), Boolean.valueOf(lookupExtractionFn.isInjective()), Boolean.valueOf(false)).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), Boolean.valueOf(!lookupExtractionFn.isInjective()), Boolean.valueOf(false)).getCacheKey()));
    }
}

