/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.query.lookup.LookupSegment;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.RowBasedCursorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class LookupSegmentTest {
    public static final String LOOKUP_NAME = "mylookup";
    public static final Map<String, String> LOOKUP_MAP = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"b", (Comparable)((Object)"x"), (Object)"y");
    public static final LookupExtractorFactory LOOKUP_EXTRACTOR_FACTORY = new LookupExtractorFactory(){

        public boolean start() {
            return true;
        }

        public boolean close() {
            return true;
        }

        public boolean replaces(@Nullable LookupExtractorFactory other) {
            return true;
        }

        @Nullable
        public LookupIntrospectHandler getIntrospectHandler() {
            throw new UnsupportedOperationException("not needed for this test");
        }

        public void awaitInitialization() {
        }

        public boolean isInitialized() {
            return true;
        }

        public LookupExtractor get() {
            return new MapLookupExtractor(LOOKUP_MAP, false);
        }
    };
    private static final LookupSegment LOOKUP_SEGMENT = new LookupSegment("mylookup", LOOKUP_EXTRACTOR_FACTORY);

    @Test
    public void test_getId() {
        Assert.assertEquals((Object)SegmentId.dummy((String)LOOKUP_NAME), (Object)LOOKUP_SEGMENT.getId());
    }

    @Test
    public void test_getDataInterval() {
        Assert.assertEquals((Object)Intervals.ETERNITY, (Object)LOOKUP_SEGMENT.getDataInterval());
    }

    @Test
    public void test_asQueryableIndex() {
        Assert.assertNull((Object)LOOKUP_SEGMENT.as(QueryableIndex.class));
        Assert.assertNull((Object)LOOKUP_SEGMENT.asQueryableIndex());
    }

    @Test
    public void test_asStorageAdapter_getRowSignature() {
        Assert.assertEquals((Object)RowSignature.builder().add("k", ColumnType.STRING).add("v", ColumnType.STRING).build(), (Object)LOOKUP_SEGMENT.asCursorFactory().getRowSignature());
    }

    @Test
    public void test_asStorageAdapter_getColumnCapabilitiesK() {
        ColumnCapabilities capabilities = LOOKUP_SEGMENT.asCursorFactory().getColumnCapabilities("k");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)capabilities.isDictionaryEncoded().isTrue());
    }

    @Test
    public void test_asStorageAdapter_getColumnCapabilitiesV() {
        ColumnCapabilities capabilities = LOOKUP_SEGMENT.asCursorFactory().getColumnCapabilities("v");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)capabilities.isDictionaryEncoded().isTrue());
    }

    @Test
    public void test_asStorageAdapter_makeCursor() {
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.of((String)"1970/PT1H")).build();
        try (CursorHolder cursorHolder = LOOKUP_SEGMENT.asCursorFactory().makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            ArrayList<Pair> kvs = new ArrayList<Pair>();
            ColumnValueSelector keySelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("k");
            ColumnValueSelector valueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("v");
            while (!cursor.isDone()) {
                kvs.add(Pair.of((Object)String.valueOf(keySelector.getObject()), (Object)String.valueOf(valueSelector.getObject())));
                cursor.advanceUninterruptibly();
            }
            Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"a", (Object)"b"), (Object)Pair.of((Object)"x", (Object)"y")), kvs);
        }
    }

    @Test
    public void test_asStorageAdapter_isRowBasedAdapter() {
        MatcherAssert.assertThat((Object)LOOKUP_SEGMENT.asCursorFactory(), (Matcher)CoreMatchers.instanceOf(RowBasedCursorFactory.class));
    }
}

