/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.metadata.AggregatorMergeStrategy;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.timeline.LogicalSegment;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class SegmentMetadataQueryQueryToolChestTest {
    private static final DataSource TEST_DATASOURCE = new TableDataSource("dummy");
    private static final SegmentId TEST_SEGMENT_ID1 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)Intervals.of((String)"2020-01-01/2020-01-02"), (String)"test", (int)0);
    private static final SegmentId TEST_SEGMENT_ID2 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)Intervals.of((String)"2021-01-01/2021-01-02"), (String)"test", (int)0);

    @Test
    public void testCacheStrategy() throws Exception {
        SegmentMetadataQuery query = new SegmentMetadataQuery(TEST_DATASOURCE, (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, AggregatorMergeStrategy.STRICT);
        CacheStrategy strategy = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).getCacheStrategy(query);
        byte[] expectedKey = new byte[]{4, 9, 1, 10, 0, 0, 0, 3, 0, 2, 4};
        byte[] actualKey = strategy.computeCacheKey((Query)query);
        Assert.assertArrayEquals((byte[])expectedKey, (byte[])actualKey);
        SegmentAnalysis result = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), (List)ImmutableList.of((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.name(), true, false, 10881L, Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null))), 71982L, 100L, null, null, null, null);
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        SegmentAnalysis fromCacheValue = (SegmentAnalysis)objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        SegmentAnalysis fromCacheResult = (SegmentAnalysis)strategy.pullFromSegmentLevelCache().apply((Object)fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }

    @Test
    public void testMergeAggregators() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
    }

    @Test
    public void testMergeAggregatorsWithIntervals() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), (List)ImmutableList.of((Object)TEST_SEGMENT_ID1.getInterval()), new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), (List)ImmutableList.of((Object)TEST_SEGMENT_ID2.getInterval()), new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        ArrayList expectedIntervals = new ArrayList();
        expectedIntervals.addAll(analysis1.getIntervals());
        expectedIntervals.addAll(analysis2.getIntervals());
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", expectedIntervals, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", expectedIntervals, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", expectedIntervals, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", expectedIntervals, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
    }

    @Test
    public void testMergeAggregatorsOneNull() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
    }

    @Test
    public void testMergeAggregatorsAllNull() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
    }

    @Test
    public void testMergeAggregatorsConflict() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null);
        HashMap<String, Object> expectedLenient = new HashMap<String, Object>();
        expectedLenient.put("foo", new LongSumAggregatorFactory("foo", "foo"));
        expectedLenient.put("bar", null);
        expectedLenient.put("baz", new LongMaxAggregatorFactory("baz", "baz"));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), analysis1));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2)));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2)));
    }

    @Test
    public void testMergeAggregatorsConflictWithDifferentOrder() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null);
        HashMap<String, Object> expectedLenient = new HashMap<String, Object>();
        expectedLenient.put("foo", new LongSumAggregatorFactory("foo", "foo"));
        expectedLenient.put("bar", null);
        expectedLenient.put("baz", new LongMaxAggregatorFactory("baz", "baz"));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2)));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2)));
    }

    @Test
    public void testMergeAggregatorsConflictWithEqualSegmentIntervalsAndDifferentPartitions() {
        SegmentId segmentId1 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)Intervals.of((String)"2023-01-01/2023-01-02"), (String)"test", (int)1);
        SegmentId segmentId2 = SegmentId.of((String)TEST_DATASOURCE.toString(), (Interval)Intervals.of((String)"2023-01-01/2023-01-02"), (String)"test", (int)2);
        SegmentAnalysis analysis1 = new SegmentAnalysis(segmentId1.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(segmentId2.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null);
        HashMap<String, Object> expectedLenient = new HashMap<String, Object>();
        expectedLenient.put("foo", new LongSumAggregatorFactory("foo", "foo"));
        expectedLenient.put("bar", null);
        expectedLenient.put("baz", new LongMaxAggregatorFactory("baz", "baz"));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2", null, new LinkedHashMap(), 0L, 0L, null, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2", null, new LinkedHashMap(), 0L, 0L, expectedLenient, null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2)));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2));
        Assert.assertEquals((Object)new SegmentAnalysis("dummy_2023-01-01T00:00:00.000Z_2023-01-02T00:00:00.000Z_merged_2", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2)));
    }

    @Test
    public void testFilterSegments() {
        SegmentMetadataQueryConfig config = new SegmentMetadataQueryConfig();
        SegmentMetadataQueryQueryToolChest toolChest = new SegmentMetadataQueryQueryToolChest(config);
        List filteredSegments = toolChest.filterSegments(Druids.newSegmentMetadataQueryBuilder().dataSource("foo").merge(true).build(), ImmutableList.of((Object)"2000-01-01/P1D", (Object)"2000-01-04/P1D", (Object)"2000-01-09/P1D", (Object)"2000-01-09/P1D").stream().map(interval -> new LogicalSegment((String)interval){
            final /* synthetic */ String val$interval;
            {
                this.val$interval = string;
            }

            public Interval getInterval() {
                return Intervals.of((String)this.val$interval);
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)this.val$interval);
            }
        }).collect(Collectors.toList()));
        Assert.assertEquals((Object)Period.weeks((int)1), (Object)config.getDefaultHistory());
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2000-01-04/P1D"), (Object)Intervals.of((String)"2000-01-09/P1D"), (Object)Intervals.of((String)"2000-01-09/P1D")), filteredSegments.stream().map(LogicalSegment::getInterval).collect(Collectors.toList()));
    }

    @Test
    public void testMergeRollup() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(false));
        SegmentAnalysis analysis3 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(false));
        SegmentAnalysis analysis4 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(true));
        SegmentAnalysis analysis5 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(true));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis4).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis2, analysis4).isRollup());
        Assert.assertFalse((boolean)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis2, analysis3).isRollup());
        Assert.assertTrue((boolean)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis4, analysis5).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis4).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis2, analysis4).isRollup());
        Assert.assertFalse((boolean)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis2, analysis3).isRollup());
        Assert.assertTrue((boolean)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis4, analysis5).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis2).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis1, analysis4).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis2, analysis4).isRollup());
        Assert.assertFalse((boolean)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis2, analysis3).isRollup());
        Assert.assertTrue((boolean)SegmentMetadataQueryQueryToolChestTest.mergeEarliest(analysis4, analysis5).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis2).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis1, analysis4).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis2, analysis4).isRollup());
        Assert.assertFalse((boolean)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis2, analysis3).isRollup());
        Assert.assertTrue((boolean)SegmentMetadataQueryQueryToolChestTest.mergeLatest(analysis4, analysis5).isRollup());
    }

    @Test
    public void testInvalidMergeAggregatorsWithNullOrEmptyDatasource() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(false));
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> SegmentMetadataQueryQueryToolChest.mergeAnalyses(null, (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.STRICT)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("SegementMetadata queries require at least one datasource."));
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)ImmutableSet.of(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.STRICT)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("SegementMetadata queries require at least one datasource."));
    }

    @Test
    public void testMergeWithUnionDatasource() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, Boolean.valueOf(false));
        SegmentAnalysis expectedMergedAnalysis = new SegmentAnalysis("dummy_2021-01-01T00:00:00.000Z_2021-01-02T00:00:00.000Z_merged", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null);
        Assert.assertEquals((Object)expectedMergedAnalysis, (Object)SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("dummy"))).getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.LATEST)));
        Assert.assertEquals((Object)expectedMergedAnalysis, (Object)SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("dummy"), (Object)new TableDataSource("foo"), (Object)new TableDataSource("bar"))).getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.LATEST)));
    }

    @Test
    public void testMergeWithNullAnalyses() {
        SegmentAnalysis analysis1 = new SegmentAnalysis(TEST_SEGMENT_ID1.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis(TEST_SEGMENT_ID2.toString(), null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(false));
        Assert.assertEquals((Object)analysis1, (Object)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), (SegmentAnalysis)analysis1, null, (AggregatorMergeStrategy)AggregatorMergeStrategy.STRICT));
        Assert.assertEquals((Object)analysis2, (Object)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), null, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.STRICT));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), null, null, (AggregatorMergeStrategy)AggregatorMergeStrategy.STRICT));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), null, null, (AggregatorMergeStrategy)AggregatorMergeStrategy.LENIENT));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), null, null, (AggregatorMergeStrategy)AggregatorMergeStrategy.EARLIEST));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), null, null, (AggregatorMergeStrategy)AggregatorMergeStrategy.LATEST));
    }

    private static SegmentAnalysis mergeStrict(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.STRICT));
    }

    private static SegmentAnalysis mergeLenient(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.LENIENT));
    }

    private static SegmentAnalysis mergeEarliest(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.EARLIEST));
    }

    private static SegmentAnalysis mergeLatest(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses((Set)TEST_DATASOURCE.getTableNames(), (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (AggregatorMergeStrategy)AggregatorMergeStrategy.LATEST));
    }
}

