/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.BySegmentResultValueClass;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.AggregatorMergeStrategy;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ListColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.LogicalSegment;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentMetadataQueryTest
extends InitializedNullHandlingTest {
    private static final SegmentMetadataQueryRunnerFactory FACTORY = new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final String DATASOURCE = "testDatasource";
    private final QueryRunner runner1;
    private final QueryRunner runner2;
    private final boolean mmap1;
    private final boolean mmap2;
    private final boolean rollup1;
    private final boolean rollup2;
    private final boolean differentIds;
    private final SegmentMetadataQuery testQuery;
    private final SegmentAnalysis expectedSegmentAnalysis1;
    private final SegmentAnalysis expectedSegmentAnalysis2;
    private final boolean bitmaps;

    public static QueryRunner makeMMappedQueryRunner(SegmentId segmentId, boolean rollup, boolean bitmaps, QueryRunnerFactory factory) {
        QueryableIndex index = bitmaps ? (rollup ? TestIndex.getMMappedTestIndex() : TestIndex.getNoRollupMMappedTestIndex()) : TestIndex.getNoBitmapMMappedTestIndex();
        return QueryRunnerTestHelper.makeQueryRunner(factory, segmentId, (Segment)new QueryableIndexSegment(index, segmentId), null);
    }

    public static QueryRunner makeIncrementalIndexQueryRunner(SegmentId segmentId, boolean rollup, boolean bitmaps, QueryRunnerFactory factory) {
        IncrementalIndex index = bitmaps ? (rollup ? TestIndex.getIncrementalTestIndex() : TestIndex.getNoRollupIncrementalTestIndex()) : TestIndex.getNoBitmapIncrementalTestIndex();
        return QueryRunnerTestHelper.makeQueryRunner(factory, segmentId, (Segment)new IncrementalIndexSegment(index, segmentId), null);
    }

    @Parameterized.Parameters(name="mmap1 = {0}, mmap2 = {1}, rollup1 = {2}, rollup2 = {3}, differentIds = {4}, bitmaps={5}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{true, true, true, true, false, true}, (Object)new Object[]{true, false, true, false, false, true}, (Object)new Object[]{false, true, true, false, false, true}, (Object)new Object[]{false, false, false, false, false, true}, (Object)new Object[]{false, false, true, true, false, true}, (Object)new Object[]{false, false, false, true, true, true}, (Object)new Object[]{true, true, false, false, false, false});
    }

    public SegmentMetadataQueryTest(boolean mmap1, boolean mmap2, boolean rollup1, boolean rollup2, boolean differentIds, boolean bitmaps) {
        SegmentId id1 = SegmentId.dummy((String)(differentIds ? "testSegment1" : DATASOURCE));
        SegmentId id2 = SegmentId.dummy((String)(differentIds ? "testSegment2" : DATASOURCE));
        this.runner1 = mmap1 ? SegmentMetadataQueryTest.makeMMappedQueryRunner(id1, rollup1, bitmaps, (QueryRunnerFactory)FACTORY) : SegmentMetadataQueryTest.makeIncrementalIndexQueryRunner(id1, rollup1, bitmaps, (QueryRunnerFactory)FACTORY);
        this.runner2 = mmap2 ? SegmentMetadataQueryTest.makeMMappedQueryRunner(id2, rollup2, bitmaps, (QueryRunnerFactory)FACTORY) : SegmentMetadataQueryTest.makeIncrementalIndexQueryRunner(id2, rollup2, bitmaps, (QueryRunnerFactory)FACTORY);
        this.mmap1 = mmap1;
        this.mmap2 = mmap2;
        this.rollup1 = rollup1;
        this.rollup2 = rollup2;
        this.differentIds = differentIds;
        this.bitmaps = bitmaps;
        this.testQuery = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("__time", "index", "placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE, SegmentMetadataQuery.AnalysisType.INTERVAL, SegmentMetadataQuery.AnalysisType.MINMAX, SegmentMetadataQuery.AnalysisType.AGGREGATORS}).merge(true).build();
        int placementSize = 0;
        int overallSize = 153543;
        if (bitmaps) {
            placementSize = 10881;
            overallSize = 201345;
        }
        HashMap<String, AggregatorFactory> expectedAggregators = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory agg : TestIndex.METRIC_AGGS) {
            expectedAggregators.put(agg.getName(), agg.getCombiningFactory());
        }
        this.expectedSegmentAnalysis1 = new SegmentAnalysis(id1.toString(), (List)ImmutableList.of((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), new LinkedHashMap(ImmutableMap.of((Object)"__time", (Object)new ColumnAnalysis(ColumnType.LONG, ValueType.LONG.toString(), false, false, 12090L, null, null, null, null), (Object)"index", (Object)new ColumnAnalysis(ColumnType.DOUBLE, ValueType.DOUBLE.toString(), false, false, 9672L, null, null, null, null), (Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, (long)placementSize, Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null))), (long)overallSize, 1209L, expectedAggregators, null, null, null);
        this.expectedSegmentAnalysis2 = new SegmentAnalysis(id2.toString(), (List)ImmutableList.of((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), new LinkedHashMap(ImmutableMap.of((Object)"__time", (Object)new ColumnAnalysis(ColumnType.LONG, ValueType.LONG.toString(), false, false, 12090L, null, null, null, null), (Object)"index", (Object)new ColumnAnalysis(ColumnType.DOUBLE, ValueType.DOUBLE.toString(), false, false, 9672L, null, null, null, null), (Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, (long)placementSize, Integer.valueOf(1), null, null, null))), (long)overallSize, 1209L, expectedAggregators, null, null, null);
    }

    @Test
    public void testSegmentMetadataQuery() {
        List results = this.runner1.run(QueryPlus.wrap((Query)this.testQuery)).toList();
        Assert.assertEquals(Collections.singletonList(this.expectedSegmentAnalysis1), (Object)results);
    }

    @Test
    public void testSegmentMetadataQueryWithRollupMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(0), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null), (Object)"placementish", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), true, false, 0L, Integer.valueOf(0), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, this.rollup1 != this.rollup2 ? null : Boolean.valueOf(this.rollup1));
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement", "placementish"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.ROLLUP}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithHasMultipleValuesMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(1), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null), (Object)"placementish", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), true, false, 0L, Integer.valueOf(9), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement", "placementish"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithComplexColumnMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(1), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null), (Object)"quality_uniques", (Object)new ColumnAnalysis(ColumnType.ofComplex((String)"hyperUnique"), "hyperUnique", false, true, 0L, null, null, null, null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement", "quality_uniques"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithDefaultAnalysisMerge() {
        int size = 0;
        if (this.bitmaps) {
            size = 10881;
        }
        ColumnAnalysis analysis = new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, (long)(size * 2), Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("placement", analysis);
    }

    @Test
    public void testSegmentMetadataQueryWithDefaultAnalysisMerge2() {
        int size = 0;
        if (this.bitmaps) {
            size = 6882;
        }
        ColumnAnalysis analysis = new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, (long)(size * 2), Integer.valueOf(3), (Comparable)((Object)"spot"), (Comparable)((Object)"upfront"), null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("market", analysis);
    }

    @Test
    public void testSegmentMetadataQueryWithDefaultAnalysisMerge3() {
        int size = 0;
        if (this.bitmaps) {
            size = 9765;
        }
        ColumnAnalysis analysis = new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, (long)(size * 2), Integer.valueOf(9), (Comparable)((Object)"automotive"), (Comparable)((Object)"travel"), null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("quality", analysis);
    }

    private void testSegmentMetadataQueryWithDefaultAnalysisMerge(String column, ColumnAnalysis analysis) {
        HashMap<String, AggregatorFactory> expectedAggregators = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory agg : TestIndex.METRIC_AGGS) {
            expectedAggregators.put(agg.getName(), agg.getCombiningFactory());
        }
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), (List)ImmutableList.of(this.expectedSegmentAnalysis1.getIntervals().get(0)), new LinkedHashMap(ImmutableMap.of((Object)"__time", (Object)new ColumnAnalysis(ColumnType.LONG, ValueType.LONG.toString(), false, false, 24180L, null, null, null, null), (Object)"index", (Object)new ColumnAnalysis(ColumnType.DOUBLE, ValueType.DOUBLE.toString(), false, false, 19344L, null, null, null, null), (Object)column, (Object)analysis)), this.expectedSegmentAnalysis1.getSize() + this.expectedSegmentAnalysis2.getSize(), this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), expectedAggregators, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        Query query = this.testQuery.withColumns((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("__time", "index", column)));
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithNoAnalysisTypesMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(0), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[0]).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithAggregatorsMerge() {
        HashMap<String, AggregatorFactory> expectedAggregators = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory agg : TestIndex.METRIC_AGGS) {
            expectedAggregators.put(agg.getName(), agg.getCombiningFactory());
        }
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(0), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), expectedAggregators, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.AGGREGATORS}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithAggregatorsMergeLenientStrategy() {
        HashMap<String, AggregatorFactory> expectedAggregators = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory agg : TestIndex.METRIC_AGGS) {
            expectedAggregators.put(agg.getName(), agg.getCombiningFactory());
        }
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(0), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), expectedAggregators, null, null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.AGGREGATORS}).merge(true).aggregatorMergeStrategy(AggregatorMergeStrategy.LENIENT).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithTimestampSpecMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(0), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, new TimestampSpec("ds", "auto", null), null, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.TIMESTAMPSPEC}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testSegmentMetadataQueryWithQueryGranularityMerge() {
        SegmentAnalysis mergedSegmentAnalysis = new SegmentAnalysis(this.differentIds ? "merged" : SegmentId.dummy((String)DATASOURCE).toString(), null, new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, false, 0L, Integer.valueOf(0), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null))), 0L, this.expectedSegmentAnalysis1.getNumRows() + this.expectedSegmentAnalysis2.getNumRows(), null, null, Granularities.NONE, null);
        QueryToolChest toolChest = FACTORY.getToolchest();
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{toolChest.preMergeQueryDecoration(this.runner1), toolChest.preMergeQueryDecoration(this.runner2)}))), toolChest);
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.QUERYGRANULARITY}).merge(true).build();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)mergedSegmentAnalysis), myRunner.run(QueryPlus.wrap((Query)query)), "failed SegmentMetadata merging query");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResults() {
        Result bySegmentResult = new Result(((Interval)this.expectedSegmentAnalysis1.getIntervals().get(0)).getStart(), (Object)new BySegmentResultValueClass(Collections.singletonList(this.expectedSegmentAnalysis1), this.expectedSegmentAnalysis1.getId(), (Interval)this.testQuery.getIntervals().get(0)));
        QueryToolChest toolChest = FACTORY.getToolchest();
        QueryRunner singleSegmentQueryRunner = toolChest.preMergeQueryDecoration(this.runner1);
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{singleSegmentQueryRunner, singleSegmentQueryRunner}))), toolChest);
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)bySegmentResult, (Object)bySegmentResult), myRunner.run(QueryPlus.wrap((Query)this.testQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true)))), "failed SegmentMetadata bySegment query");
        exec.shutdownNow();
    }

    @Test
    public void testSerde() throws Exception {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\",\n  \"intervals\":[\"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z\"],\n  \"analysisTypes\":[\"cardinality\",\"size\"]\n}";
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysisTypes = EnumSet.of(SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE);
        Query query = (Query)MAPPER.readValue(queryStr, Query.class);
        Assert.assertTrue((boolean)(query instanceof SegmentMetadataQuery));
        Assert.assertEquals((Object)"test_ds", (Object)Iterables.getOnlyElement((Iterable)query.getDataSource().getTableNames()));
        Assert.assertEquals((Object)Intervals.of((String)"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z"), query.getIntervals().get(0));
        Assert.assertEquals(expectedAnalysisTypes, (Object)((SegmentMetadataQuery)query).getAnalysisTypes());
        Assert.assertEquals((Object)AggregatorMergeStrategy.STRICT, (Object)((SegmentMetadataQuery)query).getAggregatorMergeStrategy());
        Assert.assertEquals((Object)query, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)query), Query.class));
        Assert.assertEquals((Object)query, (Object)Druids.SegmentMetadataQueryBuilder.copy((SegmentMetadataQuery)((SegmentMetadataQuery)query)).build());
    }

    @Test
    public void testSerdeWithDefaultInterval() throws Exception {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\"\n}";
        Query query = (Query)MAPPER.readValue(queryStr, Query.class);
        Assert.assertTrue((boolean)(query instanceof SegmentMetadataQuery));
        Assert.assertTrue((boolean)(query.getDataSource() instanceof TableDataSource));
        Assert.assertEquals((Object)"test_ds", (Object)Iterables.getOnlyElement((Iterable)query.getDataSource().getTableNames()));
        Assert.assertEquals((Object)Intervals.ETERNITY, query.getIntervals().get(0));
        Assert.assertTrue((boolean)((SegmentMetadataQuery)query).isUsingDefaultInterval());
        Assert.assertEquals((Object)AggregatorMergeStrategy.STRICT, (Object)((SegmentMetadataQuery)query).getAggregatorMergeStrategy());
        Assert.assertEquals((Object)query, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)query), Query.class));
        Assert.assertEquals((Object)query, (Object)Druids.SegmentMetadataQueryBuilder.copy((SegmentMetadataQuery)((SegmentMetadataQuery)query)).build());
    }

    @Test
    public void testSerdeWithLatestAggregatorStrategy() throws Exception {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\",\n  \"aggregatorMergeStrategy\":\"latest\"\n}";
        Query query = (Query)MAPPER.readValue(queryStr, Query.class);
        Assert.assertTrue((boolean)(query instanceof SegmentMetadataQuery));
        Assert.assertTrue((boolean)(query.getDataSource() instanceof TableDataSource));
        Assert.assertEquals((Object)"test_ds", (Object)Iterables.getOnlyElement((Iterable)query.getDataSource().getTableNames()));
        Assert.assertEquals((Object)Intervals.ETERNITY, query.getIntervals().get(0));
        Assert.assertTrue((boolean)((SegmentMetadataQuery)query).isUsingDefaultInterval());
        Assert.assertEquals((Object)AggregatorMergeStrategy.LATEST, (Object)((SegmentMetadataQuery)query).getAggregatorMergeStrategy());
        Assert.assertEquals((Object)query, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)query), Query.class));
        Assert.assertEquals((Object)query, (Object)Druids.SegmentMetadataQueryBuilder.copy((SegmentMetadataQuery)((SegmentMetadataQuery)query)).build());
    }

    @Test
    public void testSerdeWithBothDeprecatedAndNewParameters() {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\",\n  \"lenientAggregatorMerge\":\"true\",\n  \"aggregatorMergeStrategy\":\"lenient\"\n}";
        ValueInstantiationException exception = (ValueInstantiationException)Assert.assertThrows(ValueInstantiationException.class, () -> {
            Query cfr_ignored_0 = (Query)MAPPER.readValue(queryStr, Query.class);
        });
        Assert.assertTrue((boolean)exception.getCause().getMessage().contains("Both lenientAggregatorMerge [true] and aggregatorMergeStrategy [lenient] parameters cannot be set. Consider using aggregatorMergeStrategy since lenientAggregatorMerge is deprecated."));
    }

    @Test
    public void testDefaultIntervalAndFiltering() {
        SegmentMetadataQuery testQuery = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("placement"))).merge(true).build();
        Assert.assertTrue((boolean)testQuery.isUsingDefaultInterval());
        Assert.assertEquals((Object)Intervals.ETERNITY, testQuery.getIntervals().get(0));
        Assert.assertEquals((long)testQuery.getIntervals().size(), (long)1L);
        List<LogicalSegment> testSegments = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01T01/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-05/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-05-20/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-01-05/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-02-05/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-19T01/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-20T02/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        });
        List filteredSegments = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).filterSegments(testQuery, testSegments);
        List<LogicalSegment> expectedSegments = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-19T01/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-20T02/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        });
        Assert.assertEquals((long)filteredSegments.size(), (long)2L);
        for (int i = 0; i < filteredSegments.size(); ++i) {
            Assert.assertEquals((Object)expectedSegments.get(i).getInterval(), (Object)((LogicalSegment)filteredSegments.get(i)).getInterval());
        }
        SegmentMetadataQueryConfig twoYearPeriodCfg = new SegmentMetadataQueryConfig("P2Y");
        List filteredSegments2 = new SegmentMetadataQueryQueryToolChest(twoYearPeriodCfg).filterSegments(testQuery, testSegments);
        List<LogicalSegment> expectedSegments2 = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-05-20/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-01-05/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2014-02-05/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-19T01/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015-01-20T02/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        });
        Assert.assertEquals((long)filteredSegments2.size(), (long)5L);
        for (int i = 0; i < filteredSegments2.size(); ++i) {
            Assert.assertEquals((Object)expectedSegments2.get(i).getInterval(), (Object)((LogicalSegment)filteredSegments2.get(i)).getInterval());
        }
    }

    @Test
    public void testCacheKeyWithListColumnIncluderator() {
        SegmentMetadataQuery oneColumnQuery = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("foo"))).build();
        SegmentMetadataQuery twoColumnQuery = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("fo", "o"))).build();
        byte[] oneColumnQueryCacheKey = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).getCacheStrategy(oneColumnQuery).computeCacheKey((Query)oneColumnQuery);
        byte[] twoColumnQueryCacheKey = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).getCacheStrategy(twoColumnQuery).computeCacheKey((Query)twoColumnQuery);
        Assert.assertFalse((boolean)Arrays.equals(oneColumnQueryCacheKey, twoColumnQueryCacheKey));
    }

    @Test
    public void testAnanlysisTypesBeingSet() {
        SegmentMetadataQuery query1 = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("foo"))).build();
        SegmentMetadataQuery query2 = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("foo"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.MINMAX}).build();
        SegmentMetadataQueryConfig emptyCfg = new SegmentMetadataQueryConfig();
        SegmentMetadataQueryConfig analysisCfg = new SegmentMetadataQueryConfig();
        analysisCfg.setDefaultAnalysisTypes(EnumSet.of(SegmentMetadataQuery.AnalysisType.CARDINALITY));
        EnumSet analysis1 = query1.withFinalizedAnalysisTypes(emptyCfg).getAnalysisTypes();
        EnumSet analysis2 = query2.withFinalizedAnalysisTypes(emptyCfg).getAnalysisTypes();
        EnumSet analysisWCfg1 = query1.withFinalizedAnalysisTypes(analysisCfg).getAnalysisTypes();
        EnumSet analysisWCfg2 = query2.withFinalizedAnalysisTypes(analysisCfg).getAnalysisTypes();
        EnumSet expectedAnalysis1 = new SegmentMetadataQueryConfig().getDefaultAnalysisTypes();
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysis2 = EnumSet.of(SegmentMetadataQuery.AnalysisType.MINMAX);
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysisWCfg1 = EnumSet.of(SegmentMetadataQuery.AnalysisType.CARDINALITY);
        EnumSet<SegmentMetadataQuery.AnalysisType> expectedAnalysisWCfg2 = EnumSet.of(SegmentMetadataQuery.AnalysisType.MINMAX);
        Assert.assertEquals((Object)analysis1, (Object)expectedAnalysis1);
        Assert.assertEquals((Object)analysis2, expectedAnalysis2);
        Assert.assertEquals((Object)analysisWCfg1, expectedAnalysisWCfg1);
        Assert.assertEquals((Object)analysisWCfg2, expectedAnalysisWCfg2);
    }

    @Test
    public void testLongNullableColumn() {
        ColumnAnalysis analysis = new ColumnAnalysis(ColumnType.LONG, ValueType.LONG.toString(), false, !NullHandling.replaceWithDefault(), 19344L, null, null, null, null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("longNumericNull", analysis);
    }

    @Test
    public void testDoubleNullableColumn() {
        ColumnAnalysis analysis = new ColumnAnalysis(ColumnType.DOUBLE, ValueType.DOUBLE.toString(), false, !NullHandling.replaceWithDefault(), 19344L, null, null, null, null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("doubleNumericNull", analysis);
    }

    @Test
    public void testFloatNullableColumn() {
        ColumnAnalysis analysis = new ColumnAnalysis(ColumnType.FLOAT, ValueType.FLOAT.toString(), false, !NullHandling.replaceWithDefault(), 19344L, null, null, null, null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("floatNumericNull", analysis);
    }

    @Test
    public void testStringNullOnlyColumn() {
        ColumnAnalysis analysis = new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.toString(), false, true, 0L, Integer.valueOf(1), (Comparable)((Object)NullHandling.defaultStringValue()), (Comparable)((Object)NullHandling.defaultStringValue()), null);
        this.testSegmentMetadataQueryWithDefaultAnalysisMerge("null_column", analysis);
    }

    @Test
    public void testSegmentMetadataQueryWithInvalidDatasourceTypes() {
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new SegmentMetadataQuery((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[0]), (RowSignature)RowSignature.builder().add("column", ColumnType.STRING).build()), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, null)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid dataSource type [InlineDataSource{signature={column:STRING}}]. SegmentMetadataQuery only supports table or union datasources."));
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new SegmentMetadataQuery((DataSource)new LookupDataSource("lookyloo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, null)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid dataSource type [LookupDataSource{lookupName='lookyloo'}]. SegmentMetadataQuery only supports table or union datasources."));
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new SegmentMetadataQuery((DataSource)JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, null)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid dataSource type [JoinDataSource{left=table1, right=table2, rightPrefix='j.', condition=x == \"j.x\", joinType=LEFT, leftFilter=null}]. SegmentMetadataQuery only supports table or union datasources."));
    }

    @Test
    public void testSegmentMetadataQueryWithAggregatorMergeStrictStrategy() {
        Assert.assertEquals((Object)AggregatorMergeStrategy.STRICT, (Object)new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, null).getAggregatorMergeStrategy());
        Assert.assertEquals((Object)AggregatorMergeStrategy.STRICT, (Object)new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false), null).getAggregatorMergeStrategy());
        Assert.assertEquals((Object)AggregatorMergeStrategy.STRICT, (Object)new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, AggregatorMergeStrategy.STRICT).getAggregatorMergeStrategy());
    }

    @Test
    public void testSegmentMetadataQueryWithAggregatorMergeLenientStrategy() {
        Assert.assertEquals((Object)AggregatorMergeStrategy.LENIENT, (Object)new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(true), null).getAggregatorMergeStrategy());
        Assert.assertEquals((Object)AggregatorMergeStrategy.LENIENT, (Object)new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, AggregatorMergeStrategy.LENIENT).getAggregatorMergeStrategy());
    }

    @Test
    public void testSegmentMetadataQueryWithAggregatorMergeLatestStrategy() {
        Assert.assertEquals((Object)AggregatorMergeStrategy.LATEST, (Object)new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), null, AggregatorMergeStrategy.LATEST).getAggregatorMergeStrategy());
    }

    @Test
    public void testSegmentMetadataQueryWithBothDeprecatedAndNewParameter() {
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false), AggregatorMergeStrategy.STRICT)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Both lenientAggregatorMerge [false] and aggregatorMergeStrategy [strict] parameters cannot be set. Consider using aggregatorMergeStrategy since lenientAggregatorMerge is deprecated."));
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(true), AggregatorMergeStrategy.LENIENT)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Both lenientAggregatorMerge [true] and aggregatorMergeStrategy [lenient] parameters cannot be set. Consider using aggregatorMergeStrategy since lenientAggregatorMerge is deprecated."));
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new SegmentMetadataQuery((DataSource)new TableDataSource("foo"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false), AggregatorMergeStrategy.LATEST)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Both lenientAggregatorMerge [false] and aggregatorMergeStrategy [latest] parameters cannot be set. Consider using aggregatorMergeStrategy since lenientAggregatorMerge is deprecated."));
    }
}

