/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;

public class RowsAndColumnsHelper {
    private final Map<String, ColumnHelper> helpers = new LinkedHashMap<String, ColumnHelper>();
    private Set<String> fullColumnSet;
    private AtomicReference<Integer> expectedSize = new AtomicReference();

    public static void assertEquals(RowsAndColumns rac, String name, int[] expectedResults) {
        Column column = rac.findColumn(name);
        Assert.assertNotNull((Object)column);
        ColumnAccessor accessor = column.toAccessor();
        Assert.assertEquals((long)expectedResults.length, (long)accessor.numRows());
        for (int i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((String)StringUtils.format((String)"%s[%s]", (Object[])new Object[]{name, i}), (long)expectedResults[i], (long)accessor.getInt(i));
        }
    }

    public static void assertEquals(RowsAndColumns rac, String name, long[] expectedResults) {
        Column column = rac.findColumn(name);
        Assert.assertNotNull((Object)column);
        ColumnAccessor accessor = column.toAccessor();
        Assert.assertEquals((long)expectedResults.length, (long)accessor.numRows());
        for (int i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((String)StringUtils.format((String)"%s[%s]", (Object[])new Object[]{name, i}), (long)expectedResults[i], (long)accessor.getLong(i));
        }
    }

    public static void assertEquals(RowsAndColumns rac, String name, double[] expectedResults) {
        Column column = rac.findColumn(name);
        Assert.assertNotNull((Object)column);
        ColumnAccessor accessor = column.toAccessor();
        Assert.assertEquals((long)expectedResults.length, (long)accessor.numRows());
        for (int i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((String)StringUtils.format((String)"%s[%s]", (Object[])new Object[]{name, i}), (double)expectedResults[i], (double)accessor.getDouble(i), (double)0.0);
        }
    }

    public RowsAndColumnsHelper expectColumn(String col, int[] expectedVals) {
        ColumnHelper helper = this.columnHelper(col, expectedVals.length, ColumnType.LONG);
        helper.setExpectation(expectedVals);
        return this;
    }

    public RowsAndColumnsHelper expectColumn(String col, long[] expectedVals) {
        ColumnHelper helper = this.columnHelper(col, expectedVals.length, ColumnType.LONG);
        helper.setExpectation(expectedVals);
        return this;
    }

    public RowsAndColumnsHelper expectColumn(String col, double[] expectedVals) {
        ColumnHelper helper = this.columnHelper(col, expectedVals.length, ColumnType.DOUBLE);
        helper.setExpectation(expectedVals);
        return this;
    }

    public RowsAndColumnsHelper expectColumn(String col, float[] expectedVals) {
        ColumnHelper helper = this.columnHelper(col, expectedVals.length, ColumnType.FLOAT);
        helper.setExpectation(expectedVals);
        return this;
    }

    public RowsAndColumnsHelper expectColumn(String col, ColumnType type, Object ... expectedVals) {
        return this.expectColumn(col, expectedVals, type);
    }

    public RowsAndColumnsHelper expectColumn(String col, Object[] expectedVals, ColumnType type) {
        IntArrayList nullPositions = new IntArrayList();
        for (int i = 0; i < expectedVals.length; ++i) {
            if (expectedVals[i] != null) continue;
            nullPositions.add(i);
        }
        ColumnHelper helper = this.columnHelper(col, expectedVals.length, type);
        helper.setExpectation(expectedVals);
        if (!nullPositions.isEmpty()) {
            helper.setNulls(nullPositions.toIntArray());
        }
        return this;
    }

    public ColumnHelper columnHelper(String column, int expectedSize, ColumnType expectedType) {
        if (this.expectedSize.get() == null) {
            this.expectedSize.set(expectedSize);
        }
        Assert.assertEquals((String)"Columns should be defined with same size", (long)this.expectedSize.get().intValue(), (long)expectedSize);
        ColumnHelper retVal = this.helpers.get(column);
        if (retVal == null) {
            retVal = new ColumnHelper(expectedSize, expectedType);
            this.helpers.put(column, retVal);
            return retVal;
        }
        throw new ISE("column[%s] expectations already defined, size[%s], type[%s]", new Object[]{column, retVal.expectedVals.length, retVal.expectedType});
    }

    public RowsAndColumnsHelper expectFullColumns(Set<String> fullColumnSet) {
        this.fullColumnSet = fullColumnSet;
        return this;
    }

    public RowsAndColumnsHelper allColumnsRegistered() {
        this.fullColumnSet = ImmutableSet.copyOf(this.helpers.keySet());
        return this;
    }

    public void validate(RowsAndColumns rac) {
        this.validate("", rac);
    }

    public void validate(String name, RowsAndColumns rac) {
        if (this.fullColumnSet != null) {
            Collection columnNames = rac.getColumnNames();
            Assert.assertEquals((String)name, (long)this.fullColumnSet.size(), (long)columnNames.size());
            Assert.assertTrue((String)name, (boolean)this.fullColumnSet.containsAll(columnNames));
        }
        for (Map.Entry<String, ColumnHelper> entry : this.helpers.entrySet()) {
            Column racColumn = rac.findColumn(entry.getKey());
            Assert.assertNotNull((Object)racColumn);
            entry.getValue().validate(StringUtils.format((String)"%s.%s", (Object[])new Object[]{name, entry.getKey()}), racColumn);
        }
    }

    public static class ColumnHelper {
        private final ColumnType expectedType;
        private final Object[] expectedVals;
        private final boolean[] expectedNulls;

        public ColumnHelper(int expectedSize, ColumnType expectedType) {
            this.expectedType = expectedType;
            this.expectedVals = new Object[expectedSize];
            this.expectedNulls = new boolean[this.expectedVals.length];
        }

        public ColumnHelper setExpectation(int[] expectedVals) {
            for (int i = 0; i < expectedVals.length; ++i) {
                this.expectedVals[i] = expectedVals[i];
            }
            return this;
        }

        public ColumnHelper setExpectation(long[] expectedVals) {
            for (int i = 0; i < expectedVals.length; ++i) {
                this.expectedVals[i] = expectedVals[i];
            }
            return this;
        }

        public ColumnHelper setExpectation(double[] expectedVals) {
            for (int i = 0; i < expectedVals.length; ++i) {
                this.expectedVals[i] = expectedVals[i];
            }
            return this;
        }

        public ColumnHelper setExpectation(float[] expectedVals) {
            for (int i = 0; i < expectedVals.length; ++i) {
                this.expectedVals[i] = Float.valueOf(expectedVals[i]);
            }
            return this;
        }

        public ColumnHelper setExpectation(Object[] expectedVals) {
            System.arraycopy(expectedVals, 0, this.expectedVals, 0, expectedVals.length);
            return this;
        }

        public ColumnHelper setNulls(int[] nullIndexes) {
            for (int nullIndex : nullIndexes) {
                this.expectedNulls[nullIndex] = true;
            }
            return this;
        }

        public void validate(String msgBase, Column col) {
            ColumnAccessor accessor = col.toAccessor();
            Assert.assertEquals((String)msgBase, (Object)this.expectedType, (Object)accessor.getType());
            Assert.assertEquals((String)msgBase, (long)this.expectedVals.length, (long)accessor.numRows());
            for (int i = 0; i < accessor.numRows(); ++i) {
                String msg = StringUtils.format((String)"%s[%s]", (Object[])new Object[]{msgBase, i});
                Object expectedVal = this.expectedVals[i];
                if (expectedVal == null) {
                    Assert.assertTrue((String)msg, (boolean)this.expectedNulls[i]);
                    Assert.assertTrue((String)msg, (boolean)accessor.isNull(i));
                    Assert.assertNull((String)msg, (Object)accessor.getObject(i));
                }
                Assert.assertEquals((String)(msg + " is null?"), (Object)this.expectedNulls[i], (Object)accessor.isNull(i));
                if (expectedVal instanceof Float) {
                    if (this.expectedNulls[i]) {
                        Assert.assertEquals((String)msg, (double)0.0, (double)accessor.getFloat(i), (double)0.0);
                        continue;
                    }
                    Assert.assertEquals((String)msg, (double)((Float)expectedVal).floatValue(), (double)accessor.getFloat(i), (double)0.0);
                    continue;
                }
                if (expectedVal instanceof Double) {
                    if (this.expectedNulls[i]) {
                        Assert.assertEquals((String)msg, (double)0.0, (double)accessor.getDouble(i), (double)0.0);
                        continue;
                    }
                    Assert.assertEquals((String)msg, (double)((Double)expectedVal), (double)accessor.getDouble(i), (double)0.0);
                    continue;
                }
                if (expectedVal instanceof Integer) {
                    if (this.expectedNulls[i]) {
                        Assert.assertEquals((String)msg, (long)0L, (long)accessor.getInt(i));
                        continue;
                    }
                    Assert.assertEquals((String)msg, (long)((Integer)expectedVal).intValue(), (long)accessor.getInt(i));
                    continue;
                }
                if (expectedVal instanceof Long) {
                    if (this.expectedNulls[i]) {
                        Assert.assertEquals((String)msg, (long)0L, (long)accessor.getLong(i));
                        continue;
                    }
                    Assert.assertEquals((String)msg, (long)((Long)expectedVal), (long)accessor.getLong(i));
                    continue;
                }
                if (expectedVal instanceof Object[]) {
                    Object actualVal = accessor.getObject(i);
                    if (this.expectedNulls[i]) {
                        Assert.assertNull((String)msg, (Object)accessor.getObject(i));
                        continue;
                    }
                    if (actualVal instanceof ArrayList) {
                        Assert.assertArrayEquals((String)msg, (Object[])((Object[])this.expectedVals[i]), (Object[])((ArrayList)actualVal).toArray());
                        continue;
                    }
                    Assert.assertArrayEquals((String)msg, (Object[])((Object[])this.expectedVals[i]), (Object[])((Object[])actualVal));
                    continue;
                }
                if (this.expectedNulls[i]) {
                    Assert.assertNull((String)msg, (Object)accessor.getObject(i));
                    Assert.assertNull((String)msg, (Object)expectedVal);
                    continue;
                }
                Object obj = accessor.getObject(i);
                Assert.assertNotNull((String)msg, (Object)obj);
                Assert.assertEquals((String)msg, (Object)expectedVal, (Object)obj);
            }
        }
    }
}

