/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.collect.Lists;
import java.util.function.Function;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.LazilyDecoratedRowsAndColumns;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class EvaluateRowsAndColumnsTest
extends SemanticTestBase {
    public EvaluateRowsAndColumnsTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testMaterializeColumns() {
        Object[][] vals = new Object[][]{{1L, "a", 123L, new Object[]{"xyz", "x"}, 0L}, {2L, "a", 456L, new Object[]{"abc"}, 1L}, {3L, "b", 789L, new Object[]{null}, 2L}, {4L, null, 123L, null, 3L}};
        RowSignature siggy = RowSignature.builder().add("__time", ColumnType.LONG).add("dim", ColumnType.STRING).add("val", ColumnType.LONG).add("array", ColumnType.STRING_ARRAY).add("arrayIndex", ColumnType.LONG).build();
        RowsAndColumns base = this.make(MapOfColumnsRowsAndColumns.fromRowObjects((Object[][])vals, (RowSignature)siggy));
        Object[][] expectedArr = new Object[][]{{"xyz", "x"}, {"abc"}, {null}, null};
        new RowsAndColumnsHelper().expectColumn("array", (Object[])expectedArr, ColumnType.STRING_ARRAY).validate(base);
        Assume.assumeNotNull((Object[])new Object[]{"skipping: CursorFactory not supported", base.as(CursorFactory.class)});
        LazilyDecoratedRowsAndColumns ras = new LazilyDecoratedRowsAndColumns(base, null, null, VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("expr", "val * 2", ColumnType.LONG, TestExprMacroTable.INSTANCE)}), OffsetLimit.NONE, null, null);
        ras.numRows();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"__time", "dim", "val", "array", "arrayIndex", "expr"}), (Object)ras.getColumnNames());
        new RowsAndColumnsHelper().expectColumn("expr", new long[]{246L, 912L, 1578L, 246L}).validate((RowsAndColumns)ras);
        new RowsAndColumnsHelper().expectColumn("dim", new String[]{"a", "a", "b", null}, ColumnType.STRING).validate((RowsAndColumns)ras);
        new RowsAndColumnsHelper().expectColumn("array", (Object[])expectedArr, ColumnType.STRING_ARRAY).validate((RowsAndColumns)ras);
    }
}

